// Generated by delombok at Tue Nov 26 15:50:35 UTC 2024
package gov.cms.fiss.pricers.esrd.api.v2;

import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithFourFractionDigits;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;

@Schema(description = "The additional payment information for the claim.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-OTHER-DATA", value = "<structure>")})})
public class AdditionalPaymentData {
  @BigDecimalScale(scale = 3)
  @DecimalMin("0")
  @DecimalMax("9.999")
  @Digits(integer = 1, fraction = 3)
  @Schema(description = "The age adjustment factor used.", example = "1.068", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-AGE-FACTOR", value = "PIC 9(01)V9(03)"), @ExtensionProperty(name = "PPS-2011-AGE-FACTOR", value = "PIC 9(01)V9(03)")})})
  @FixedValue
  private BigDecimal ageAdjustmentFactor;
  @BigDecimalScale(scale = 4)
  @DecimalMin("0")
  @DecimalMax("9.9999")
  @Digits(integer = 1, fraction = 4)
  @Schema(description = "The body-mass index (BMI) adjustment factor used.", example = "1.0683", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-BMI-FACTOR", value = "PIC 9(01)V9(04)"), @ExtensionProperty(name = "PPS-2011-BMI-FACTOR", value = "PIC 9(01)V9(04)")})})
  @FixedValue
  private BigDecimal bodyMassIndexFactor;
  @BigDecimalScale(scale = 4)
  @Schema(description = "The body-surface area (BSA) adjustment factor used.", example = "4.3825", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-BSA-FACTOR", value = "PIC 9(01)V9(04)"), @ExtensionProperty(name = "PPS-2011-BSA-FACTOR", value = "PIC 9(01)V9(04)")})})
  @ValidDecimalOutputWithFourFractionDigits
  private BigDecimal bodySurfaceAreaFactor;
  @BigDecimalScale(scale = 4)
  @DecimalMin("0")
  @DecimalMax("9.9999")
  @Digits(integer = 1, fraction = 4)
  @Schema(description = "The budget neutrality rate amount.", example = "0.9116", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-BDGT-NEUT-RATE", value = "PIC 9(01)V9(04)"), @ExtensionProperty(name = "PPS-2011-BDGT-NEUT-RATE", value = "PIC 9(01)V9(04)")})})
  @FixedValue
  private BigDecimal budgetNeutralityRate;
  @BigDecimalScale(scale = 5)
  @DecimalMin("0")
  @DecimalMax("9.99999")
  @Digits(integer = 1, fraction = 5)
  @Schema(description = "The national labor percent.", example = "0.46205", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-NAT-LABOR-PCT", value = "PIC 9(01)V9(05)"), @ExtensionProperty(name = "PPS-2011-NAT-LABOR-PCT", value = "PIC 9(01)V9(05)")})})
  @FixedValue
  private BigDecimal nationalLaborPercent;
  @BigDecimalScale(scale = 5)
  @DecimalMin("0")
  @DecimalMax("9.99999")
  @Digits(integer = 1, fraction = 5)
  @Schema(description = "The national non-labor percent.", example = "0.53795", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-NAT-NONLABOR-PCT", value = "PIC 9(01)V9(05)"), @ExtensionProperty(name = "PPS-2011-NAT-NONLABOR-PCT", value = "PIC 9(01)V9(05)")})})
  @FixedValue
  private BigDecimal nationalNonLaborPercent;
  @BigDecimalScale
  @Schema(description = "The wage-adjusted payment rate.", example = "324.23", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-WAGE-ADJ-RATE", value = "PIC 9(04)V9(02)"), @ExtensionProperty(name = "PPS-2011-WAGE-ADJ-RATE", value = "PIC 9(04)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal wageAdjustmentRate;

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getAgeAdjustmentFactor() {
    return this.ageAdjustmentFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBodyMassIndexFactor() {
    return this.bodyMassIndexFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBodySurfaceAreaFactor() {
    return this.bodySurfaceAreaFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBudgetNeutralityRate() {
    return this.budgetNeutralityRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNationalLaborPercent() {
    return this.nationalLaborPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNationalNonLaborPercent() {
    return this.nationalNonLaborPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getWageAdjustmentRate() {
    return this.wageAdjustmentRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAgeAdjustmentFactor(final BigDecimal ageAdjustmentFactor) {
    this.ageAdjustmentFactor = ageAdjustmentFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBodyMassIndexFactor(final BigDecimal bodyMassIndexFactor) {
    this.bodyMassIndexFactor = bodyMassIndexFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBodySurfaceAreaFactor(final BigDecimal bodySurfaceAreaFactor) {
    this.bodySurfaceAreaFactor = bodySurfaceAreaFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBudgetNeutralityRate(final BigDecimal budgetNeutralityRate) {
    this.budgetNeutralityRate = budgetNeutralityRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNationalLaborPercent(final BigDecimal nationalLaborPercent) {
    this.nationalLaborPercent = nationalLaborPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNationalNonLaborPercent(final BigDecimal nationalNonLaborPercent) {
    this.nationalNonLaborPercent = nationalNonLaborPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setWageAdjustmentRate(final BigDecimal wageAdjustmentRate) {
    this.wageAdjustmentRate = wageAdjustmentRate;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof AdditionalPaymentData)) return false;
    final AdditionalPaymentData other = (AdditionalPaymentData) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$ageAdjustmentFactor = this.getAgeAdjustmentFactor();
    final java.lang.Object other$ageAdjustmentFactor = other.getAgeAdjustmentFactor();
    if (this$ageAdjustmentFactor == null ? other$ageAdjustmentFactor != null : !this$ageAdjustmentFactor.equals(other$ageAdjustmentFactor)) return false;
    final java.lang.Object this$bodyMassIndexFactor = this.getBodyMassIndexFactor();
    final java.lang.Object other$bodyMassIndexFactor = other.getBodyMassIndexFactor();
    if (this$bodyMassIndexFactor == null ? other$bodyMassIndexFactor != null : !this$bodyMassIndexFactor.equals(other$bodyMassIndexFactor)) return false;
    final java.lang.Object this$bodySurfaceAreaFactor = this.getBodySurfaceAreaFactor();
    final java.lang.Object other$bodySurfaceAreaFactor = other.getBodySurfaceAreaFactor();
    if (this$bodySurfaceAreaFactor == null ? other$bodySurfaceAreaFactor != null : !this$bodySurfaceAreaFactor.equals(other$bodySurfaceAreaFactor)) return false;
    final java.lang.Object this$budgetNeutralityRate = this.getBudgetNeutralityRate();
    final java.lang.Object other$budgetNeutralityRate = other.getBudgetNeutralityRate();
    if (this$budgetNeutralityRate == null ? other$budgetNeutralityRate != null : !this$budgetNeutralityRate.equals(other$budgetNeutralityRate)) return false;
    final java.lang.Object this$nationalLaborPercent = this.getNationalLaborPercent();
    final java.lang.Object other$nationalLaborPercent = other.getNationalLaborPercent();
    if (this$nationalLaborPercent == null ? other$nationalLaborPercent != null : !this$nationalLaborPercent.equals(other$nationalLaborPercent)) return false;
    final java.lang.Object this$nationalNonLaborPercent = this.getNationalNonLaborPercent();
    final java.lang.Object other$nationalNonLaborPercent = other.getNationalNonLaborPercent();
    if (this$nationalNonLaborPercent == null ? other$nationalNonLaborPercent != null : !this$nationalNonLaborPercent.equals(other$nationalNonLaborPercent)) return false;
    final java.lang.Object this$wageAdjustmentRate = this.getWageAdjustmentRate();
    final java.lang.Object other$wageAdjustmentRate = other.getWageAdjustmentRate();
    if (this$wageAdjustmentRate == null ? other$wageAdjustmentRate != null : !this$wageAdjustmentRate.equals(other$wageAdjustmentRate)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof AdditionalPaymentData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $ageAdjustmentFactor = this.getAgeAdjustmentFactor();
    result = result * PRIME + ($ageAdjustmentFactor == null ? 43 : $ageAdjustmentFactor.hashCode());
    final java.lang.Object $bodyMassIndexFactor = this.getBodyMassIndexFactor();
    result = result * PRIME + ($bodyMassIndexFactor == null ? 43 : $bodyMassIndexFactor.hashCode());
    final java.lang.Object $bodySurfaceAreaFactor = this.getBodySurfaceAreaFactor();
    result = result * PRIME + ($bodySurfaceAreaFactor == null ? 43 : $bodySurfaceAreaFactor.hashCode());
    final java.lang.Object $budgetNeutralityRate = this.getBudgetNeutralityRate();
    result = result * PRIME + ($budgetNeutralityRate == null ? 43 : $budgetNeutralityRate.hashCode());
    final java.lang.Object $nationalLaborPercent = this.getNationalLaborPercent();
    result = result * PRIME + ($nationalLaborPercent == null ? 43 : $nationalLaborPercent.hashCode());
    final java.lang.Object $nationalNonLaborPercent = this.getNationalNonLaborPercent();
    result = result * PRIME + ($nationalNonLaborPercent == null ? 43 : $nationalNonLaborPercent.hashCode());
    final java.lang.Object $wageAdjustmentRate = this.getWageAdjustmentRate();
    result = result * PRIME + ($wageAdjustmentRate == null ? 43 : $wageAdjustmentRate.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "AdditionalPaymentData(ageAdjustmentFactor=" + this.getAgeAdjustmentFactor() + ", bodyMassIndexFactor=" + this.getBodyMassIndexFactor() + ", bodySurfaceAreaFactor=" + this.getBodySurfaceAreaFactor() + ", budgetNeutralityRate=" + this.getBudgetNeutralityRate() + ", nationalLaborPercent=" + this.getNationalLaborPercent() + ", nationalNonLaborPercent=" + this.getNationalNonLaborPercent() + ", wageAdjustmentRate=" + this.getWageAdjustmentRate() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public AdditionalPaymentData() {
  }
}
