/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.fqhc;

import gov.cms.fiss.pricers.common.application.OpenApiPricerApplication;
import gov.cms.fiss.pricers.common.application.contract.OpenApiCustomizer;
import gov.cms.fiss.pricers.fqhc.FqhcPricerConfiguration;
import gov.cms.fiss.pricers.fqhc.core.FqhcPricerDispatch;
import gov.cms.fiss.pricers.fqhc.resources.FqhcClaimPricingResource;
import io.dropwizard.setup.Environment;
import io.swagger.v3.oas.models.info.Info;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FqhcPricerApplication
extends OpenApiPricerApplication<FqhcPricerConfiguration> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(FqhcPricerApplication.class);

    public static void main(String[] args) throws Exception {
        new FqhcPricerApplication().run(args);
    }

    @Override
    protected void configureApplication(FqhcPricerConfiguration configuration, Environment environment) {
        FqhcClaimPricingResource v2Resource = new FqhcClaimPricingResource(new FqhcPricerDispatch(configuration));
        environment.jersey().register(v2Resource);
    }

    @Override
    protected List<OpenApiCustomizer> getContractCustomizers() {
        ArrayList<OpenApiCustomizer> customizers = new ArrayList<OpenApiCustomizer>(super.getContractCustomizers());
        customizers.add((configuration, environment, oas) -> oas.info(new Info().title("FQHC Pricer").version("v1")));
        return customizers;
    }

    @Override
    public String getName() {
        return "fqhc-pricer";
    }

    @Override
    protected List<Package> getResourcePackages() {
        return Collections.singletonList(FqhcClaimPricingResource.class.getPackage());
    }

    @Override
    protected Map<Integer, String> getCalculationVersions() {
        return Map.ofEntries(Map.entry(2025, "2025.1"), Map.entry(2024, "2025.1"), Map.entry(2023, "2025.1"), Map.entry(2022, "2025.1"), Map.entry(2021, "2025.1"), Map.entry(2020, "2025.1"), Map.entry(2019, "2025.1"), Map.entry(2018, "2025.1"), Map.entry(2017, "2025.1"), Map.entry(2016, "2025.1"), Map.entry(2015, "2025.1"));
    }
}

