/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.fqhc.core;

import gov.cms.fiss.pricers.common.api.ReturnCodeData;
import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.application.rules.CalculationContext;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.fqhc.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.fqhc.api.v2.ServiceLinePaymentData;
import gov.cms.fiss.pricers.fqhc.core.FqhcPricerContext;
import gov.cms.fiss.pricers.fqhc.core.ReturnCode;
import gov.cms.fiss.pricers.fqhc.core.daily.DailyRates;
import gov.cms.fiss.pricers.fqhc.core.daily.DaySummary;
import gov.cms.fiss.pricers.fqhc.core.tables.DataTables;
import java.math.BigDecimal;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ServiceLineContext
extends CalculationContext<IoceServiceLineData, ServiceLinePaymentData> {
    public static final String REV_CODE_MA_CLAIM = "0519";
    public static final String REV_CODE_PREFIX = "052";
    public static final String LI_ACTION_NON_COVERED = "5";
    private static final String[] LI_NOT_DENY_REJECT = new String[]{"0", "3"};
    public static final String PI_PAID_GFTF = "14";
    public static final String PI_IOP_SERVICE_15 = "15";
    public static final String PI_MA_SERVICE_IOP_WRAP_AROUND_16 = "16";
    public static final String PI_PAID_WITH_ADD_ON = "13";
    public static final String PI_NO_ADDITIONAL_PAYMENT = "12";
    public static final String PI_NOT_PAID = "11";
    public static final String PI_PAID_ENCOUNTER = "10";
    public static final String PI_TELEHEALTH = "2";
    public static final String PACKAGE_NONE = "0";
    public static final String PACKAGE_ENCOUNTER = "5";
    public static final String PACKAGE_PREVENTIVE = "6";
    public static final String LINE_OTHER = "00";
    public static final String LINE_MEDICAL = "01";
    public static final String LINE_MENTAL = "02";
    public static final String LINE_MOD59 = "03";
    public static final String LINE_IOP_LTE3 = "04";
    public static final String LINE_IOP_GTE4 = "05";
    private static final String[] PPS_PAYMENT_FLAGS = new String[]{"5", "Z"};
    private static final String[] COINSURANCE_NA_PAYMENT_FLAGS = new String[]{"C", "V"};
    private static final String[] PAID_LINE = new String[]{"10", "13", "14", "15", "16"};
    private static final String[] VALID_INDICATORS = new String[]{"10", "13", "14", "12", "11", "2", "15", "16"};
    private static final String[] PACKAGE_FLAGS = new String[]{"0", "5", "6"};
    private static final String[] VALID_LINE_TYPES = new String[]{"00", "01", "02", "03", "04", "05"};
    private final FqhcPricerContext fqhcPricerContext;
    @FixedValue
    private BigDecimal ppsRate = BigDecimalUtils.ZERO;
    @FixedValue
    private DailyRates dailyRates;
    private BigDecimal unreducedPayment = BigDecimalUtils.ZERO;

    public boolean isValidRevenueCode() {
        return ((IoceServiceLineData)this.getInput()).getRevenueCode().startsWith(REV_CODE_PREFIX);
    }

    public ServiceLineContext(IoceServiceLineData input, ServiceLinePaymentData output, FqhcPricerContext fqhcPricerContext) {
        super(input, output);
        this.fqhcPricerContext = fqhcPricerContext;
        this.initializeContext();
    }

    private void initializeContext() {
        ReturnCodeData returnCodeData = new ReturnCodeData();
        returnCodeData.setCode(LINE_OTHER);
        returnCodeData.setDescription("No description available");
        ((ServiceLinePaymentData)this.getOutput()).setReturnCodeData(returnCodeData);
    }

    public static boolean isInvalidLineType(String lineType) {
        return !StringUtils.equalsAny(lineType, VALID_LINE_TYPES);
    }

    public static boolean isInvalidPackageFlag(String packageFlag) {
        return !StringUtils.equalsAny(packageFlag, PACKAGE_FLAGS);
    }

    public static boolean isInvalidPaymentIndicator(String paymentIndicator) {
        return !StringUtils.equalsAny(paymentIndicator, VALID_INDICATORS);
    }

    public static boolean isPaidLine(String paymentIndicator) {
        return StringUtils.equalsAny(paymentIndicator, PAID_LINE);
    }

    public boolean isNotDenyOrRejectFlag() {
        return StringUtils.equalsAny(((IoceServiceLineData)this.getInput()).getDenyOrRejectFlag(), LI_NOT_DENY_REJECT);
    }

    public boolean isCoinsuranceNAPaymentFlag() {
        return StringUtils.equalsAny(((IoceServiceLineData)this.getInput()).getPaymentMethodFlag(), COINSURANCE_NA_PAYMENT_FLAGS);
    }

    public static String[] getPpsPaymentFlags() {
        return ArrayUtils.clone(PPS_PAYMENT_FLAGS);
    }

    public boolean isNotValidPaymentMethodFlag() {
        return !StringUtils.equalsAny(((IoceServiceLineData)this.getInput()).getPaymentMethodFlag(), ArrayUtils.addAll(COINSURANCE_NA_PAYMENT_FLAGS, PPS_PAYMENT_FLAGS));
    }

    public void completeWithReturnCode(ReturnCode returnCode) {
        this.applyReturnCode(returnCode);
        this.setCalculationCompleted();
    }

    public void applyReturnCode(ReturnCode returnCode) {
        ((ServiceLinePaymentData)this.getOutput()).setReturnCodeData(returnCode.toReturnCodeData());
    }

    public DataTables getDataTables() {
        return this.fqhcPricerContext.getDataTables(((IoceServiceLineData)this.getInput()).getDateOfService());
    }

    public DaySummary getDaySummary() {
        return this.fqhcPricerContext.getDaySummary(((IoceServiceLineData)this.getInput()).getDateOfService());
    }

    @Generated
    public FqhcPricerContext getFqhcPricerContext() {
        return this.fqhcPricerContext;
    }

    @Generated
    public BigDecimal getPpsRate() {
        return this.ppsRate;
    }

    @Generated
    public void setPpsRate(BigDecimal ppsRate) {
        this.ppsRate = ppsRate;
    }

    @Generated
    public DailyRates getDailyRates() {
        return this.dailyRates;
    }

    @Generated
    public void setDailyRates(DailyRates dailyRates) {
        this.dailyRates = dailyRates;
    }

    @Generated
    public BigDecimal getUnreducedPayment() {
        return this.unreducedPayment;
    }

    @Generated
    public void setUnreducedPayment(BigDecimal unreducedPayment) {
        this.unreducedPayment = unreducedPayment;
    }
}

