/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.fqhc.core.rules.processing;

import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import gov.cms.fiss.pricers.fqhc.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.fqhc.api.v2.ServiceLinePaymentData;
import gov.cms.fiss.pricers.fqhc.core.FqhcPricerContext;
import gov.cms.fiss.pricers.fqhc.core.ServiceLineContext;
import gov.cms.fiss.pricers.fqhc.core.daily.DaySummary;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import org.apache.commons.lang3.StringUtils;

public class CalculatePaymentRates
implements CalculationRule<IoceServiceLineData, ServiceLinePaymentData, ServiceLineContext> {
    @Override
    public void calculate(ServiceLineContext calculationContext) {
        IoceServiceLineData ioceServiceLine = (IoceServiceLineData)calculationContext.getInput();
        ServiceLinePaymentData serviceLinePayment = (ServiceLinePaymentData)calculationContext.getOutput();
        DaySummary daySummary = calculationContext.getDaySummary();
        FqhcPricerContext fqhcPricerContext = calculationContext.getFqhcPricerContext();
        if (StringUtils.equalsAny(ioceServiceLine.getPaymentIndicator(), "14", "10")) {
            calculationContext.setPpsRate(daySummary.getBaseRate().multiply(daySummary.getGafRate()).setScale(2, RoundingMode.HALF_UP));
        }
        if (StringUtils.equals(ioceServiceLine.getPaymentIndicator(), "13")) {
            @FixedValue BigDecimal ppsPreAddon = daySummary.getBaseRate().multiply(daySummary.getGafRate()).setScale(2, RoundingMode.HALF_UP);
            calculationContext.setPpsRate(ppsPreAddon.multiply(daySummary.getAddRate()).setScale(2, RoundingMode.HALF_UP));
            serviceLinePayment.setAddOnPayment(ppsPreAddon.subtract(calculationContext.getPpsRate()).abs());
        }
        if (LocalDateUtils.inRange(fqhcPricerContext.getClaimData().getServiceFromDate(), calculationContext.getFqhcPricerContext().getIopStartDate(), LocalDate.of(2024, 12, 31)) && StringUtils.equalsAny(ioceServiceLine.getPaymentIndicator(), "16", "15")) {
            calculationContext.setPpsRate(daySummary.getIopRateLte3());
        }
        if (LocalDateUtils.isAfterOrEqual(fqhcPricerContext.getClaimData().getServiceFromDate(), calculationContext.getFqhcPricerContext().getIopSplitStartDate()) && StringUtils.equalsAny(ioceServiceLine.getPaymentIndicator(), "16", "15")) {
            if (StringUtils.equals(ioceServiceLine.getCompositeAdjustmentFlag(), "04")) {
                calculationContext.setPpsRate(daySummary.getIopRateLte3());
            } else if (StringUtils.equals(ioceServiceLine.getCompositeAdjustmentFlag(), "05")) {
                calculationContext.setPpsRate(daySummary.getIopRateGte4());
            }
        }
    }
}

