/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.fqhc.core.rules.processing;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.fqhc.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.fqhc.api.v2.ServiceLinePaymentData;
import gov.cms.fiss.pricers.fqhc.core.ReturnCode;
import gov.cms.fiss.pricers.fqhc.core.ServiceLineContext;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;

public class SetNonMAClaimLineReturnCodes
implements CalculationRule<IoceServiceLineData, ServiceLinePaymentData, ServiceLineContext> {
    @Override
    public boolean shouldExecute(ServiceLineContext calculationContext) {
        return !calculationContext.getFqhcPricerContext().isMaClaim() || !StringUtils.equals(((IoceServiceLineData)calculationContext.getInput()).getRevenueCode(), "0519");
    }

    @Override
    public void calculate(ServiceLineContext calculationContext) {
        IoceServiceLineData ioceServiceLine = (IoceServiceLineData)calculationContext.getInput();
        ServiceLinePaymentData serviceLinePayment = (ServiceLinePaymentData)calculationContext.getOutput();
        BigDecimal ppsRate = calculationContext.getPpsRate();
        if (StringUtils.equalsAny(ioceServiceLine.getPaymentIndicator(), "10", "15")) {
            if (BigDecimalUtils.equals(serviceLinePayment.getPayment(), ppsRate)) {
                serviceLinePayment.setReturnCodeData(ReturnCode.LINE_PAY_BASED_ON_PPS_RATE_01.toReturnCodeData());
            } else {
                serviceLinePayment.setReturnCodeData(ReturnCode.LINE_PAY_BASED_ON_PROV_SUB_CHRGS_02.toReturnCodeData());
                serviceLinePayment.setAddOnPayment(BigDecimalUtils.ZERO);
            }
        }
        if (StringUtils.equals(ioceServiceLine.getPaymentIndicator(), "13")) {
            if (BigDecimalUtils.equals(serviceLinePayment.getPayment(), ppsRate)) {
                serviceLinePayment.setReturnCodeData(ReturnCode.LINE_PAY_BASED_ON_PPS_RATE_W_ADD_ON_PAY_05.toReturnCodeData());
            } else {
                serviceLinePayment.setReturnCodeData(ReturnCode.LINE_PAY_BASED_ON_PROV_SUB_CHRGS_02.toReturnCodeData());
                serviceLinePayment.setAddOnPayment(BigDecimalUtils.ZERO);
            }
        }
        if (StringUtils.equals(ioceServiceLine.getPaymentIndicator(), "14")) {
            if (BigDecimalUtils.equals(serviceLinePayment.getPayment(), ppsRate)) {
                serviceLinePayment.setReturnCodeData(ReturnCode.LINE_PAY_BASED_ON_GF_TRIBAL_PAY_21.toReturnCodeData());
            } else {
                serviceLinePayment.setReturnCodeData(ReturnCode.LINE_PAY_BASED_ON_GF_TRIBAL_SUB_CHRGS_22.toReturnCodeData());
                serviceLinePayment.setAddOnPayment(BigDecimalUtils.ZERO);
            }
        }
    }
}

