/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.fqhc.core.rules.validation;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.fqhc.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.fqhc.api.v2.ServiceLinePaymentData;
import gov.cms.fiss.pricers.fqhc.core.ReturnCode;
import gov.cms.fiss.pricers.fqhc.core.ServiceLineContext;
import org.apache.commons.lang3.StringUtils;

public class ValidateIoceFlags
implements CalculationRule<IoceServiceLineData, ServiceLinePaymentData, ServiceLineContext> {
    @Override
    public void calculate(ServiceLineContext calculationContext) {
        IoceServiceLineData ioceServiceLine = (IoceServiceLineData)calculationContext.getInput();
        ServiceLinePaymentData serviceLinePayment = (ServiceLinePaymentData)calculationContext.getOutput();
        this.validateFlags(calculationContext);
        if (Integer.parseInt(serviceLinePayment.getReturnCodeData().getCode()) >= 10 || StringUtils.equalsAny(ioceServiceLine.getPaymentIndicator(), "2", "11")) {
            calculationContext.setCalculationCompleted();
        }
    }

    protected void validateFlags(ServiceLineContext calculationContext) {
        IoceServiceLineData lineInput = (IoceServiceLineData)calculationContext.getInput();
        ServiceLinePaymentData serviceLinePayment = (ServiceLinePaymentData)calculationContext.getOutput();
        if (StringUtils.equals(lineInput.getActionFlag(), "5")) {
            serviceLinePayment.setReturnCodeData(ReturnCode.LINE_ITEM_ACTION_FLAG_INVALID_15.toReturnCodeData());
            return;
        }
        if (!calculationContext.isNotDenyOrRejectFlag()) {
            serviceLinePayment.setReturnCodeData(ReturnCode.LINE_ITEM_DENIAL_OR_REJ_FLAG_INVALID_14.toReturnCodeData());
            return;
        }
        if (ServiceLineContext.isInvalidPaymentIndicator(lineInput.getPaymentIndicator())) {
            serviceLinePayment.setReturnCodeData(ReturnCode.LINE_PAY_IND_INVALID_11.toReturnCodeData());
            return;
        }
        if (ServiceLineContext.isInvalidPackageFlag(lineInput.getPackageFlag())) {
            serviceLinePayment.setReturnCodeData(ReturnCode.LINE_PACK_FLAG_INVALID_13.toReturnCodeData());
            return;
        }
        if (calculationContext.isNotValidPaymentMethodFlag()) {
            serviceLinePayment.setReturnCodeData(ReturnCode.LINE_PAY_METHOD_FLAG_INVALID_10.toReturnCodeData());
            return;
        }
        if (ServiceLineContext.isInvalidLineType(lineInput.getCompositeAdjustmentFlag())) {
            serviceLinePayment.setReturnCodeData(ReturnCode.LINE_COMP_ADJ_FLAG_INVALID_12.toReturnCodeData());
        }
    }
}

