/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.fqhc.core.rules.validation.rates.summary;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.fqhc.api.v2.IoceServiceLineData;
import gov.cms.fiss.pricers.fqhc.api.v2.ServiceLinePaymentData;
import gov.cms.fiss.pricers.fqhc.core.FqhcPricerContext;
import gov.cms.fiss.pricers.fqhc.core.ServiceLineContext;
import gov.cms.fiss.pricers.fqhc.core.daily.DaySummary;
import org.apache.commons.lang3.StringUtils;

public class ProcessCompositeAdjustmentFlag
implements CalculationRule<IoceServiceLineData, ServiceLinePaymentData, ServiceLineContext> {
    @Override
    public void calculate(ServiceLineContext calculationContext) {
        IoceServiceLineData ioceServiceLine = (IoceServiceLineData)calculationContext.getInput();
        FqhcPricerContext fqhcPricerContext = calculationContext.getFqhcPricerContext();
        DaySummary summary = fqhcPricerContext.getDaySummary(ioceServiceLine.getDateOfService());
        if (StringUtils.equals("01", ioceServiceLine.getCompositeAdjustmentFlag())) {
            summary.setTotalMedicalCharges(summary.getTotalMedicalCharges().add(ioceServiceLine.getCoveredCharges()));
            if (ServiceLineContext.isPaidLine(ioceServiceLine.getPaymentIndicator())) {
                summary.setMedicalPaidLinePresent(true);
            }
        }
        if (StringUtils.equalsAny(ioceServiceLine.getCompositeAdjustmentFlag(), "04", "05") && !StringUtils.equals("5", ioceServiceLine.getPackageFlag())) {
            summary.setTotalIopCharges(summary.getTotalIopCharges().add(ioceServiceLine.getCoveredCharges()));
            if (ServiceLineContext.isPaidLine(ioceServiceLine.getPaymentIndicator())) {
                summary.setIopChargesPresent(true);
            }
        }
        if (StringUtils.equals("02", ioceServiceLine.getCompositeAdjustmentFlag())) {
            summary.setTotalMentalCharges(summary.getTotalMentalCharges().add(ioceServiceLine.getCoveredCharges()));
            if (ServiceLineContext.isPaidLine(ioceServiceLine.getPaymentIndicator())) {
                summary.setMentalPaidLinePresent(true);
            }
        }
        if (StringUtils.equals("03", ioceServiceLine.getCompositeAdjustmentFlag())) {
            summary.setTotalMod59Charges(summary.getTotalMod59Charges().add(ioceServiceLine.getCoveredCharges()));
            if (ServiceLineContext.isPaidLine(ioceServiceLine.getPaymentIndicator())) {
                summary.setMod59PaidLinePresent(true);
            }
        }
    }
}

