/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.fqhc.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvContentReader;
import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.common.csv.LookupGenerator;
import gov.cms.fiss.pricers.fqhc.core.tables.PaymentRateTableEntry;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaymentRateTableEntryLookupGenerator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PaymentRateTableEntryLookupGenerator.class);
    private final CsvContentReader<PaymentRateTableEntry> contentProvider = new CsvContentReader<PaymentRateTableEntry>(PaymentRateTableEntry.class).customizeSchema(CsvContentReader.HEADER_ROW_CUSTOMIZER);

    public PaymentRateTableEntryLookupGenerator(CsvIngestionConfiguration csvIngestionConfiguration) {
        if (!csvIngestionConfiguration.isValidationEnabled()) {
            this.contentProvider.disableValidation();
        }
    }

    public NavigableMap<LocalDate, BigDecimal> generate(String csvFilename) {
        List<PaymentRateTableEntry> content = this.contentProvider.read(csvFilename);
        return LookupGenerator.generateMap(PaymentRateTableEntry::getEffectiveDate, PaymentRateTableEntry::getRateValue, content, TreeMap::new);
    }
}

