// Generated by delombok at Tue Jan 14 16:25:34 UTC 2025
package gov.cms.fiss.pricers.fqhc.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvContentReader;
import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.common.csv.LookupGenerator;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;

/**
 * Creates the lookup table needed for CBSA per-year data.
 */
public class AddOnRateTableEntryLookupGenerator {
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private static final org.slf4j.Logger LOGGER = org.slf4j.LoggerFactory.getLogger(AddOnRateTableEntryLookupGenerator.class);
  private static final String CSV_FILE_NAME = "/addon.csv";
  private final CsvContentReader<AddOnRateTableEntry> contentProvider = new CsvContentReader<>(AddOnRateTableEntry.class).customizeSchema(CsvContentReader.HEADER_ROW_CUSTOMIZER);

  public AddOnRateTableEntryLookupGenerator(CsvIngestionConfiguration csvIngestionConfiguration) {
    if (!csvIngestionConfiguration.isValidationEnabled()) {
      contentProvider.disableValidation();
    }
  }

  /**
   * Generates the lookup cross-reference for the default source.
   *
   * @return the generated lookup
   */
  public NavigableMap<LocalDate, BigDecimal> generate() {
    return generate(CSV_FILE_NAME);
  }

  /**
   * Generates the lookup cross-reference from the specified source.
   *
   * @param csvFilename the file to process
   * @return the generated lookup
   */
  public NavigableMap<LocalDate, BigDecimal> generate(String csvFilename) {
    final List<AddOnRateTableEntry> content = contentProvider.read(csvFilename);
    return LookupGenerator.generateMap(AddOnRateTableEntry::getEffectiveDate, AddOnRateTableEntry::getRateValue, content, TreeMap::new);
  }
}
