// Generated by delombok at Tue Jan 14 16:25:34 UTC 2025
package gov.cms.fiss.pricers.fqhc.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvContentReader;
import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.common.csv.LookupGenerator;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.BinaryOperator;
import java.util.stream.Collector;
import java.util.stream.Collectors;

/**
 * Creates the lookup table needed for CBSA per-year data.
 */
public class GAFRateTableEntryLookupGenerator {
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private static final org.slf4j.Logger LOGGER = org.slf4j.LoggerFactory.getLogger(GAFRateTableEntryLookupGenerator.class);
  private static final String CSV_FILE_PATTERN = "/gaf-%s.csv";
  private final CsvContentReader<GAFRateTableEntry> contentProvider = new CsvContentReader<>(GAFRateTableEntry.class).customizeSchema(CsvContentReader.HEADER_ROW_CUSTOMIZER);

  public GAFRateTableEntryLookupGenerator(CsvIngestionConfiguration csvIngestionConfiguration) {
    if (!csvIngestionConfiguration.isValidationEnabled()) {
      contentProvider.disableValidation();
    }
  }

  /**
   * Generates the lookup cross-reference for the default source.
   *
   * @param fiscalYear the year for which data will be parsed
   * @return the generated lookup
   */
  public Map<String, NavigableMap<LocalDate, BigDecimal>> generate(int fiscalYear) {
    return generate(String.format(CSV_FILE_PATTERN, fiscalYear));
  }

  /**
   * Generates the lookup cross-reference from the specified source.
   *
   * @param csvFilename the file to process
   * @return the generated lookup
   */
  public Map<String, NavigableMap<LocalDate, BigDecimal>> generate(String csvFilename) {
    final List<GAFRateTableEntry> content = contentProvider.read(csvFilename);
    final Collector<GAFRateTableEntry, ?, NavigableMap<LocalDate, BigDecimal>> collector = Collectors.toMap(GAFRateTableEntry::getEffectiveDate, GAFRateTableEntry::getGeographicalAdjFactor, BinaryOperator.maxBy(Comparator.naturalOrder()), TreeMap::new);
    return LookupGenerator.generateCrossReferenceToMap(GAFRateTableEntry::getCarrierLocality, content, HashMap::new, collector);
  }
}
