// Generated by delombok at Tue Jan 14 16:24:56 UTC 2025
package gov.cms.fiss.pricers.fqhc.api.v2;

import gov.cms.fiss.pricers.common.api.ReturnCodeData;
import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@Schema(description = "The calculated result for a service line.")
public class ServiceLinePaymentData {
  @BigDecimalScale
  @DecimalMin("0")
  @DecimalMax("999999999.99")
  @Digits(integer = 9, fraction = 2)
  @NotNull
  @Schema(description = "The add-on payment.", example = "90.25", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "O-LITEM-ADD-ON-PYMT", value = "PIC 9(09)V99")})})
  @FixedValue
  private BigDecimal addOnPayment = BigDecimal.ZERO.setScale(2, RoundingMode.UNNECESSARY);
  @BigDecimalScale
  @NotNull
  @Schema(description = "The coinsurance amount.", example = "4000.60", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "O-LITEM-COIN", value = "PIC 9(09)V99")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal coinsuranceAmount = BigDecimal.ZERO.setScale(2, RoundingMode.UNNECESSARY);
  @Max(450)
  @Min(0)
  @NotNull
  @Schema(description = "The payment line number; matches the corresponding line number in the " + "claim service lines.", example = "1")
  private int lineNumber;
  @BigDecimalScale
  @Schema(description = "The Maryland Primary Care Program (MDPCP) reduction amount.", example = "250.80")
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal mdpcpReductionAmount = BigDecimalUtils.ZERO;
  @BigDecimalScale
  @NotNull
  @Schema(description = "The line payment.", example = "250.99", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "O-LITEM-PYMT", value = "PIC 9(09)V99")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal payment = BigDecimal.ZERO.setScale(2, RoundingMode.UNNECESSARY);
  @NotNull
  @Valid
  private ReturnCodeData returnCodeData;

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getAddOnPayment() {
    return this.addOnPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCoinsuranceAmount() {
    return this.coinsuranceAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getLineNumber() {
    return this.lineNumber;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getMdpcpReductionAmount() {
    return this.mdpcpReductionAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPayment() {
    return this.payment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ReturnCodeData getReturnCodeData() {
    return this.returnCodeData;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAddOnPayment(final BigDecimal addOnPayment) {
    this.addOnPayment = addOnPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCoinsuranceAmount(final BigDecimal coinsuranceAmount) {
    this.coinsuranceAmount = coinsuranceAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLineNumber(final int lineNumber) {
    this.lineNumber = lineNumber;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setMdpcpReductionAmount(final BigDecimal mdpcpReductionAmount) {
    this.mdpcpReductionAmount = mdpcpReductionAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPayment(final BigDecimal payment) {
    this.payment = payment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReturnCodeData(final ReturnCodeData returnCodeData) {
    this.returnCodeData = returnCodeData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof ServiceLinePaymentData)) return false;
    final ServiceLinePaymentData other = (ServiceLinePaymentData) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    if (this.getLineNumber() != other.getLineNumber()) return false;
    final java.lang.Object this$addOnPayment = this.getAddOnPayment();
    final java.lang.Object other$addOnPayment = other.getAddOnPayment();
    if (this$addOnPayment == null ? other$addOnPayment != null : !this$addOnPayment.equals(other$addOnPayment)) return false;
    final java.lang.Object this$coinsuranceAmount = this.getCoinsuranceAmount();
    final java.lang.Object other$coinsuranceAmount = other.getCoinsuranceAmount();
    if (this$coinsuranceAmount == null ? other$coinsuranceAmount != null : !this$coinsuranceAmount.equals(other$coinsuranceAmount)) return false;
    final java.lang.Object this$mdpcpReductionAmount = this.getMdpcpReductionAmount();
    final java.lang.Object other$mdpcpReductionAmount = other.getMdpcpReductionAmount();
    if (this$mdpcpReductionAmount == null ? other$mdpcpReductionAmount != null : !this$mdpcpReductionAmount.equals(other$mdpcpReductionAmount)) return false;
    final java.lang.Object this$payment = this.getPayment();
    final java.lang.Object other$payment = other.getPayment();
    if (this$payment == null ? other$payment != null : !this$payment.equals(other$payment)) return false;
    final java.lang.Object this$returnCodeData = this.getReturnCodeData();
    final java.lang.Object other$returnCodeData = other.getReturnCodeData();
    if (this$returnCodeData == null ? other$returnCodeData != null : !this$returnCodeData.equals(other$returnCodeData)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof ServiceLinePaymentData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    result = result * PRIME + this.getLineNumber();
    final java.lang.Object $addOnPayment = this.getAddOnPayment();
    result = result * PRIME + ($addOnPayment == null ? 43 : $addOnPayment.hashCode());
    final java.lang.Object $coinsuranceAmount = this.getCoinsuranceAmount();
    result = result * PRIME + ($coinsuranceAmount == null ? 43 : $coinsuranceAmount.hashCode());
    final java.lang.Object $mdpcpReductionAmount = this.getMdpcpReductionAmount();
    result = result * PRIME + ($mdpcpReductionAmount == null ? 43 : $mdpcpReductionAmount.hashCode());
    final java.lang.Object $payment = this.getPayment();
    result = result * PRIME + ($payment == null ? 43 : $payment.hashCode());
    final java.lang.Object $returnCodeData = this.getReturnCodeData();
    result = result * PRIME + ($returnCodeData == null ? 43 : $returnCodeData.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "ServiceLinePaymentData(addOnPayment=" + this.getAddOnPayment() + ", coinsuranceAmount=" + this.getCoinsuranceAmount() + ", lineNumber=" + this.getLineNumber() + ", mdpcpReductionAmount=" + this.getMdpcpReductionAmount() + ", payment=" + this.getPayment() + ", returnCodeData=" + this.getReturnCodeData() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public ServiceLinePaymentData() {
  }
}
