/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.api;

import gov.cms.fiss.pricers.common.api.AmbulatoryPaymentClassificationData;
import gov.cms.fiss.pricers.common.api.BasicProviderData;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidInputCbsa;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import lombok.Generated;

@Schema(description="Outpatient provider-specific data used in claim price calculations. Entries become valid on the date indicated in the `effectiveDate` field and remain in effect until superseded by an entry with a later effective date.")
public class OutpatientProviderData
extends BasicProviderData {
    @BigDecimalScale(scale=3)
    @DecimalMax(value="9.999")
    @DecimalMin(value="0")
    @Digits(integer=1, fraction=3)
    @Schema(description="The device cost-to-charge ratio derived from the latest available cost report data.", example="1.823")
    private @DecimalMax(value="9.999") @DecimalMin(value="0") @Digits(integer=1, fraction=3) BigDecimal deviceCostToChargeRatio;
    @Schema(description="The core-based statistical area (CBSA) to which a hospital has been reclassified due to its prevailing wage rates.", example="10735")
    @ValidInputCbsa
    private String paymentCbsa;
    @BigDecimalScale(scale=5)
    @DecimalMax(value="9.99999")
    @DecimalMin(value="0")
    @Digits(integer=1, fraction=5)
    @Schema(description="The adjustment derived from the payment model Technical Direction Letter.", example="1.87223")
    private @DecimalMax(value="9.99999") @DecimalMin(value="0") @Digits(integer=1, fraction=5) BigDecimal paymentModelAdjustment;
    @ArraySchema(arraySchema=@Schema(description="The reduced coinsurance by ambulatory payment classification (APC)."), uniqueItems=true)
    @Size(max=999, min=1)
    @Valid
    private @Size(max=999, min=1) @Valid List<@NotNull AmbulatoryPaymentClassificationData> reducedCoinsuranceData;
    @Pattern(regexp="[A-Z\\d]", message="must be a single digit or upper-case letter")
    @Schema(description="Indicates the type of special locality provision that applies.", example="1")
    private @Pattern(regexp="[A-Z\\d]", message="must be a single digit or upper-case letter") String specialLocalityIndicator;

    @Generated
    public BigDecimal getDeviceCostToChargeRatio() {
        return this.deviceCostToChargeRatio;
    }

    @Generated
    public String getPaymentCbsa() {
        return this.paymentCbsa;
    }

    @Generated
    public BigDecimal getPaymentModelAdjustment() {
        return this.paymentModelAdjustment;
    }

    @Generated
    public List<@NotNull AmbulatoryPaymentClassificationData> getReducedCoinsuranceData() {
        return this.reducedCoinsuranceData;
    }

    @Generated
    public String getSpecialLocalityIndicator() {
        return this.specialLocalityIndicator;
    }

    @Generated
    public void setDeviceCostToChargeRatio(BigDecimal deviceCostToChargeRatio) {
        this.deviceCostToChargeRatio = deviceCostToChargeRatio;
    }

    @Generated
    public void setPaymentCbsa(String paymentCbsa) {
        this.paymentCbsa = paymentCbsa;
    }

    @Generated
    public void setPaymentModelAdjustment(BigDecimal paymentModelAdjustment) {
        this.paymentModelAdjustment = paymentModelAdjustment;
    }

    @Generated
    public void setReducedCoinsuranceData(List<@NotNull AmbulatoryPaymentClassificationData> reducedCoinsuranceData) {
        this.reducedCoinsuranceData = reducedCoinsuranceData;
    }

    @Generated
    public void setSpecialLocalityIndicator(String specialLocalityIndicator) {
        this.specialLocalityIndicator = specialLocalityIndicator;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OutpatientProviderData)) {
            return false;
        }
        OutpatientProviderData other = (OutpatientProviderData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BigDecimal this$deviceCostToChargeRatio = this.getDeviceCostToChargeRatio();
        BigDecimal other$deviceCostToChargeRatio = other.getDeviceCostToChargeRatio();
        if (this$deviceCostToChargeRatio == null ? other$deviceCostToChargeRatio != null : !((Object)this$deviceCostToChargeRatio).equals(other$deviceCostToChargeRatio)) {
            return false;
        }
        String this$paymentCbsa = this.getPaymentCbsa();
        String other$paymentCbsa = other.getPaymentCbsa();
        if (this$paymentCbsa == null ? other$paymentCbsa != null : !this$paymentCbsa.equals(other$paymentCbsa)) {
            return false;
        }
        BigDecimal this$paymentModelAdjustment = this.getPaymentModelAdjustment();
        BigDecimal other$paymentModelAdjustment = other.getPaymentModelAdjustment();
        if (this$paymentModelAdjustment == null ? other$paymentModelAdjustment != null : !((Object)this$paymentModelAdjustment).equals(other$paymentModelAdjustment)) {
            return false;
        }
        List<AmbulatoryPaymentClassificationData> this$reducedCoinsuranceData = this.getReducedCoinsuranceData();
        List<AmbulatoryPaymentClassificationData> other$reducedCoinsuranceData = other.getReducedCoinsuranceData();
        if (this$reducedCoinsuranceData == null ? other$reducedCoinsuranceData != null : !((Object)this$reducedCoinsuranceData).equals(other$reducedCoinsuranceData)) {
            return false;
        }
        String this$specialLocalityIndicator = this.getSpecialLocalityIndicator();
        String other$specialLocalityIndicator = other.getSpecialLocalityIndicator();
        return !(this$specialLocalityIndicator == null ? other$specialLocalityIndicator != null : !this$specialLocalityIndicator.equals(other$specialLocalityIndicator));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OutpatientProviderData;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        BigDecimal $deviceCostToChargeRatio = this.getDeviceCostToChargeRatio();
        result = result * 59 + ($deviceCostToChargeRatio == null ? 43 : ((Object)$deviceCostToChargeRatio).hashCode());
        String $paymentCbsa = this.getPaymentCbsa();
        result = result * 59 + ($paymentCbsa == null ? 43 : $paymentCbsa.hashCode());
        BigDecimal $paymentModelAdjustment = this.getPaymentModelAdjustment();
        result = result * 59 + ($paymentModelAdjustment == null ? 43 : ((Object)$paymentModelAdjustment).hashCode());
        List<AmbulatoryPaymentClassificationData> $reducedCoinsuranceData = this.getReducedCoinsuranceData();
        result = result * 59 + ($reducedCoinsuranceData == null ? 43 : ((Object)$reducedCoinsuranceData).hashCode());
        String $specialLocalityIndicator = this.getSpecialLocalityIndicator();
        result = result * 59 + ($specialLocalityIndicator == null ? 43 : $specialLocalityIndicator.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "OutpatientProviderData(deviceCostToChargeRatio=" + this.getDeviceCostToChargeRatio() + ", paymentCbsa=" + this.getPaymentCbsa() + ", paymentModelAdjustment=" + this.getPaymentModelAdjustment() + ", reducedCoinsuranceData=" + this.getReducedCoinsuranceData() + ", specialLocalityIndicator=" + this.getSpecialLocalityIndicator() + ")";
    }

    @Generated
    public OutpatientProviderData() {
    }
}

