/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hha.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimData;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimPricingRequest;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimPricingResponse;
import gov.cms.fiss.pricers.hha.api.v2.HhaPaymentData;
import gov.cms.fiss.pricers.hha.core.HhaPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.temporal.ChronoUnit;

public class LateSubmissionPenalty
implements CalculationRule<HhaClaimPricingRequest, HhaClaimPricingResponse, HhaPricerContext> {
    private static final BigDecimal THIRTY_DAYS = new BigDecimal("30");

    @Override
    public boolean shouldExecute(HhaPricerContext calculationContext) {
        return BigDecimalUtils.isGreaterThanZero(calculationContext.getPaymentData().getHhrgPayment()) && !calculationContext.isLateFilingPenaltyWaiverIndicator() && calculationContext.getClaimData().getNoticeReceiptDate() != null;
    }

    @Override
    public void calculate(HhaPricerContext calculationContext) {
        HhaClaimData claimData = calculationContext.getClaimData();
        HhaPaymentData paymentData = calculationContext.getPaymentData();
        BigDecimal hrgPayment = paymentData.getHhrgPayment();
        BigDecimal outlierPayment = paymentData.getOutlierPayment();
        long daysDifference = claimData.getServiceFromDate().until(claimData.getNoticeReceiptDate(), ChronoUnit.DAYS);
        if (daysDifference <= 5L) {
            return;
        }
        daysDifference = Math.min(daysDifference, 30L);
        BigDecimal hrgPenalty = hrgPayment.multiply(BigDecimal.valueOf(daysDifference)).divide(THIRTY_DAYS, 2, RoundingMode.HALF_UP);
        BigDecimal reducedHrg = hrgPayment.subtract(hrgPenalty).abs();
        paymentData.setHhrgPayment(reducedHrg);
        BigDecimal outlierPenalty = outlierPayment.multiply(BigDecimal.valueOf(daysDifference)).divide(THIRTY_DAYS, 2, RoundingMode.HALF_UP);
        BigDecimal reducedOutlier = outlierPayment.subtract(outlierPenalty);
        paymentData.setOutlierPayment(reducedOutlier);
        paymentData.setTotalPayment(reducedHrg.add(reducedOutlier));
        paymentData.setLateSubmissionPenaltyAmount(hrgPenalty.add(outlierPenalty));
    }
}

