/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hha.core.rules.calculate_value_based_purchasing;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimPricingRequest;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimPricingResponse;
import gov.cms.fiss.pricers.hha.api.v2.HhaInpatientProviderData;
import gov.cms.fiss.pricers.hha.api.v2.HhaPaymentData;
import gov.cms.fiss.pricers.hha.core.HhaPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CalculateHhrgPayment
implements CalculationRule<HhaClaimPricingRequest, HhaClaimPricingResponse, HhaPricerContext> {
    @Override
    public boolean shouldExecute(HhaPricerContext calculationContext) {
        return BigDecimalUtils.isGreaterThanZero(calculationContext.getPaymentData().getHhrgPayment());
    }

    @Override
    public void calculate(HhaPricerContext calculationContext) {
        HhaPaymentData output = calculationContext.getPaymentData();
        BigDecimal vbpAdjustmentFactor = ((HhaInpatientProviderData)((HhaClaimPricingRequest)calculationContext.getInput()).getProviderData()).getVbpAdjustment();
        BigDecimal hrgPayment = output.getHhrgPayment().multiply(vbpAdjustmentFactor).setScale(2, RoundingMode.HALF_UP);
        output.setHhrgPayment(hrgPayment);
        output.setTotalPayment(output.getTotalPayment().add(hrgPayment));
    }
}

