/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hha.core.rules.final_calculation;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimPricingRequest;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimPricingResponse;
import gov.cms.fiss.pricers.hha.api.v2.RevenueLineData;
import gov.cms.fiss.pricers.hha.api.v2.RevenuePaymentData;
import gov.cms.fiss.pricers.hha.core.HhaPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class CalculateAddOnVisit
implements CalculationRule<HhaClaimPricingRequest, HhaClaimPricingResponse, HhaPricerContext> {
    public static final int PHYSICAL_THERAPY = 0;
    public static final int OCCUPATIONAL_THERAPY = 1;
    public static final int SPEECH_LANGUAGE_PATHOLOGY = 2;
    public static final int SKILLED_NURSING = 3;
    public static final int MEDICAL_SOCIAL_SERVICES = 4;
    public static final int HOME_HEALTH_AIDE = 5;
    private static final Map<String, Integer> CODE_PRIORITY = Map.of("0420", 2, "0430", 3, "0440", 4, "0550", 1, "0560", 5, "0570", 6);
    private static final Comparator<RevenueLineData> COMPARE_BY_EARLIEST_DATE_AND_PRIORITY = (line1, line2) -> {
        LocalDate line2Date;
        LocalDate line1Date = ObjectUtils.defaultIfNull(line1.getEarliestLineItemDate(), LocalDate.MAX);
        if (line1Date.isEqual(line2Date = ObjectUtils.defaultIfNull(line2.getEarliestLineItemDate(), LocalDate.MAX))) {
            return NumberUtils.compare(CODE_PRIORITY.get(line1.getRevenueCode()), CODE_PRIORITY.get(line2.getRevenueCode()));
        }
        return line1Date.compareTo(line2Date);
    };

    @Override
    public boolean shouldExecute(HhaPricerContext calculationContext) {
        return !calculationContext.isPartialEpisodePaymentCalculated();
    }

    @Override
    public void calculate(HhaPricerContext calculationContext) {
        List<RevenueLineData> inputRevenueData = this.getAddOnRevenueData(calculationContext.getRevenueLines());
        List<RevenuePaymentData> outputRevenueData = calculationContext.getRevenuePayments();
        inputRevenueData.sort(COMPARE_BY_EARLIEST_DATE_AND_PRIORITY);
        if (this.containsMaxDatesOnly(inputRevenueData)) {
            for (int i2 = 0; i2 < 5; ++i2) {
                outputRevenueData.get(i2).setAddOnVisitAmount(BigDecimalUtils.ZERO);
            }
            return;
        }
        String earliestRevenueCode = inputRevenueData.get(0).getRevenueCode();
        RevenuePaymentData outputRevenueEntry = outputRevenueData.get(3);
        BigDecimal lupaAddOn = calculationContext.getLupaAddOnSkilledNursing();
        switch (earliestRevenueCode) {
            case "0420": {
                outputRevenueEntry = outputRevenueData.get(0);
                lupaAddOn = calculationContext.getLupaAddOnPhysicalTherapy();
                break;
            }
            case "0430": {
                outputRevenueEntry = outputRevenueData.get(1);
                lupaAddOn = calculationContext.getLupaAddOnOccupationalTherapy();
                break;
            }
            case "0440": {
                outputRevenueEntry = outputRevenueData.get(2);
                lupaAddOn = calculationContext.getLupaAddOnSpeechLanguagePathology();
                break;
            }
            case "0550": {
                outputRevenueEntry = outputRevenueData.get(3);
                lupaAddOn = calculationContext.getLupaAddOnSkilledNursing();
                break;
            }
            case "0560": {
                outputRevenueEntry = outputRevenueData.get(4);
                lupaAddOn = BigDecimal.ZERO;
                break;
            }
            case "0570": {
                outputRevenueEntry = outputRevenueData.get(5);
                lupaAddOn = BigDecimal.ZERO;
                break;
            }
        }
        BigDecimal amount = outputRevenueEntry.getDollarRate().multiply(lupaAddOn).setScale(2, RoundingMode.HALF_UP);
        outputRevenueEntry.setAddOnVisitAmount(amount);
        calculationContext.setWsStdvLupaAddonFac(lupaAddOn);
    }

    private boolean containsMaxDatesOnly(List<RevenueLineData> revenueData) {
        for (RevenueLineData revenueLineData : revenueData) {
            if (revenueLineData.getEarliestLineItemDate() == null) continue;
            return false;
        }
        return true;
    }

    protected List<RevenueLineData> getAddOnRevenueData(List<RevenueLineData> revenueData) {
        return Stream.of(revenueData.get(0), revenueData.get(2), revenueData.get(3)).collect(Collectors.toList());
    }
}

