/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hha.core.rules.validate_input;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimData;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimPricingRequest;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimPricingResponse;
import gov.cms.fiss.pricers.hha.core.HhaPricerContext;
import gov.cms.fiss.pricers.hha.core.codes.ReturnCode;
import java.math.BigDecimal;

public class CheckInputCode
implements CalculationRule<HhaClaimPricingRequest, HhaClaimPricingResponse, HhaPricerContext> {
    @Override
    public void calculate(HhaPricerContext calculationContext) {
        HhaClaimData input = calculationContext.getClaimData();
        BigDecimal weight = calculationContext.getDataTables().getHrgWeight(input.getHhrgInputCode());
        Integer threshold = calculationContext.getDataTables().getHrgThreshold(input.getHhrgInputCode());
        if (weight == null || threshold == null) {
            calculationContext.completeWithReturnCode(ReturnCode.INVALID_INPUT_CODE_70);
            return;
        }
        calculationContext.getPaymentData().setHhrgWeight(weight);
        calculationContext.setHrgThreshold(threshold);
    }
}

