/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hha.core.rules.validate_input;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimPricingRequest;
import gov.cms.fiss.pricers.hha.api.v2.HhaClaimPricingResponse;
import gov.cms.fiss.pricers.hha.api.v2.HhaInpatientProviderData;
import gov.cms.fiss.pricers.hha.core.HhaPricerContext;
import gov.cms.fiss.pricers.hha.core.codes.ReturnCode;
import java.math.BigDecimal;
import java.time.LocalDate;

public class SetCbsaWageIndex
implements CalculationRule<HhaClaimPricingRequest, HhaClaimPricingResponse, HhaPricerContext> {
    @Override
    public boolean shouldExecute(HhaPricerContext calculationContext) {
        LocalDate serviceFromDate = calculationContext.getClaimData().getServiceFromDate();
        return !calculationContext.isBillTypeRap() || !LocalDateUtils.isAfter(serviceFromDate, LocalDate.of(2020, 12, 31));
    }

    @Override
    public void calculate(HhaPricerContext calculationContext) {
        BigDecimal wageIndex = calculationContext.getDataTables().getGeographicWageIndex(((HhaInpatientProviderData)((HhaClaimPricingRequest)calculationContext.getInput()).getProviderData()).getCbsaActualGeographicLocation(), calculationContext.getClaimData().getServiceThroughDate());
        if (wageIndex == null || BigDecimalUtils.isZero(wageIndex)) {
            calculationContext.completeWithReturnCode(ReturnCode.INVALID_CBSA_CODE_30);
            return;
        }
        calculationContext.setCbsaWageIndex(wageIndex);
    }
}

