// Generated by delombok at Thu Mar 06 01:40:35 UTC 2025
package gov.cms.fiss.pricers.hha.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.hha.HhaPricerConfiguration;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Map;
import java.util.Map.Entry;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

/**
 * This class is responsible for holding all the CopyBook data tables for the pricer as well as
 * helper methods to access the data.
 */
public class DataTables {
  private static final Map<Integer, DataTables> YEAR_LOOKUP = new ConcurrentHashMap<>();
  private final Map<String, StateCountyCodeEntry> addOnMap;
  private final Map<String, StateCountyCodeEntry> extraAddonMap;
  /**
   * CBSA wage Index lookup table.
   */
  private final Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> cbsaTable;
  /**
   * HRG lookup table.
   */
  private final Map<String, HrgEntry> hrgMap;
  /**
   * Revenue lookup table.
   */
  private final Map<String, NavigableMap<LocalDate, RevenueEntry>> revenueMap;

  public DataTables(Map<String, StateCountyCodeEntry> addOnMap, Map<String, StateCountyCodeEntry> extraAddOnMap, Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> cbsaMap, Map<String, HrgEntry> hrgMap, Map<String, NavigableMap<LocalDate, RevenueEntry>> revenueMap) {
    this.addOnMap = addOnMap;
    this.extraAddonMap = extraAddOnMap;
    this.cbsaTable = cbsaMap;
    this.revenueMap = revenueMap;
    this.hrgMap = hrgMap;
  }

  public static DataTables forYear(int pricerYear) {
    return YEAR_LOOKUP.get(pricerYear);
  }

  /**
   * Loads data tables with the given CSV ingestion configuration.
   */
  public static void loadDataTables(HhaPricerConfiguration pricerConfiguration) {
    final CsvIngestionConfiguration csvIngestionConfiguration = pricerConfiguration.getCsvIngestionConfiguration();
    final Map<String, StateCountyCodeEntry> addOnMap = new StateCountyCodeLookupGenerator(csvIngestionConfiguration).generate("/add-on-table.csv");
    final Map<String, StateCountyCodeEntry> extraAddOnMap = new StateCountyCodeLookupGenerator(csvIngestionConfiguration).generate("/extra-add-on-table.csv");
    final CbsaWageIndexLookupGenerator cbsaLookupProvider = new CbsaWageIndexLookupGenerator(csvIngestionConfiguration);
    final HrgLookupProvider hrgLookupProvider = new HrgLookupProvider(csvIngestionConfiguration);
    final RevenueLookupProvider revenueLookupProvider = new RevenueLookupProvider(csvIngestionConfiguration);
    // Load all the tables
    for (final int pricerYear : pricerConfiguration.getSupportedYears()) {
      YEAR_LOOKUP.put(pricerYear, new DataTables(addOnMap, extraAddOnMap, cbsaLookupProvider.generate(pricerYear), hrgLookupProvider.generate(pricerYear), revenueLookupProvider.generate(pricerYear)));
    }
  }

  /**
   * State and county code table search.
   *
   * <p>2000-TBL-SCC-SEARCH
   */
  public String getAddOnCategory(String code) {
    final StateCountyCodeEntry entry = addOnMap.get(code);
    return entry == null ? null : entry.getCategory();
  }

  /**
   * EXTRA COUNTY CODE TABLE SEARCH
   *
   * <pre>
   * *****************************************************************
   * RURAL COUNTY CODE TABLE LOOK UP - EXTRA                         *
   * *****************************************************************
   * </pre>
   *
   * <p>Corresponds to {@code 2100-TBL-ECC-SEARCH} in the COBOL code.
   */
  public String getExtraAddOnCategory(String code) {
    final StateCountyCodeEntry entry = extraAddonMap.get(code);
    return entry == null ? null : entry.getCategory();
  }

  private CbsaWageIndexEntry getCbsaWageIndexEntry(String code, LocalDate date) {
    final NavigableMap<LocalDate, CbsaWageIndexEntry> map = cbsaTable.get(code);
    if (map == null) {
      return null;
    }
    final Entry<LocalDate, CbsaWageIndexEntry> kvPair = map.floorEntry(date);
    if (kvPair == null) {
      return null;
    }
    return map.floorEntry(date).getValue();
  }

  public RevenueEntry getRevenueEntry(String code, LocalDate date) {
    final NavigableMap<LocalDate, RevenueEntry> map = revenueMap.get(code);
    if (map == null) {
      return null;
    }
    final Entry<LocalDate, RevenueEntry> kvPair = map.floorEntry(date);
    if (kvPair == null) {
      return null;
    }
    return map.floorEntry(date).getValue();
  }

  public BigDecimal getGeographicWageIndex(String code, LocalDate date) {
    final CbsaWageIndexEntry entry = getCbsaWageIndexEntry(StringUtils.leftPad(code, 5, "9"), date);
    if (entry == null) {
      return null;
    }
    return entry.getGeographicWageIndex();
  }

  public BigDecimal getHrgWeight(String code) {
    final HrgEntry entry = hrgMap.get(code);
    if (entry == null) {
      return null;
    }
    return entry.getWeight();
  }

  public Integer getHrgThreshold(String code) {
    final HrgEntry entry = hrgMap.get(code);
    if (entry == null) {
      return null;
    }
    return entry.getThreshold();
  }

  /**
   * CBSA wage Index lookup table.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> getCbsaTable() {
    return this.cbsaTable;
  }
}
