// Generated by delombok at Thu Mar 06 01:40:35 UTC 2025
package gov.cms.fiss.pricers.hha.core.tables;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonFormat.Shape;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.hha.core.tables.HrgEntry.Fields;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Pattern;

/**
 * Model for the HRG CSV file.
 */
@Immutable
@JsonDeserialize(builder = HrgEntry.HrgEntryBuilder.class)
@JsonPropertyOrder({Fields.CODE, Fields.EFFECTIVE_DATE, Fields.WEIGHT, Fields.THRESHOLD})
public class HrgEntry implements Comparable<HrgEntry> {

  @JsonPOJOBuilder(withPrefix = "")
  public static class HrgEntryBuilder {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String code;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private LocalDate effectiveDate;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private BigDecimal weight;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private Integer threshold;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    HrgEntryBuilder() {
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public HrgEntry.HrgEntryBuilder code(final String code) {
      this.code = code;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @JsonFormat(shape = Shape.STRING, pattern = "yyyyMMdd")
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public HrgEntry.HrgEntryBuilder effectiveDate(final LocalDate effectiveDate) {
      this.effectiveDate = effectiveDate;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public HrgEntry.HrgEntryBuilder weight(final BigDecimal weight) {
      this.weight = weight;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public HrgEntry.HrgEntryBuilder threshold(final Integer threshold) {
      this.threshold = threshold;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public HrgEntry build() {
      return new HrgEntry(this.code, this.effectiveDate, this.weight, this.threshold);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
      return "HrgEntry.HrgEntryBuilder(code=" + this.code + ", effectiveDate=" + this.effectiveDate + ", weight=" + this.weight + ", threshold=" + this.threshold + ")";
    }
  }

  @Pattern(regexp = "\\w{5}")
  private final String code;
  @JsonFormat(shape = Shape.STRING, pattern = "yyyyMMdd")
  private final LocalDate effectiveDate;
  @Digits(integer = 2, fraction = 4)
  @BigDecimalScale(scale = 4)
  private final BigDecimal weight; // HRG-WGTS
  private final Integer threshold;

  @Override
  public int compareTo(@Nonnull HrgEntry o) {
    return Comparator.comparing(HrgEntry::getEffectiveDate).compare(this, o);
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  HrgEntry(final String code, final LocalDate effectiveDate, final BigDecimal weight, final Integer threshold) {
    this.code = code;
    this.effectiveDate = effectiveDate;
    this.weight = weight;
    this.threshold = threshold;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static HrgEntry.HrgEntryBuilder builder() {
    return new HrgEntry.HrgEntryBuilder();
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof HrgEntry)) return false;
    final HrgEntry other = (HrgEntry) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$threshold = this.getThreshold();
    final java.lang.Object other$threshold = other.getThreshold();
    if (this$threshold == null ? other$threshold != null : !this$threshold.equals(other$threshold)) return false;
    final java.lang.Object this$code = this.getCode();
    final java.lang.Object other$code = other.getCode();
    if (this$code == null ? other$code != null : !this$code.equals(other$code)) return false;
    final java.lang.Object this$effectiveDate = this.getEffectiveDate();
    final java.lang.Object other$effectiveDate = other.getEffectiveDate();
    if (this$effectiveDate == null ? other$effectiveDate != null : !this$effectiveDate.equals(other$effectiveDate)) return false;
    final java.lang.Object this$weight = this.getWeight();
    final java.lang.Object other$weight = other.getWeight();
    if (this$weight == null ? other$weight != null : !this$weight.equals(other$weight)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof HrgEntry;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $threshold = this.getThreshold();
    result = result * PRIME + ($threshold == null ? 43 : $threshold.hashCode());
    final java.lang.Object $code = this.getCode();
    result = result * PRIME + ($code == null ? 43 : $code.hashCode());
    final java.lang.Object $effectiveDate = this.getEffectiveDate();
    result = result * PRIME + ($effectiveDate == null ? 43 : $effectiveDate.hashCode());
    final java.lang.Object $weight = this.getWeight();
    result = result * PRIME + ($weight == null ? 43 : $weight.hashCode());
    return result;
  }


  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static final class Fields {
    public static final java.lang.String CODE = "code";
    public static final java.lang.String EFFECTIVE_DATE = "effectiveDate";
    public static final java.lang.String WEIGHT = "weight";
    public static final java.lang.String THRESHOLD = "threshold";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCode() {
    return this.code;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LocalDate getEffectiveDate() {
    return this.effectiveDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getWeight() {
    return this.weight;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Integer getThreshold() {
    return this.threshold;
  }
}
