/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.application.errors;

import com.fasterxml.jackson.databind.JsonMappingException;
import gov.cms.fiss.pricers.common.application.request.RequestContentExtractor;
import io.dropwizard.jersey.errors.ErrorMessage;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.zalando.problem.Problem;
import org.zalando.problem.Status;

public class JsonMappingExceptionMapper
implements ExceptionMapper<JsonMappingException> {
    public static final String ERROR_MESSAGE = "Unable to process JSON";

    @Override
    public Response toResponse(JsonMappingException exception) {
        StringBuilder sb = new StringBuilder();
        if (!exception.getPath().isEmpty()) {
            for (int i2 = 0; i2 < exception.getPath().size(); ++i2) {
                if (i2 > 0) {
                    sb.append(".");
                }
                JsonMappingException.Reference item = exception.getPath().get(i2);
                sb.append(item.getFieldName());
            }
            sb.append(": ");
        }
        String message = sb + exception.getOriginalMessage();
        if (null == RequestContentExtractor.rfc7807Support()) {
            ErrorMessage errorMessage = new ErrorMessage(Status.BAD_REQUEST.getStatusCode(), ERROR_MESSAGE, message);
            return Response.status(errorMessage.getCode()).type(MediaType.APPLICATION_JSON_TYPE).entity(errorMessage).build();
        }
        return Response.status(Status.BAD_REQUEST.getStatusCode()).type("application/problem+json").entity(Problem.builder().withTitle(ERROR_MESSAGE).withDetail(message).withStatus(Status.BAD_REQUEST).build()).build();
    }
}

