/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hospice;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import gov.cms.fiss.pricers.common.application.OpenApiPricerApplication;
import gov.cms.fiss.pricers.common.application.contract.OpenApiCustomizer;
import gov.cms.fiss.pricers.common.application.resources.CbsaWageIndexResource;
import gov.cms.fiss.pricers.hospice.HospicePricerConfiguration;
import gov.cms.fiss.pricers.hospice.core.HospicePricerDispatch;
import gov.cms.fiss.pricers.hospice.core.tables.DataTables;
import gov.cms.fiss.pricers.hospice.resources.HospiceClaimPricingResource;
import gov.cms.fiss.pricers.hospice.resources.HospiceExtractionUtil;
import io.dropwizard.setup.Environment;
import io.swagger.v3.oas.models.info.Info;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class HospicePricerApplication
extends OpenApiPricerApplication<HospicePricerConfiguration> {
    public static void main(String[] args) throws Exception {
        new HospicePricerApplication().run(args);
    }

    @Override
    protected void configureApplication(HospicePricerConfiguration configuration, Environment environment) {
        DataTables.loadDataTables(configuration);
        HospiceClaimPricingResource v2Resource = new HospiceClaimPricingResource(new HospicePricerDispatch(configuration));
        environment.jersey().register(v2Resource);
        environment.jersey().register(new CbsaWageIndexResource(configuration, HospiceExtractionUtil.CBSA_EXTRACTOR));
    }

    @Override
    protected List<OpenApiCustomizer> getContractCustomizers() {
        ArrayList<OpenApiCustomizer> customizers = new ArrayList<OpenApiCustomizer>(super.getContractCustomizers());
        customizers.add((configuration, environment, oas) -> oas.info(new Info().title("Hospice Pricer").version("v1")));
        return customizers;
    }

    @Override
    protected void customizeJacksonMapper(ObjectMapper objectMapper) {
        super.customizeJacksonMapper(objectMapper);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @Override
    public String getName() {
        return "hospice-pricer";
    }

    @Override
    protected List<Package> getResourcePackages() {
        return Collections.singletonList(HospiceClaimPricingResource.class.getPackage());
    }

    @Override
    protected Map<Integer, String> getCalculationVersions() {
        return Map.of(2020, "2020.1", 2021, "2021.0", 2022, "2022.0", 2023, "2023.0", 2024, "2024.0", 2025, "2025.0");
    }
}

