/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hospice.api.v2;

import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import lombok.Generated;

@Schema(description="The bill payment calculated for the specified revenue and HCPCS codes.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-GROUP-DATAn <partial>", value="<structure>")})})
public class BillPaymentData {
    @BigDecimalScale
    @NotNull
    @Schema(description="The amount paid for this bill.", example="123.50", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-PAY-AMT-TOTAL", value="PIC 9(06)V99")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal amount;
    @Pattern(regexp="[A-Z\\d]{5}", message="must be five alphanumeric characters")
    @Schema(description="The Healthcare Common Procedure Coding System (HCPCS) G code associated with the payment revenue code.", example="G2564", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-HCPCn", value="PIC X(05)")})})
    private @Pattern(regexp="[A-Z\\d]{5}", message="must be five alphanumeric characters") String hcpcsCode;
    @NotNull
    @Pattern(regexp="065[1256]", message="must be one of `0651`, `0652`, `0655`, or `0656`")
    @Schema(description="The revenue code for which the payment was calculated.", example="0651", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-REVn", value="PIC XXXX")})})
    private @NotNull @Pattern(regexp="065[1256]", message="must be one of `0651`, `0652`, `0655`, or `0656`") String revenueCode;

    @Generated
    public BigDecimal getAmount() {
        return this.amount;
    }

    @Generated
    public String getHcpcsCode() {
        return this.hcpcsCode;
    }

    @Generated
    public String getRevenueCode() {
        return this.revenueCode;
    }

    @Generated
    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    @Generated
    public void setHcpcsCode(String hcpcsCode) {
        this.hcpcsCode = hcpcsCode;
    }

    @Generated
    public void setRevenueCode(String revenueCode) {
        this.revenueCode = revenueCode;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BillPaymentData)) {
            return false;
        }
        BillPaymentData other = (BillPaymentData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigDecimal this$amount = this.getAmount();
        BigDecimal other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        String this$hcpcsCode = this.getHcpcsCode();
        String other$hcpcsCode = other.getHcpcsCode();
        if (this$hcpcsCode == null ? other$hcpcsCode != null : !this$hcpcsCode.equals(other$hcpcsCode)) {
            return false;
        }
        String this$revenueCode = this.getRevenueCode();
        String other$revenueCode = other.getRevenueCode();
        return !(this$revenueCode == null ? other$revenueCode != null : !this$revenueCode.equals(other$revenueCode));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BillPaymentData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigDecimal $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        String $hcpcsCode = this.getHcpcsCode();
        result = result * 59 + ($hcpcsCode == null ? 43 : $hcpcsCode.hashCode());
        String $revenueCode = this.getRevenueCode();
        result = result * 59 + ($revenueCode == null ? 43 : $revenueCode.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BillPaymentData(amount=" + this.getAmount() + ", hcpcsCode=" + this.getHcpcsCode() + ", revenueCode=" + this.getRevenueCode() + ")";
    }

    @Generated
    public BillPaymentData() {
    }
}

