/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hospice.api.v2;

import gov.cms.fiss.pricers.common.api.serialization.StrictLocalDate;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.LocalDate;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import lombok.Generated;

@Schema(description="The Hospice billing group; this group is repeated 4 times.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-GROUPn", value="<repeated structure")})})
public class BillingGroupData {
    @NotNull
    @Schema(description="The line item date of service associated with the revenue code.", example="2020-04-15", format="yyyy-MM-dd", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-LINE-ITEM-DOSn", value="BILL-LIDOSn-CC       PIC 99\nBILL-LIDOSn-YY       PIC 99\nBILL-LIDOSn-MM       PIC 99\nBILL-LIDOSn-DD       PIC 99")})})
    @StrictLocalDate
    private LocalDate dateOfService;
    @Pattern(regexp="[A-Z\\d]{5}", message="must be five alphanumeric characters")
    @Schema(description="The Healthcare Common Procedure Coding System (HCPCS) G code associated with the revenue code.", example="12345", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-HCPCn", value="PIC X(05)")})})
    private @Pattern(regexp="[A-Z\\d]{5}", message="must be five alphanumeric characters") String hcpcsCode;
    @NotNull
    @Pattern(regexp="065[1256]", message="must be one of `0651`, `0652`, `0655`, or `0656`")
    @Schema(description="The revenue code for the billing group.", example="0651", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-REVn", value="PIC XXXX")})})
    private @NotNull @Pattern(regexp="065[1256]", message="must be one of `0651`, `0652`, `0655`, or `0656`") String revenueCode;
    @Max(value=9999999L)
    @Min(value=0L)
    @NotNull
    @Schema(description="The number of units associated with the revenue code.", example="1000", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-UNITSn", value="PIC 9(07)")})})
    private @Max(value=9999999L) @Min(value=0L) @NotNull Integer units;

    @Generated
    public LocalDate getDateOfService() {
        return this.dateOfService;
    }

    @Generated
    public String getHcpcsCode() {
        return this.hcpcsCode;
    }

    @Generated
    public String getRevenueCode() {
        return this.revenueCode;
    }

    @Generated
    public Integer getUnits() {
        return this.units;
    }

    @Generated
    public void setDateOfService(LocalDate dateOfService) {
        this.dateOfService = dateOfService;
    }

    @Generated
    public void setHcpcsCode(String hcpcsCode) {
        this.hcpcsCode = hcpcsCode;
    }

    @Generated
    public void setRevenueCode(String revenueCode) {
        this.revenueCode = revenueCode;
    }

    @Generated
    public void setUnits(Integer units) {
        this.units = units;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BillingGroupData)) {
            return false;
        }
        BillingGroupData other = (BillingGroupData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$units = this.getUnits();
        Integer other$units = other.getUnits();
        if (this$units == null ? other$units != null : !((Object)this$units).equals(other$units)) {
            return false;
        }
        LocalDate this$dateOfService = this.getDateOfService();
        LocalDate other$dateOfService = other.getDateOfService();
        if (this$dateOfService == null ? other$dateOfService != null : !((Object)this$dateOfService).equals(other$dateOfService)) {
            return false;
        }
        String this$hcpcsCode = this.getHcpcsCode();
        String other$hcpcsCode = other.getHcpcsCode();
        if (this$hcpcsCode == null ? other$hcpcsCode != null : !this$hcpcsCode.equals(other$hcpcsCode)) {
            return false;
        }
        String this$revenueCode = this.getRevenueCode();
        String other$revenueCode = other.getRevenueCode();
        return !(this$revenueCode == null ? other$revenueCode != null : !this$revenueCode.equals(other$revenueCode));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BillingGroupData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $units = this.getUnits();
        result = result * 59 + ($units == null ? 43 : ((Object)$units).hashCode());
        LocalDate $dateOfService = this.getDateOfService();
        result = result * 59 + ($dateOfService == null ? 43 : ((Object)$dateOfService).hashCode());
        String $hcpcsCode = this.getHcpcsCode();
        result = result * 59 + ($hcpcsCode == null ? 43 : $hcpcsCode.hashCode());
        String $revenueCode = this.getRevenueCode();
        result = result * 59 + ($revenueCode == null ? 43 : $revenueCode.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BillingGroupData(dateOfService=" + this.getDateOfService() + ", hcpcsCode=" + this.getHcpcsCode() + ", revenueCode=" + this.getRevenueCode() + ", units=" + this.getUnits() + ")";
    }

    @Generated
    public BillingGroupData() {
    }
}

