/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hospice.api.v2;

import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import lombok.Generated;

@Schema(description="The calculated payment for the corresponding end-of-life add-on day units.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-SIA-ADD-ON-PYMTS", value="<structure>")})})
public class EndOfLifeAddOnDaysPaymentData {
    @Max(value=7L)
    @Min(value=1L)
    @Schema(description="This index indicates which entry in the claim's end-of-life add-on days the payment corresponds to.", example="1")
    private @Max(value=7L) @Min(value=1L) int index;
    @BigDecimalScale
    @Schema(description="The end-of-life add-on days payment", example="123.50", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-EOL-ADD-ON-DAY1-PAY", value="PIC 9(06)V99")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal payment;

    @Generated
    public int getIndex() {
        return this.index;
    }

    @Generated
    public BigDecimal getPayment() {
        return this.payment;
    }

    @Generated
    public void setIndex(int index) {
        this.index = index;
    }

    @Generated
    public void setPayment(BigDecimal payment) {
        this.payment = payment;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EndOfLifeAddOnDaysPaymentData)) {
            return false;
        }
        EndOfLifeAddOnDaysPaymentData other = (EndOfLifeAddOnDaysPaymentData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        BigDecimal this$payment = this.getPayment();
        BigDecimal other$payment = other.getPayment();
        return !(this$payment == null ? other$payment != null : !((Object)this$payment).equals(other$payment));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EndOfLifeAddOnDaysPaymentData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIndex();
        BigDecimal $payment = this.getPayment();
        result = result * 59 + ($payment == null ? 43 : ((Object)$payment).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EndOfLifeAddOnDaysPaymentData(index=" + this.getIndex() + ", payment=" + this.getPayment() + ")";
    }

    @Generated
    public EndOfLifeAddOnDaysPaymentData() {
    }
}

