/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hospice.api.v2;

import gov.cms.fiss.pricers.common.api.ClaimData;
import gov.cms.fiss.pricers.common.api.serialization.StrictLocalDate;
import gov.cms.fiss.pricers.common.api.validation.ValidInputCbsa;
import gov.cms.fiss.pricers.hospice.api.v2.BillingGroupData;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.LocalDate;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import lombok.Generated;

@Schema(description="The Hospice claim record.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-315-DATA", value="<structure>")})})
public class HospiceClaimData
extends ClaimData {
    @NotNull
    @Schema(description="The admission date.", example="2020-04-15", format="yyyy-MM-dd", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-ADMISSION-DATE", value="BILL-ADM-CC       PIC 99\nBILL-ADM-YY       PIC 99\nBILL-ADM-MM       PIC 99\nBILL-ADM-DD       PIC 99")})})
    @StrictLocalDate
    private LocalDate admissionDate;
    @ArraySchema(arraySchema=@Schema(description="The data associated with the four billing groups for the claim."), uniqueItems=true, extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-GROUPn", value="<repeated structure")})})
    @NotEmpty
    @Size(max=4)
    @Valid
    private @NotEmpty @Size(max=4) @Valid List<@NotNull BillingGroupData> billingGroups;
    @ArraySchema(arraySchema=@Schema(description="The sum of the units associated with revenue codes 055x (if G0299 present) and 056x (other than 0569) on the date of death. No value will be provided if the line is not associated with routine home care (revenue code 0651).", example="[ 50, 12 ]"), uniqueItems=true, extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-SIA-ADD-ON-UNITS <partial>", value="BILL-EOL-ADD-ON-DAY1-UNITS  PIC 99\n BILL-EOL-ADD-ON-DAY2-UNITS  PIC 99\n BILL-EOL-ADD-ON-DAY3-UNITS  PIC 99\n BILL-EOL-ADD-ON-DAY4-UNITS  PIC 99\n BILL-EOL-ADD-ON-DAY5-UNITS  PIC 99\n BILL-EOL-ADD-ON-DAY6-UNITS  PIC 99\n BILL-EOL-ADD-ON-DAY7-UNITS  PIC 99")})})
    @Size(max=7, min=1)
    private @Size(max=7, min=1) List<@Max(value=99L) @Min(value=0L) Integer> endOfLifeAddOnDaysUnits;
    @Schema(description="The patient core-based statistical area (CBSA) code.", example="10380", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-BENE-CBSA", value="PIC X(05)"), @ExtensionProperty(name="BILL-BENE-MSA-LUGAR", value="BILL-BENE-MSA   PIC X(04)\nBILL-BENE-LUGAR   PIC X")})})
    @ValidInputCbsa
    private String patientCbsa;
    @Max(value=99L)
    @Min(value=0L)
    @Schema(description="The number of days from a prior hospice benefit period if identified by the common working file (CWF) as part of the first 60 days of routine home care (RHC).", example="4", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-NA-ADD-ON-DAYn-UNITS", value="PIC 99")})})
    private @Max(value=99L) @Min(value=0L) int priorBenefitDayUnits;
    @Schema(description="The provider core-based statistical area (CBSA) code.", example="10380", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-PROV-CBSA", value="PIC X(05)"), @ExtensionProperty(name="BILL-PROV-MSA-LUGAR", value="BILL-PROV-MSA   PIC X(04)\nBILL-PROV-LUGAR   PIC X")})})
    @ValidInputCbsa
    private String providerCbsa;
    @Pattern(regexp="1", message="must be `1` if present")
    @Schema(description="An indicator of whether the hospice's payments are subject to the 2% reduction for not reporting quality data. If false, no reduction applies; if true, a 2% reduction applies.", example="1", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-QIP-IND", value="PIC X")})})
    private @Pattern(regexp="1", message="must be `1` if present") String reportingQualityData;
    @NotNull
    @Schema(description="The start date of service.", example="2020-01-01", format="yyyy-MM-dd", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-FROM-DATE", value="BILL-FROM-CC       PIC 99\nBILL-FROM-YY       PIC 99\nBILL-FROM-MM       PIC 99\nBILL-FROM-DD       PIC 99")})})
    @StrictLocalDate
    private LocalDate serviceFromDate;

    @Generated
    public LocalDate getAdmissionDate() {
        return this.admissionDate;
    }

    @Generated
    public List<@NotNull BillingGroupData> getBillingGroups() {
        return this.billingGroups;
    }

    @Generated
    public List<@Max(value=99L) @Min(value=0L) Integer> getEndOfLifeAddOnDaysUnits() {
        return this.endOfLifeAddOnDaysUnits;
    }

    @Generated
    public String getPatientCbsa() {
        return this.patientCbsa;
    }

    @Generated
    public int getPriorBenefitDayUnits() {
        return this.priorBenefitDayUnits;
    }

    @Generated
    public String getProviderCbsa() {
        return this.providerCbsa;
    }

    @Generated
    public String getReportingQualityData() {
        return this.reportingQualityData;
    }

    @Generated
    public LocalDate getServiceFromDate() {
        return this.serviceFromDate;
    }

    @Generated
    public void setAdmissionDate(LocalDate admissionDate) {
        this.admissionDate = admissionDate;
    }

    @Generated
    public void setBillingGroups(List<@NotNull BillingGroupData> billingGroups) {
        this.billingGroups = billingGroups;
    }

    @Generated
    public void setEndOfLifeAddOnDaysUnits(List<@Max(value=99L) @Min(value=0L) Integer> endOfLifeAddOnDaysUnits) {
        this.endOfLifeAddOnDaysUnits = endOfLifeAddOnDaysUnits;
    }

    @Generated
    public void setPatientCbsa(String patientCbsa) {
        this.patientCbsa = patientCbsa;
    }

    @Generated
    public void setPriorBenefitDayUnits(int priorBenefitDayUnits) {
        this.priorBenefitDayUnits = priorBenefitDayUnits;
    }

    @Generated
    public void setProviderCbsa(String providerCbsa) {
        this.providerCbsa = providerCbsa;
    }

    @Generated
    public void setReportingQualityData(String reportingQualityData) {
        this.reportingQualityData = reportingQualityData;
    }

    @Generated
    public void setServiceFromDate(LocalDate serviceFromDate) {
        this.serviceFromDate = serviceFromDate;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HospiceClaimData)) {
            return false;
        }
        HospiceClaimData other = (HospiceClaimData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getPriorBenefitDayUnits() != other.getPriorBenefitDayUnits()) {
            return false;
        }
        LocalDate this$admissionDate = this.getAdmissionDate();
        LocalDate other$admissionDate = other.getAdmissionDate();
        if (this$admissionDate == null ? other$admissionDate != null : !((Object)this$admissionDate).equals(other$admissionDate)) {
            return false;
        }
        List<BillingGroupData> this$billingGroups = this.getBillingGroups();
        List<BillingGroupData> other$billingGroups = other.getBillingGroups();
        if (this$billingGroups == null ? other$billingGroups != null : !((Object)this$billingGroups).equals(other$billingGroups)) {
            return false;
        }
        List<Integer> this$endOfLifeAddOnDaysUnits = this.getEndOfLifeAddOnDaysUnits();
        List<Integer> other$endOfLifeAddOnDaysUnits = other.getEndOfLifeAddOnDaysUnits();
        if (this$endOfLifeAddOnDaysUnits == null ? other$endOfLifeAddOnDaysUnits != null : !((Object)this$endOfLifeAddOnDaysUnits).equals(other$endOfLifeAddOnDaysUnits)) {
            return false;
        }
        String this$patientCbsa = this.getPatientCbsa();
        String other$patientCbsa = other.getPatientCbsa();
        if (this$patientCbsa == null ? other$patientCbsa != null : !this$patientCbsa.equals(other$patientCbsa)) {
            return false;
        }
        String this$providerCbsa = this.getProviderCbsa();
        String other$providerCbsa = other.getProviderCbsa();
        if (this$providerCbsa == null ? other$providerCbsa != null : !this$providerCbsa.equals(other$providerCbsa)) {
            return false;
        }
        String this$reportingQualityData = this.getReportingQualityData();
        String other$reportingQualityData = other.getReportingQualityData();
        if (this$reportingQualityData == null ? other$reportingQualityData != null : !this$reportingQualityData.equals(other$reportingQualityData)) {
            return false;
        }
        LocalDate this$serviceFromDate = this.getServiceFromDate();
        LocalDate other$serviceFromDate = other.getServiceFromDate();
        return !(this$serviceFromDate == null ? other$serviceFromDate != null : !((Object)this$serviceFromDate).equals(other$serviceFromDate));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HospiceClaimData;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getPriorBenefitDayUnits();
        LocalDate $admissionDate = this.getAdmissionDate();
        result = result * 59 + ($admissionDate == null ? 43 : ((Object)$admissionDate).hashCode());
        List<BillingGroupData> $billingGroups = this.getBillingGroups();
        result = result * 59 + ($billingGroups == null ? 43 : ((Object)$billingGroups).hashCode());
        List<Integer> $endOfLifeAddOnDaysUnits = this.getEndOfLifeAddOnDaysUnits();
        result = result * 59 + ($endOfLifeAddOnDaysUnits == null ? 43 : ((Object)$endOfLifeAddOnDaysUnits).hashCode());
        String $patientCbsa = this.getPatientCbsa();
        result = result * 59 + ($patientCbsa == null ? 43 : $patientCbsa.hashCode());
        String $providerCbsa = this.getProviderCbsa();
        result = result * 59 + ($providerCbsa == null ? 43 : $providerCbsa.hashCode());
        String $reportingQualityData = this.getReportingQualityData();
        result = result * 59 + ($reportingQualityData == null ? 43 : $reportingQualityData.hashCode());
        LocalDate $serviceFromDate = this.getServiceFromDate();
        result = result * 59 + ($serviceFromDate == null ? 43 : ((Object)$serviceFromDate).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "HospiceClaimData(admissionDate=" + this.getAdmissionDate() + ", billingGroups=" + this.getBillingGroups() + ", endOfLifeAddOnDaysUnits=" + this.getEndOfLifeAddOnDaysUnits() + ", patientCbsa=" + this.getPatientCbsa() + ", priorBenefitDayUnits=" + this.getPriorBenefitDayUnits() + ", providerCbsa=" + this.getProviderCbsa() + ", reportingQualityData=" + this.getReportingQualityData() + ", serviceFromDate=" + this.getServiceFromDate() + ")";
    }

    @Generated
    public HospiceClaimData() {
    }
}

