/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hospice.api.v2;

import gov.cms.fiss.pricers.common.api.PaymentData;
import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.hospice.api.v2.BillPaymentData;
import gov.cms.fiss.pricers.hospice.api.v2.EndOfLifeAddOnDaysPaymentData;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import lombok.Generated;

@Schema(description="The Hospice prospective payment data.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL_GROUPn", value="<structure>"), @ExtensionProperty(name="BILL-RETURNED-DATA", value="<structure>"), @ExtensionProperty(name="BILL-RHC-DAYS-PAID", value="<structure>")})})
public class HospicePaymentData
extends PaymentData {
    @ArraySchema(arraySchema=@Schema(description="The bill payment amounts."), extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-GROUPn <partial repeated structure>", value="BILL-PAY-AMT1  PIC 9(06)V99\nBILL-PAY-AMT2  PIC 9(06)V99\nBILL-PAY-AMT3  PIC 9(06)V99\nBILL-PAY-AMT4  PIC 9(06)V99")})}, uniqueItems=true)
    @Size(max=4, min=4)
    @Valid
    private @Size(max=4, min=4) @Valid List<@NotNull BillPaymentData> billPayments;
    @ArraySchema(arraySchema=@Schema(description="The end-of-life add-on day payments. Only processed entries from the claim's end-of-life add-on days will produce an entry in this collection."), extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-SIA-ADD-ON-PYMTS <partial>", value="BILL-EOL-ADD-ON-DAY1-PAY  PIC 9(06)V99\nBILL-EOL-ADD-ON-DAY2-PAY  PIC 9(06)V99\nBILL-EOL-ADD-ON-DAY3-PAY  PIC 9(06)V99\nBILL-EOL-ADD-ON-DAY4-PAY  PIC 9(06)V99\nBILL-EOL-ADD-ON-DAY5-PAY  PIC 9(06)V99\nBILL-EOL-ADD-ON-DAY6-PAY  PIC 9(06)V99\nBILL-EOL-ADD-ON-DAY7-PAY  PIC 9(06)V99")})}, uniqueItems=true)
    @Size(max=7, min=1)
    @Valid
    private @Size(max=7, min=1) @Valid List<@NotNull EndOfLifeAddOnDaysPaymentData> endOfLifeAddOnDaysPayments;
    @NotNull
    @Max(value=99L)
    @Min(value=0L)
    @Schema(description="The high number of routine home-care days.", example="9", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-HIGH-RHC-DAYS", value="PIC 99")})})
    private @NotNull @Max(value=99L) @Min(value=0L) int highRoutineHomeCareDays;
    @NotNull
    @Max(value=99L)
    @Min(value=0L)
    @Schema(description="The low number of routine home-care days.", example="9", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-LOW-RHC-DAYS", value="PIC 99")})})
    private @NotNull @Max(value=99L) @Min(value=0L) int lowRoutineHomeCareDays;
    @NotNull
    @BigDecimalScale(scale=4)
    @DecimalMin(value="0")
    @DecimalMax(value="99.9999")
    @Digits(integer=2, fraction=4)
    @Schema(description="The patient wage index used for claim processing.", example="1.2403", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-BENE-WAGE-INDEX", value="PIC 9(02)V9(04)")})})
    @FixedValue
    private @NotNull @DecimalMin(value="0") @DecimalMax(value="99.9999") @Digits(integer=2, fraction=4) @FixedValue BigDecimal patientWageIndex;
    @NotNull
    @BigDecimalScale(scale=4)
    @DecimalMin(value="0")
    @DecimalMax(value="99.9999")
    @Digits(integer=2, fraction=4)
    @Schema(description="The provider wage index used for claim processing.", example="1.2365", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-PROV-WAGE-INDEX", value="PIC 9(02)V9(04)")})})
    private @NotNull @DecimalMin(value="0") @DecimalMax(value="99.9999") @Digits(integer=2, fraction=4) BigDecimal providerWageIndex;

    @Generated
    public List<@NotNull BillPaymentData> getBillPayments() {
        return this.billPayments;
    }

    @Generated
    public List<@NotNull EndOfLifeAddOnDaysPaymentData> getEndOfLifeAddOnDaysPayments() {
        return this.endOfLifeAddOnDaysPayments;
    }

    @Generated
    public int getHighRoutineHomeCareDays() {
        return this.highRoutineHomeCareDays;
    }

    @Generated
    public int getLowRoutineHomeCareDays() {
        return this.lowRoutineHomeCareDays;
    }

    @Generated
    public BigDecimal getPatientWageIndex() {
        return this.patientWageIndex;
    }

    @Generated
    public BigDecimal getProviderWageIndex() {
        return this.providerWageIndex;
    }

    @Generated
    public void setBillPayments(List<@NotNull BillPaymentData> billPayments) {
        this.billPayments = billPayments;
    }

    @Generated
    public void setEndOfLifeAddOnDaysPayments(List<@NotNull EndOfLifeAddOnDaysPaymentData> endOfLifeAddOnDaysPayments) {
        this.endOfLifeAddOnDaysPayments = endOfLifeAddOnDaysPayments;
    }

    @Generated
    public void setHighRoutineHomeCareDays(int highRoutineHomeCareDays) {
        this.highRoutineHomeCareDays = highRoutineHomeCareDays;
    }

    @Generated
    public void setLowRoutineHomeCareDays(int lowRoutineHomeCareDays) {
        this.lowRoutineHomeCareDays = lowRoutineHomeCareDays;
    }

    @Generated
    public void setPatientWageIndex(BigDecimal patientWageIndex) {
        this.patientWageIndex = patientWageIndex;
    }

    @Generated
    public void setProviderWageIndex(BigDecimal providerWageIndex) {
        this.providerWageIndex = providerWageIndex;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HospicePaymentData)) {
            return false;
        }
        HospicePaymentData other = (HospicePaymentData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getHighRoutineHomeCareDays() != other.getHighRoutineHomeCareDays()) {
            return false;
        }
        if (this.getLowRoutineHomeCareDays() != other.getLowRoutineHomeCareDays()) {
            return false;
        }
        List<BillPaymentData> this$billPayments = this.getBillPayments();
        List<BillPaymentData> other$billPayments = other.getBillPayments();
        if (this$billPayments == null ? other$billPayments != null : !((Object)this$billPayments).equals(other$billPayments)) {
            return false;
        }
        List<EndOfLifeAddOnDaysPaymentData> this$endOfLifeAddOnDaysPayments = this.getEndOfLifeAddOnDaysPayments();
        List<EndOfLifeAddOnDaysPaymentData> other$endOfLifeAddOnDaysPayments = other.getEndOfLifeAddOnDaysPayments();
        if (this$endOfLifeAddOnDaysPayments == null ? other$endOfLifeAddOnDaysPayments != null : !((Object)this$endOfLifeAddOnDaysPayments).equals(other$endOfLifeAddOnDaysPayments)) {
            return false;
        }
        BigDecimal this$patientWageIndex = this.getPatientWageIndex();
        BigDecimal other$patientWageIndex = other.getPatientWageIndex();
        if (this$patientWageIndex == null ? other$patientWageIndex != null : !((Object)this$patientWageIndex).equals(other$patientWageIndex)) {
            return false;
        }
        BigDecimal this$providerWageIndex = this.getProviderWageIndex();
        BigDecimal other$providerWageIndex = other.getProviderWageIndex();
        return !(this$providerWageIndex == null ? other$providerWageIndex != null : !((Object)this$providerWageIndex).equals(other$providerWageIndex));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HospicePaymentData;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getHighRoutineHomeCareDays();
        result = result * 59 + this.getLowRoutineHomeCareDays();
        List<BillPaymentData> $billPayments = this.getBillPayments();
        result = result * 59 + ($billPayments == null ? 43 : ((Object)$billPayments).hashCode());
        List<EndOfLifeAddOnDaysPaymentData> $endOfLifeAddOnDaysPayments = this.getEndOfLifeAddOnDaysPayments();
        result = result * 59 + ($endOfLifeAddOnDaysPayments == null ? 43 : ((Object)$endOfLifeAddOnDaysPayments).hashCode());
        BigDecimal $patientWageIndex = this.getPatientWageIndex();
        result = result * 59 + ($patientWageIndex == null ? 43 : ((Object)$patientWageIndex).hashCode());
        BigDecimal $providerWageIndex = this.getProviderWageIndex();
        result = result * 59 + ($providerWageIndex == null ? 43 : ((Object)$providerWageIndex).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "HospicePaymentData(billPayments=" + this.getBillPayments() + ", endOfLifeAddOnDaysPayments=" + this.getEndOfLifeAddOnDaysPayments() + ", highRoutineHomeCareDays=" + this.getHighRoutineHomeCareDays() + ", lowRoutineHomeCareDays=" + this.getLowRoutineHomeCareDays() + ", patientWageIndex=" + this.getPatientWageIndex() + ", providerWageIndex=" + this.getProviderWageIndex() + ")";
    }

    @Generated
    public HospicePaymentData() {
    }
}

