/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hospice.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.application.rules.CalculationContext;
import gov.cms.fiss.pricers.hospice.api.v2.BillingGroupData;
import gov.cms.fiss.pricers.hospice.api.v2.EndOfLifeAddOnDaysPaymentData;
import gov.cms.fiss.pricers.hospice.api.v2.HospiceClaimData;
import gov.cms.fiss.pricers.hospice.api.v2.HospiceClaimPricingRequest;
import gov.cms.fiss.pricers.hospice.api.v2.HospiceClaimPricingResponse;
import gov.cms.fiss.pricers.hospice.api.v2.HospicePaymentData;
import gov.cms.fiss.pricers.hospice.core.codes.ReturnCode;
import gov.cms.fiss.pricers.hospice.core.tables.DataTables;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public abstract class HospicePricerContext
extends CalculationContext<HospiceClaimPricingRequest, HospiceClaimPricingResponse> {
    public static final String ROUTINE_HOME_CARE_REVENUE_CODE = "0651";
    public static final String CONTINUOUS_HOME_CARE_REVENUE_CODE = "0652";
    public static final String INPATIENT_RESPITE_CARE_REVENUE_CODE = "0655";
    public static final String GENERAL_INPATIENT_CARE_REVENUE_CODE = "0656";
    @JsonIgnore
    private final DataTables dataTables;
    @FixedValue
    private BigDecimal workPayRate1 = BigDecimal.ZERO;
    private BigDecimal workPayRate2 = BigDecimal.ZERO;
    private BigDecimal workPayRate3 = BigDecimal.ZERO;
    private BigDecimal workPayRate4 = BigDecimal.ZERO;
    private BigDecimal siaPayAmountTotal;
    private int priorServiceDays;
    @FixedValue
    private BigDecimal patientWageIndex = BigDecimal.ZERO;
    @FixedValue
    private BigDecimal providerWageIndex = BigDecimal.ZERO;
    private int lowRateBillUnits;
    private int highRateBillUnits;
    private boolean siaUnitsIndicator;
    private BigDecimal siaPaymentRate;
    @FixedValue
    private BigDecimal highRateBillPayAmount = BigDecimal.ZERO;
    @FixedValue
    private BigDecimal lowRateBillPayAmount = BigDecimal.ZERO;
    private boolean routineHomeCareHighDayIndicator;
    private boolean routineHomeCareLowDayIndicator;
    private LocalDate dateOfService;

    protected HospicePricerContext(HospiceClaimPricingRequest input, HospiceClaimPricingResponse output, DataTables dataTables) {
        super(input, output);
        this.dataTables = dataTables;
        output.setCalculationVersion(this.getCalculationVersion());
        this.applyReturnCode(ReturnCode.HOME_RATE_RETURNED_00);
        this.initializeContext();
    }

    protected void initializeContext() {
        this.getPaymentData().setPatientWageIndex(this.getPatientWageIndex());
        this.getPaymentData().setProviderWageIndex(this.getProviderWageIndex());
        this.getPaymentData().setTotalPayment(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
    }

    @JsonIgnore
    public HospiceClaimData getClaimData() {
        return (HospiceClaimData)((HospiceClaimPricingRequest)this.getInput()).getClaimData();
    }

    @JsonIgnore
    public List<Integer> getEndOfLifeAddOnDaysUnits() {
        List<Integer> list = new ArrayList<Integer>();
        if (this.getClaimData().getEndOfLifeAddOnDaysUnits() != null) {
            list = this.getClaimData().getEndOfLifeAddOnDaysUnits();
        }
        return list;
    }

    @JsonIgnore
    public HospicePaymentData getPaymentData() {
        return (HospicePaymentData)((HospiceClaimPricingResponse)this.getOutput()).getPaymentData();
    }

    @JsonIgnore
    public List<EndOfLifeAddOnDaysPaymentData> getEndOfLifeAddOnDaysPaymentData() {
        for (int i2 = 0; i2 < this.getEndOfLifeAddOnDaysUnits().size(); ++i2) {
            if (this.getPaymentData().getEndOfLifeAddOnDaysPayments() == null) {
                this.getPaymentData().setEndOfLifeAddOnDaysPayments(new ArrayList<EndOfLifeAddOnDaysPaymentData>());
            }
            EndOfLifeAddOnDaysPaymentData eolPaymentData = new EndOfLifeAddOnDaysPaymentData();
            eolPaymentData.setIndex(i2 + 1);
            eolPaymentData.setPayment(BigDecimal.ZERO.setScale(2, RoundingMode.DOWN));
            this.getPaymentData().getEndOfLifeAddOnDaysPayments().add(eolPaymentData);
        }
        return this.getPaymentData().getEndOfLifeAddOnDaysPayments();
    }

    @JsonIgnore
    public List<BillingGroupData> getBillingGroups() {
        return this.getClaimData().getBillingGroups();
    }

    public boolean isReportingQualityData() {
        return StringUtils.equals(this.getClaimData().getReportingQualityData(), "1");
    }

    @JsonIgnore
    public BillingGroupData getBillGroup(String revenueCode) {
        return this.getBillingGroups().stream().filter(bg -> bg.getRevenueCode().equals(revenueCode)).findFirst().orElse(null);
    }

    public void applyReturnCode(ReturnCode returnCode) {
        ((HospiceClaimPricingResponse)this.getOutput()).setReturnCodeData(returnCode.toReturnCodeData());
    }

    public void applyReturnCodeAndComplete(ReturnCode returnCode) {
        this.applyReturnCode(returnCode);
        this.setCalculationCompleted();
    }

    protected abstract String getCalculationVersion();

    public abstract BigDecimal getGeneralInpatientLsRateQuality();

    public abstract BigDecimal getGeneralInpatientNlsRateQuality();

    public abstract BigDecimal getGeneralInpatientLsRate();

    public abstract BigDecimal getGeneralInpatientNlsRate();

    public abstract BigDecimal getInpatientRespiteLsRateQuality();

    public abstract BigDecimal getInpatientRespiteLsRate();

    public abstract BigDecimal getInpatientRespiteNlsRateQuality();

    public abstract BigDecimal getInpatientRespiteNlsRate();

    public abstract @FixedValue BigDecimal getHighRoutineHomeCareLsRateQuality();

    public abstract @FixedValue BigDecimal getHighRoutineHomeCareNlsRateQuality();

    public abstract @FixedValue BigDecimal getLowRoutineHomeCareLsRateQuality();

    public abstract @FixedValue BigDecimal getLowRoutineHomeCareNlsRateQuality();

    public abstract BigDecimal getContinuousHomeCareLsRateQuality();

    public abstract BigDecimal getContinuousHomeCareNlsRateQuality();

    public abstract @FixedValue BigDecimal getHighRoutineHomeCareLsRate();

    public abstract @FixedValue BigDecimal getHighRoutineHomeCareNlsRate();

    public abstract @FixedValue BigDecimal getLowRoutineHomeCareLsRate();

    public abstract @FixedValue BigDecimal getLowRoutineHomeCareNlsRate();

    public abstract @FixedValue BigDecimal getContinuousHomeCareLsRate();

    public abstract @FixedValue BigDecimal getContinuousHomeCareNlsRate();

    @Generated
    public DataTables getDataTables() {
        return this.dataTables;
    }

    @Generated
    public BigDecimal getWorkPayRate1() {
        return this.workPayRate1;
    }

    @Generated
    public void setWorkPayRate1(BigDecimal workPayRate1) {
        this.workPayRate1 = workPayRate1;
    }

    @Generated
    public BigDecimal getWorkPayRate2() {
        return this.workPayRate2;
    }

    @Generated
    public void setWorkPayRate2(BigDecimal workPayRate2) {
        this.workPayRate2 = workPayRate2;
    }

    @Generated
    public BigDecimal getWorkPayRate3() {
        return this.workPayRate3;
    }

    @Generated
    public void setWorkPayRate3(BigDecimal workPayRate3) {
        this.workPayRate3 = workPayRate3;
    }

    @Generated
    public BigDecimal getWorkPayRate4() {
        return this.workPayRate4;
    }

    @Generated
    public void setWorkPayRate4(BigDecimal workPayRate4) {
        this.workPayRate4 = workPayRate4;
    }

    @Generated
    public BigDecimal getSiaPayAmountTotal() {
        return this.siaPayAmountTotal;
    }

    @Generated
    public void setSiaPayAmountTotal(BigDecimal siaPayAmountTotal) {
        this.siaPayAmountTotal = siaPayAmountTotal;
    }

    @Generated
    public int getPriorServiceDays() {
        return this.priorServiceDays;
    }

    @Generated
    public void setPriorServiceDays(int priorServiceDays) {
        this.priorServiceDays = priorServiceDays;
    }

    @Generated
    public BigDecimal getPatientWageIndex() {
        return this.patientWageIndex;
    }

    @Generated
    public void setPatientWageIndex(BigDecimal patientWageIndex) {
        this.patientWageIndex = patientWageIndex;
    }

    @Generated
    public BigDecimal getProviderWageIndex() {
        return this.providerWageIndex;
    }

    @Generated
    public void setProviderWageIndex(BigDecimal providerWageIndex) {
        this.providerWageIndex = providerWageIndex;
    }

    @Generated
    public int getLowRateBillUnits() {
        return this.lowRateBillUnits;
    }

    @Generated
    public void setLowRateBillUnits(int lowRateBillUnits) {
        this.lowRateBillUnits = lowRateBillUnits;
    }

    @Generated
    public int getHighRateBillUnits() {
        return this.highRateBillUnits;
    }

    @Generated
    public void setHighRateBillUnits(int highRateBillUnits) {
        this.highRateBillUnits = highRateBillUnits;
    }

    @Generated
    public boolean isSiaUnitsIndicator() {
        return this.siaUnitsIndicator;
    }

    @Generated
    public void setSiaUnitsIndicator(boolean siaUnitsIndicator) {
        this.siaUnitsIndicator = siaUnitsIndicator;
    }

    @Generated
    public BigDecimal getSiaPaymentRate() {
        return this.siaPaymentRate;
    }

    @Generated
    public void setSiaPaymentRate(BigDecimal siaPaymentRate) {
        this.siaPaymentRate = siaPaymentRate;
    }

    @Generated
    public BigDecimal getHighRateBillPayAmount() {
        return this.highRateBillPayAmount;
    }

    @Generated
    public void setHighRateBillPayAmount(BigDecimal highRateBillPayAmount) {
        this.highRateBillPayAmount = highRateBillPayAmount;
    }

    @Generated
    public BigDecimal getLowRateBillPayAmount() {
        return this.lowRateBillPayAmount;
    }

    @Generated
    public void setLowRateBillPayAmount(BigDecimal lowRateBillPayAmount) {
        this.lowRateBillPayAmount = lowRateBillPayAmount;
    }

    @Generated
    public boolean isRoutineHomeCareHighDayIndicator() {
        return this.routineHomeCareHighDayIndicator;
    }

    @Generated
    public void setRoutineHomeCareHighDayIndicator(boolean routineHomeCareHighDayIndicator) {
        this.routineHomeCareHighDayIndicator = routineHomeCareHighDayIndicator;
    }

    @Generated
    public boolean isRoutineHomeCareLowDayIndicator() {
        return this.routineHomeCareLowDayIndicator;
    }

    @Generated
    public void setRoutineHomeCareLowDayIndicator(boolean routineHomeCareLowDayIndicator) {
        this.routineHomeCareLowDayIndicator = routineHomeCareLowDayIndicator;
    }

    @Generated
    public LocalDate getDateOfService() {
        return this.dateOfService;
    }

    @Generated
    public void setDateOfService(LocalDate dateOfService) {
        this.dateOfService = dateOfService;
    }
}

