/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hospice.core.codes;

import gov.cms.fiss.pricers.common.api.ReturnCodeData;
import java.util.Arrays;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public enum ReturnCode {
    HOME_RATE_RETURNED_00("00", "HOME RATE RETURNED", "Home rate returned"),
    INVALID_UNITS_10("10", "INVALID UNITS", "Units in excess of the pricer limit were provided"),
    INVALID_CBSA_30("30", "INVALID CBSA", "The supplied CBSA is invalid"),
    LOW_RATE_APPLIED_73("73", "LOW RATE APPLIED", "The low RHC rate is applied to all routine home care"),
    LOW_RATE_WITH_EOL_SIA_74("74", "LOW RATE WITH EOL SIA", "The low RHC rate is applied with an EOL SIA"),
    HIGH_RATE_APPLIED_75("75", "HIGH RATE APPLIED", "The high RHC rate is applied to some or all routine home care"),
    HIGH_RATE_WITH_EOL_SIA_77("77", "HIGH RATE WITH EOL SIA", "The high RHC rate is applied with an EOL SIA");

    private final String code;
    private final String desc;
    private final String exp;

    private ReturnCode(String code, String desc, String exp) {
        this.code = code;
        this.desc = desc;
        this.exp = exp;
    }

    public static ReturnCode fromCode(String code) {
        Optional<ReturnCode> matchedCode = Arrays.stream(ReturnCode.values()).filter(rc -> rc.getCode().equals(code)).findFirst();
        return matchedCode.orElse(null);
    }

    public boolean isErrorCode() {
        return INVALID_UNITS_10.equals((Object)this) || INVALID_CBSA_30.equals((Object)this);
    }

    public ReturnCodeData toReturnCodeData() {
        ReturnCodeData returnCodeData = new ReturnCodeData();
        String paddedCode = StringUtils.leftPad(this.code, 2, "0");
        returnCodeData.setCode(paddedCode);
        returnCodeData.setDescription(this.desc);
        returnCodeData.setExplanation(this.exp);
        return returnCodeData;
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public String getDesc() {
        return this.desc;
    }

    @Generated
    public String getExp() {
        return this.exp;
    }
}

