/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hospice.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.hospice.api.v2.BillPaymentData;
import gov.cms.fiss.pricers.hospice.api.v2.BillingGroupData;
import gov.cms.fiss.pricers.hospice.api.v2.HospiceClaimPricingRequest;
import gov.cms.fiss.pricers.hospice.api.v2.HospiceClaimPricingResponse;
import gov.cms.fiss.pricers.hospice.api.v2.HospicePaymentData;
import gov.cms.fiss.pricers.hospice.core.HospicePricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;

public class CalculateFinalPayments
implements CalculationRule<HospiceClaimPricingRequest, HospiceClaimPricingResponse, HospicePricerContext> {
    @Override
    public void calculate(HospicePricerContext calculationContext) {
        BigDecimal workPayRate1 = calculationContext.getWorkPayRate1();
        BigDecimal workPayRate2 = calculationContext.getWorkPayRate2();
        BigDecimal workPayRate3 = calculationContext.getWorkPayRate3();
        BigDecimal workPayRate4 = calculationContext.getWorkPayRate4();
        HospicePaymentData paymentData = calculationContext.getPaymentData();
        paymentData.setTotalPayment(BigDecimalUtils.decimalSum(workPayRate1, workPayRate2, workPayRate3, workPayRate4, calculationContext.getSiaPayAmountTotal()).setScale(2, RoundingMode.HALF_UP));
        ArrayList<String> revenueCodes = new ArrayList<String>();
        revenueCodes.add("0651");
        revenueCodes.add("0652");
        revenueCodes.add("0655");
        revenueCodes.add("0656");
        calculationContext.getBillingGroups().forEach(group -> revenueCodes.remove(group.getRevenueCode()));
        BillPaymentData payRate1 = new BillPaymentData();
        payRate1.setAmount(workPayRate1.setScale(2, RoundingMode.HALF_UP));
        this.assignRevenueCode(calculationContext, payRate1, 0, revenueCodes);
        BillPaymentData payRate2 = new BillPaymentData();
        payRate2.setAmount(workPayRate2.setScale(2, RoundingMode.HALF_UP));
        this.assignRevenueCode(calculationContext, payRate2, 1, revenueCodes);
        BillPaymentData payRate3 = new BillPaymentData();
        payRate3.setAmount(workPayRate3.setScale(2, RoundingMode.HALF_UP));
        this.assignRevenueCode(calculationContext, payRate3, 2, revenueCodes);
        BillPaymentData payRate4 = new BillPaymentData();
        payRate4.setAmount(workPayRate4.setScale(2, RoundingMode.HALF_UP));
        this.assignRevenueCode(calculationContext, payRate4, 3, revenueCodes);
        paymentData.setBillPayments(List.of(payRate1, payRate2, payRate3, payRate4));
        paymentData.setPatientWageIndex(calculationContext.getPatientWageIndex());
        paymentData.setProviderWageIndex(calculationContext.getProviderWageIndex());
    }

    private void assignRevenueCode(HospicePricerContext calculationContext, BillPaymentData billPaymentData, int index, List<String> availableCodes) {
        List<BillingGroupData> billingGroups = calculationContext.getBillingGroups();
        String revenueCode = billingGroups.size() > index ? billingGroups.get(index).getRevenueCode() : availableCodes.remove(0);
        billPaymentData.setRevenueCode(revenueCode);
    }
}

