/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hospice.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.hospice.api.v2.BillingGroupData;
import gov.cms.fiss.pricers.hospice.api.v2.HospiceClaimPricingRequest;
import gov.cms.fiss.pricers.hospice.api.v2.HospiceClaimPricingResponse;
import gov.cms.fiss.pricers.hospice.core.HospicePricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CalculateGeneralInpatientCarePayment
implements CalculationRule<HospiceClaimPricingRequest, HospiceClaimPricingResponse, HospicePricerContext> {
    @Override
    public boolean shouldExecute(HospicePricerContext calculationContext) {
        BillingGroupData billGroup = calculationContext.getBillGroup("0656");
        return billGroup != null;
    }

    @Override
    public void calculate(HospicePricerContext calculationContext) {
        BillingGroupData billGroup = calculationContext.getBillGroup("0656");
        if (calculationContext.isReportingQualityData()) {
            calculationContext.setWorkPayRate4(calculationContext.getGeneralInpatientLsRateQuality().multiply(calculationContext.getProviderWageIndex()).add(calculationContext.getGeneralInpatientNlsRateQuality()).multiply(new BigDecimal(billGroup.getUnits())).setScale(2, RoundingMode.HALF_UP));
        } else {
            calculationContext.setWorkPayRate4(calculationContext.getGeneralInpatientLsRate().multiply(calculationContext.getProviderWageIndex()).add(calculationContext.getGeneralInpatientNlsRate()).multiply(new BigDecimal(billGroup.getUnits())).setScale(2, RoundingMode.HALF_UP));
        }
    }
}

