/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hospice.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.hospice.api.v2.BillingGroupData;
import gov.cms.fiss.pricers.hospice.api.v2.HospiceClaimPricingRequest;
import gov.cms.fiss.pricers.hospice.api.v2.HospiceClaimPricingResponse;
import gov.cms.fiss.pricers.hospice.core.HospicePricerContext;
import java.math.BigDecimal;

public class CalculateInpatientRespiteCarePayment
implements CalculationRule<HospiceClaimPricingRequest, HospiceClaimPricingResponse, HospicePricerContext> {
    @Override
    public boolean shouldExecute(HospicePricerContext calculationContext) {
        BillingGroupData billGroup = calculationContext.getBillGroup("0655");
        return billGroup != null;
    }

    @Override
    public void calculate(HospicePricerContext calculationContext) {
        BillingGroupData billGroup = calculationContext.getBillGroup("0655");
        if (calculationContext.isReportingQualityData()) {
            calculationContext.setWorkPayRate3(calculationContext.getInpatientRespiteLsRateQuality().multiply(calculationContext.getProviderWageIndex()).add(calculationContext.getInpatientRespiteNlsRateQuality()).multiply(new BigDecimal(billGroup.getUnits())));
        } else {
            calculationContext.setWorkPayRate3(calculationContext.getInpatientRespiteLsRate().multiply(calculationContext.getProviderWageIndex()).add(calculationContext.getInpatientRespiteNlsRate()).multiply(new BigDecimal(billGroup.getUnits())));
        }
    }
}

