/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hospice.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.hospice.api.v2.HospiceClaimPricingRequest;
import gov.cms.fiss.pricers.hospice.api.v2.HospiceClaimPricingResponse;
import gov.cms.fiss.pricers.hospice.core.HospicePricerContext;
import java.time.temporal.ChronoUnit;

public abstract class CalculatePriorSvcDays
implements CalculationRule<HospiceClaimPricingRequest, HospiceClaimPricingResponse, HospicePricerContext> {
    @Override
    public void calculate(HospicePricerContext calculationContext) {
        this.applyDateOfService(calculationContext);
        int daysBetweenDates = Math.toIntExact(ChronoUnit.DAYS.between(calculationContext.getClaimData().getAdmissionDate(), calculationContext.getDateOfService()));
        int priorBenefitDays = 0;
        if (calculationContext.getClaimData().getPriorBenefitDayUnits() > 0) {
            priorBenefitDays = calculationContext.getClaimData().getPriorBenefitDayUnits();
        }
        calculationContext.setPriorServiceDays(daysBetweenDates + priorBenefitDays);
    }

    protected abstract void applyDateOfService(HospicePricerContext var1);
}

