/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hospice.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.application.rules.EvaluatingCalculationRule;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import gov.cms.fiss.pricers.hospice.api.v2.BillingGroupData;
import gov.cms.fiss.pricers.hospice.api.v2.HospiceClaimPricingRequest;
import gov.cms.fiss.pricers.hospice.api.v2.HospiceClaimPricingResponse;
import gov.cms.fiss.pricers.hospice.core.HospicePricerContext;
import java.util.List;

public class CalculateRoutineHomeCarePayment
extends EvaluatingCalculationRule<HospiceClaimPricingRequest, HospiceClaimPricingResponse, HospicePricerContext> {
    public CalculateRoutineHomeCarePayment(List<CalculationRule<HospiceClaimPricingRequest, HospiceClaimPricingResponse, HospicePricerContext>> calculationRules) {
        super(calculationRules);
    }

    @Override
    public boolean shouldExecute(HospicePricerContext calculationContext) {
        BillingGroupData billGroup = calculationContext.getBillGroup("0651");
        boolean hasRhcUnits = billGroup != null && billGroup.getUnits() > 0;
        return hasRhcUnits && LocalDateUtils.isAfterOrEqual(billGroup.getDateOfService(), calculationContext.getClaimData().getAdmissionDate());
    }
}

