/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hospice.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.hospice.api.v2.BillingGroupData;
import gov.cms.fiss.pricers.hospice.api.v2.HospiceClaimPricingRequest;
import gov.cms.fiss.pricers.hospice.api.v2.HospiceClaimPricingResponse;
import gov.cms.fiss.pricers.hospice.core.HospicePricerContext;
import gov.cms.fiss.pricers.hospice.core.codes.ReturnCode;
import java.util.List;

public class ValidateBillUnits
implements CalculationRule<HospiceClaimPricingRequest, HospiceClaimPricingResponse, HospicePricerContext> {
    @Override
    public void calculate(HospicePricerContext calculationContext) {
        List<BillingGroupData> billGroups = calculationContext.getBillingGroups();
        if (billGroups.stream().anyMatch(billGroup -> billGroup.getUnits() > 1000)) {
            calculationContext.applyReturnCodeAndComplete(ReturnCode.INVALID_UNITS_10);
        }
    }
}

