/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hospice.core.rules.continuous_home_care;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.hospice.api.v2.BillingGroupData;
import gov.cms.fiss.pricers.hospice.api.v2.HospiceClaimPricingRequest;
import gov.cms.fiss.pricers.hospice.api.v2.HospiceClaimPricingResponse;
import gov.cms.fiss.pricers.hospice.core.HospicePricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class ApplyContinuousHomeCareRateWithQualityReduction
implements CalculationRule<HospiceClaimPricingRequest, HospiceClaimPricingResponse, HospicePricerContext> {
    @Override
    public void calculate(HospicePricerContext calculationContext) {
        BillingGroupData billGroup = calculationContext.getBillGroup("0652");
        if (calculationContext.isReportingQualityData()) {
            if (billGroup.getUnits() < 32) {
                if (calculationContext.getPriorServiceDays() < 60) {
                    calculationContext.setWorkPayRate2(calculationContext.getHighRoutineHomeCareLsRateQuality().multiply(calculationContext.getPatientWageIndex()).add(calculationContext.getHighRoutineHomeCareNlsRateQuality()));
                } else {
                    calculationContext.setWorkPayRate2(calculationContext.getLowRoutineHomeCareLsRateQuality().multiply(calculationContext.getPatientWageIndex()).add(calculationContext.getLowRoutineHomeCareNlsRateQuality()));
                }
            } else {
                calculationContext.setWorkPayRate2(calculationContext.getContinuousHomeCareLsRateQuality().multiply(calculationContext.getPatientWageIndex()).add(calculationContext.getContinuousHomeCareNlsRateQuality()).divide(new BigDecimal("24"), 4, RoundingMode.DOWN).multiply(new BigDecimal(billGroup.getUnits()).divide(new BigDecimal("4"), 2, RoundingMode.HALF_UP)));
            }
        }
    }
}

