/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hospice.core.rules.routine_home_care;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.hospice.api.v2.EndOfLifeAddOnDaysPaymentData;
import gov.cms.fiss.pricers.hospice.api.v2.HospiceClaimPricingRequest;
import gov.cms.fiss.pricers.hospice.api.v2.HospiceClaimPricingResponse;
import gov.cms.fiss.pricers.hospice.core.HospicePricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;

public class CalculateEndOfLifeServiceIntensityAddOn
implements CalculationRule<HospiceClaimPricingRequest, HospiceClaimPricingResponse, HospicePricerContext> {
    @Override
    public void calculate(HospicePricerContext calculationContext) {
        List<EndOfLifeAddOnDaysPaymentData> endOfLifeAddOnDaysPayments = calculationContext.getEndOfLifeAddOnDaysPaymentData();
        List<Integer> endOfLifeAddOnDaysUnits = calculationContext.getEndOfLifeAddOnDaysUnits();
        if (!endOfLifeAddOnDaysUnits.stream().anyMatch(units -> units > 0)) {
            calculationContext.setSiaUnitsIndicator(false);
            return;
        }
        calculationContext.setSiaUnitsIndicator(true);
        if (calculationContext.isReportingQualityData()) {
            calculationContext.setSiaPaymentRate(calculationContext.getContinuousHomeCareLsRateQuality().multiply(calculationContext.getPatientWageIndex()).add(calculationContext.getContinuousHomeCareNlsRateQuality()).divide(new BigDecimal("24"), 2, RoundingMode.HALF_UP));
        } else {
            calculationContext.setSiaPaymentRate(calculationContext.getContinuousHomeCareLsRate().multiply(calculationContext.getPatientWageIndex()).add(calculationContext.getContinuousHomeCareNlsRate()).divide(new BigDecimal("24"), 2, RoundingMode.HALF_UP));
        }
        for (int i2 = 0; i2 < endOfLifeAddOnDaysUnits.size(); ++i2) {
            Integer endOfLifeAddOnDayUnit = endOfLifeAddOnDaysUnits.get(i2);
            if (endOfLifeAddOnDayUnit > 0) {
                BigDecimal endOfLifeHours = endOfLifeAddOnDayUnit >= 16 ? new BigDecimal(4) : new BigDecimal(endOfLifeAddOnDayUnit).divide(new BigDecimal(4), 2, RoundingMode.DOWN);
                EndOfLifeAddOnDaysPaymentData endOfLifeAddOnDaysPaymentData = new EndOfLifeAddOnDaysPaymentData();
                endOfLifeAddOnDaysPaymentData.setIndex(i2 + 1);
                endOfLifeAddOnDaysPaymentData.setPayment(endOfLifeHours.multiply(calculationContext.getSiaPaymentRate()).setScale(2, RoundingMode.HALF_UP));
                endOfLifeAddOnDaysPayments.set(i2, endOfLifeAddOnDaysPaymentData);
                continue;
            }
            EndOfLifeAddOnDaysPaymentData endOfLifeAddOnDaysPaymentData = new EndOfLifeAddOnDaysPaymentData();
            endOfLifeAddOnDaysPaymentData.setPayment(BigDecimal.ZERO.setScale(2, RoundingMode.DOWN));
            endOfLifeAddOnDaysPaymentData.setIndex(i2 + 1);
            endOfLifeAddOnDaysPayments.set(i2, endOfLifeAddOnDaysPaymentData);
        }
        calculationContext.setSiaPayAmountTotal(BigDecimal.ZERO);
        for (EndOfLifeAddOnDaysPaymentData endOfLifePay : endOfLifeAddOnDaysPayments) {
            calculationContext.setSiaPayAmountTotal(calculationContext.getSiaPayAmountTotal().add(endOfLifePay.getPayment()));
        }
    }
}

