/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hospice.core.rules.routine_home_care;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.hospice.api.v2.BillingGroupData;
import gov.cms.fiss.pricers.hospice.api.v2.HospiceClaimPricingRequest;
import gov.cms.fiss.pricers.hospice.api.v2.HospiceClaimPricingResponse;
import gov.cms.fiss.pricers.hospice.api.v2.HospicePaymentData;
import gov.cms.fiss.pricers.hospice.core.HospicePricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class EvaluateRoutineHomeCareDays
implements CalculationRule<HospiceClaimPricingRequest, HospiceClaimPricingResponse, HospicePricerContext> {
    @Override
    public void calculate(HospicePricerContext calculationContext) {
        BillingGroupData billGroup = calculationContext.getBillGroup("0651");
        if (calculationContext.getPriorServiceDays() >= 60) {
            calculationContext.setLowRateBillUnits(billGroup.getUnits());
            this.applyLowRhcRate(calculationContext);
        }
        if (calculationContext.getPriorServiceDays() < 60) {
            int highRateDaysLeft = 60 - calculationContext.getPriorServiceDays();
            if (billGroup.getUnits() <= highRateDaysLeft) {
                calculationContext.setHighRateBillUnits(billGroup.getUnits());
                this.applyHighRhcRate(calculationContext);
            } else {
                calculationContext.setHighRateBillUnits(highRateDaysLeft);
                this.applyHighRhcRate(calculationContext);
                calculationContext.setLowRateBillUnits(billGroup.getUnits() - calculationContext.getHighRateBillUnits());
                this.applyLowRhcRate(calculationContext);
            }
        }
    }

    protected void applyHighRhcRate(HospicePricerContext calculationContext) {
        HospicePaymentData paymentData = calculationContext.getPaymentData();
        paymentData.setHighRoutineHomeCareDays(calculationContext.getHighRateBillUnits());
        if (calculationContext.isReportingQualityData()) {
            calculationContext.setHighRateBillPayAmount(calculationContext.getHighRoutineHomeCareLsRateQuality().multiply(calculationContext.getPatientWageIndex()).add(calculationContext.getHighRoutineHomeCareNlsRateQuality()).multiply(new BigDecimal(paymentData.getHighRoutineHomeCareDays())).setScale(2, RoundingMode.HALF_UP));
        } else {
            calculationContext.setHighRateBillPayAmount(calculationContext.getHighRoutineHomeCareLsRate().multiply(calculationContext.getPatientWageIndex()).add(calculationContext.getHighRoutineHomeCareNlsRate()).multiply(new BigDecimal(paymentData.getHighRoutineHomeCareDays())).setScale(2, RoundingMode.HALF_UP));
        }
        calculationContext.setRoutineHomeCareHighDayIndicator(true);
    }

    protected void applyLowRhcRate(HospicePricerContext calculationContext) {
        HospicePaymentData paymentData = calculationContext.getPaymentData();
        paymentData.setLowRoutineHomeCareDays(calculationContext.getLowRateBillUnits());
        if (calculationContext.isReportingQualityData()) {
            calculationContext.setLowRateBillPayAmount(calculationContext.getLowRoutineHomeCareLsRateQuality().multiply(calculationContext.getPatientWageIndex()).add(calculationContext.getLowRoutineHomeCareNlsRateQuality()).multiply(new BigDecimal(paymentData.getLowRoutineHomeCareDays())));
        } else {
            calculationContext.setLowRateBillPayAmount(calculationContext.getLowRoutineHomeCareLsRate().multiply(calculationContext.getPatientWageIndex()).add(calculationContext.getLowRoutineHomeCareNlsRate()).multiply(new BigDecimal(paymentData.getLowRoutineHomeCareDays())));
        }
        calculationContext.setRoutineHomeCareLowDayIndicator(true);
    }
}

