/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hospice.core.rules.routine_home_care;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.hospice.api.v2.HospiceClaimPricingRequest;
import gov.cms.fiss.pricers.hospice.api.v2.HospiceClaimPricingResponse;
import gov.cms.fiss.pricers.hospice.core.HospicePricerContext;
import gov.cms.fiss.pricers.hospice.core.codes.ReturnCode;

public class SumRoutineHomeCareRate
implements CalculationRule<HospiceClaimPricingRequest, HospiceClaimPricingResponse, HospicePricerContext> {
    @Override
    public void calculate(HospicePricerContext calculationContext) {
        calculationContext.setWorkPayRate1(calculationContext.getHighRateBillPayAmount().add(calculationContext.getLowRateBillPayAmount()));
        if (calculationContext.isSiaUnitsIndicator()) {
            if (calculationContext.isRoutineHomeCareHighDayIndicator()) {
                calculationContext.applyReturnCode(ReturnCode.HIGH_RATE_WITH_EOL_SIA_77);
            } else if (calculationContext.isRoutineHomeCareLowDayIndicator()) {
                calculationContext.applyReturnCode(ReturnCode.LOW_RATE_WITH_EOL_SIA_74);
            }
        }
        if (!calculationContext.isSiaUnitsIndicator()) {
            if (calculationContext.isRoutineHomeCareHighDayIndicator()) {
                calculationContext.applyReturnCode(ReturnCode.HIGH_RATE_APPLIED_75);
            } else if (calculationContext.isRoutineHomeCareLowDayIndicator()) {
                calculationContext.applyReturnCode(ReturnCode.LOW_RATE_APPLIED_73);
            }
        }
    }
}

