/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.hospice.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.hospice.HospicePricerConfiguration;
import gov.cms.fiss.pricers.hospice.core.tables.CbsaWageIndexEntry;
import gov.cms.fiss.pricers.hospice.core.tables.CbsaWageIndexLookupGenerator;
import java.time.LocalDate;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

public class DataTables {
    private static final Map<Integer, DataTables> YEAR_LOOKUP = new ConcurrentHashMap<Integer, DataTables>();
    private final Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> cbsaTable;

    public DataTables(Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> cbsaTable) {
        this.cbsaTable = cbsaTable;
    }

    public static DataTables forYear(int implementationYear) {
        return YEAR_LOOKUP.get(implementationYear);
    }

    public static void loadDataTables(HospicePricerConfiguration pricerConfiguration) {
        CsvIngestionConfiguration csvIngestionConfiguration = pricerConfiguration.getCsvIngestionConfiguration();
        CbsaWageIndexLookupGenerator cbsaLookupProvider = new CbsaWageIndexLookupGenerator(csvIngestionConfiguration);
        for (int supportedYear : pricerConfiguration.getSupportedYears()) {
            YEAR_LOOKUP.put(supportedYear, new DataTables(cbsaLookupProvider.generate(supportedYear)));
        }
    }

    public CbsaWageIndexEntry getCbsaWageIndexEntry(String cbsa, LocalDate effectiveDate) {
        NavigableMap<LocalDate, CbsaWageIndexEntry> entries = this.cbsaTable.get(cbsa);
        if (entries != null) {
            Map.Entry<LocalDate, CbsaWageIndexEntry> entry = entries.floorEntry(effectiveDate);
            return null == entry ? null : entry.getValue();
        }
        return null;
    }

    @Generated
    public Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> getCbsaTable() {
        return this.cbsaTable;
    }
}

