/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.servlets;

import io.dropwizard.servlets.Servlets;
import io.dropwizard.util.Duration;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlowRequestFilter
implements Filter {
    private final long threshold;
    private Supplier<Long> currentTimeProvider = System::nanoTime;
    private Logger logger = LoggerFactory.getLogger(SlowRequestFilter.class);

    public SlowRequestFilter() {
        this(Duration.seconds(1L));
    }

    public SlowRequestFilter(Duration threshold) {
        this.threshold = threshold.toNanoseconds();
    }

    void setCurrentTimeProvider(Supplier<Long> currentTimeProvider) {
        this.currentTimeProvider = currentTimeProvider;
    }

    void setLogger(Logger logger2) {
        this.logger = logger2;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        long elapsedMS;
        HttpServletRequest req = (HttpServletRequest)request;
        long startTime = this.currentTimeProvider.get();
        try {
            chain.doFilter(request, response);
            long elapsedNS = this.currentTimeProvider.get() - startTime;
            elapsedMS = TimeUnit.NANOSECONDS.toMillis(elapsedNS);
            if (elapsedNS < this.threshold) return;
        }
        catch (Throwable throwable) {
            long elapsedNS = this.currentTimeProvider.get() - startTime;
            long elapsedMS2 = TimeUnit.NANOSECONDS.toMillis(elapsedNS);
            if (elapsedNS < this.threshold) throw throwable;
            this.logger.warn("Slow request: {} {} ({}ms)", req.getMethod(), Servlets.getFullUrl(req), elapsedMS2);
            throw throwable;
        }
        this.logger.warn("Slow request: {} {} ({}ms)", req.getMethod(), Servlets.getFullUrl(req), elapsedMS);
    }
}

