// Generated by delombok at Tue Feb 11 06:58:51 UTC 2025
package gov.cms.fiss.pricers.hospice.api.v2;

import gov.cms.fiss.pricers.common.api.ClaimData;
import gov.cms.fiss.pricers.common.api.serialization.StrictLocalDate;
import gov.cms.fiss.pricers.common.api.validation.ValidInputCbsa;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.LocalDate;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@Schema(description = "The Hospice claim record.", extensions = @Extension(name = "cobol-declaration", properties = @ExtensionProperty(name = "BILL-315-DATA", value = "<structure>")))
public class HospiceClaimData extends ClaimData {
  @NotNull
  @Schema(description = "The admission date.", example = "2020-04-15", format = "yyyy-MM-dd", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-ADMISSION-DATE", value = "BILL-ADM-CC       PIC 99\n" + "BILL-ADM-YY       PIC 99\n" + "BILL-ADM-MM       PIC 99\n" + "BILL-ADM-DD       PIC 99")})})
  @StrictLocalDate
  private LocalDate admissionDate;
  @ArraySchema(arraySchema = @Schema(description = "The data associated with the four billing groups for " + "the claim."), uniqueItems = true, extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-GROUPn", value = "<repeated structure")})})
  @NotEmpty
  @Size(max = 4)
  @Valid
  private List<@NotNull BillingGroupData> billingGroups;
  @ArraySchema(arraySchema = @Schema(description = "The sum of the units associated with revenue codes 055x (if G0299 present) " + "and 056x (other than 0569) on the date of death. No value will be " + "provided if the line is not associated with routine home care " + "(revenue code 0651).", example = "[ 50, 12 ]"), uniqueItems = true, extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-SIA-ADD-ON-UNITS <partial>", value = "BILL-EOL-ADD-ON-DAY1-UNITS  PIC 99\n" + " BILL-EOL-ADD-ON-DAY2-UNITS  PIC 99\n" + " BILL-EOL-ADD-ON-DAY3-UNITS  PIC 99\n" + " BILL-EOL-ADD-ON-DAY4-UNITS  PIC 99\n" + " BILL-EOL-ADD-ON-DAY5-UNITS  PIC 99\n" + " BILL-EOL-ADD-ON-DAY6-UNITS  PIC 99\n" + " BILL-EOL-ADD-ON-DAY7-UNITS  PIC 99")})})
  @Size(max = 7, min = 1)
  private List<@Max(99) @Min(0) Integer> endOfLifeAddOnDaysUnits;
  @Schema(description = "The patient core-based statistical area (CBSA) code.", example = "10380", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-BENE-CBSA", value = "PIC X(05)"), @ExtensionProperty(name = "BILL-BENE-MSA-LUGAR", value = "BILL-BENE-MSA   PIC X(04)\nBILL-BENE-LUGAR   PIC X")})})
  @ValidInputCbsa
  private String patientCbsa;
  @Max(99)
  @Min(0)
  @Schema(description = "The number of days from a prior hospice benefit period if identified by the " + "common working file (CWF) as part of the first 60 days of routine home care " + "(RHC).", example = "4", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-NA-ADD-ON-DAYn-UNITS", value = "PIC 99")})})
  private int priorBenefitDayUnits;
  @Schema(description = "The provider core-based statistical area (CBSA) code.", example = "10380", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-PROV-CBSA", value = "PIC X(05)"), @ExtensionProperty(name = "BILL-PROV-MSA-LUGAR", value = "BILL-PROV-MSA   PIC X(04)\nBILL-PROV-LUGAR   PIC X")})})
  @ValidInputCbsa
  private String providerCbsa;
  @Pattern(regexp = "1", message = "must be `1` if present")
  @Schema(description = "An indicator of whether the hospice\'s payments are subject to the 2% " + "reduction for not reporting quality data. If false, no reduction applies; " + "if true, a 2% reduction applies.", example = "1", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-QIP-IND", value = "PIC X")})})
  private String reportingQualityData;
  @NotNull
  @Schema(description = "The start date of service.", example = "2020-01-01", format = "yyyy-MM-dd", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-FROM-DATE", value = "BILL-FROM-CC       PIC 99\n" + "BILL-FROM-YY       PIC 99\n" + "BILL-FROM-MM       PIC 99\n" + "BILL-FROM-DD       PIC 99")})})
  @StrictLocalDate
  private LocalDate serviceFromDate;

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LocalDate getAdmissionDate() {
    return this.admissionDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<@NotNull BillingGroupData> getBillingGroups() {
    return this.billingGroups;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<@Max(99) @Min(0) Integer> getEndOfLifeAddOnDaysUnits() {
    return this.endOfLifeAddOnDaysUnits;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getPatientCbsa() {
    return this.patientCbsa;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getPriorBenefitDayUnits() {
    return this.priorBenefitDayUnits;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getProviderCbsa() {
    return this.providerCbsa;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getReportingQualityData() {
    return this.reportingQualityData;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LocalDate getServiceFromDate() {
    return this.serviceFromDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAdmissionDate(final LocalDate admissionDate) {
    this.admissionDate = admissionDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBillingGroups(final List<@NotNull BillingGroupData> billingGroups) {
    this.billingGroups = billingGroups;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEndOfLifeAddOnDaysUnits(final List<@Max(99) @Min(0) Integer> endOfLifeAddOnDaysUnits) {
    this.endOfLifeAddOnDaysUnits = endOfLifeAddOnDaysUnits;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPatientCbsa(final String patientCbsa) {
    this.patientCbsa = patientCbsa;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPriorBenefitDayUnits(final int priorBenefitDayUnits) {
    this.priorBenefitDayUnits = priorBenefitDayUnits;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setProviderCbsa(final String providerCbsa) {
    this.providerCbsa = providerCbsa;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReportingQualityData(final String reportingQualityData) {
    this.reportingQualityData = reportingQualityData;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setServiceFromDate(final LocalDate serviceFromDate) {
    this.serviceFromDate = serviceFromDate;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof HospiceClaimData)) return false;
    final HospiceClaimData other = (HospiceClaimData) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    if (!super.equals(o)) return false;
    if (this.getPriorBenefitDayUnits() != other.getPriorBenefitDayUnits()) return false;
    final java.lang.Object this$admissionDate = this.getAdmissionDate();
    final java.lang.Object other$admissionDate = other.getAdmissionDate();
    if (this$admissionDate == null ? other$admissionDate != null : !this$admissionDate.equals(other$admissionDate)) return false;
    final java.lang.Object this$billingGroups = this.getBillingGroups();
    final java.lang.Object other$billingGroups = other.getBillingGroups();
    if (this$billingGroups == null ? other$billingGroups != null : !this$billingGroups.equals(other$billingGroups)) return false;
    final java.lang.Object this$endOfLifeAddOnDaysUnits = this.getEndOfLifeAddOnDaysUnits();
    final java.lang.Object other$endOfLifeAddOnDaysUnits = other.getEndOfLifeAddOnDaysUnits();
    if (this$endOfLifeAddOnDaysUnits == null ? other$endOfLifeAddOnDaysUnits != null : !this$endOfLifeAddOnDaysUnits.equals(other$endOfLifeAddOnDaysUnits)) return false;
    final java.lang.Object this$patientCbsa = this.getPatientCbsa();
    final java.lang.Object other$patientCbsa = other.getPatientCbsa();
    if (this$patientCbsa == null ? other$patientCbsa != null : !this$patientCbsa.equals(other$patientCbsa)) return false;
    final java.lang.Object this$providerCbsa = this.getProviderCbsa();
    final java.lang.Object other$providerCbsa = other.getProviderCbsa();
    if (this$providerCbsa == null ? other$providerCbsa != null : !this$providerCbsa.equals(other$providerCbsa)) return false;
    final java.lang.Object this$reportingQualityData = this.getReportingQualityData();
    final java.lang.Object other$reportingQualityData = other.getReportingQualityData();
    if (this$reportingQualityData == null ? other$reportingQualityData != null : !this$reportingQualityData.equals(other$reportingQualityData)) return false;
    final java.lang.Object this$serviceFromDate = this.getServiceFromDate();
    final java.lang.Object other$serviceFromDate = other.getServiceFromDate();
    if (this$serviceFromDate == null ? other$serviceFromDate != null : !this$serviceFromDate.equals(other$serviceFromDate)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof HospiceClaimData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = super.hashCode();
    result = result * PRIME + this.getPriorBenefitDayUnits();
    final java.lang.Object $admissionDate = this.getAdmissionDate();
    result = result * PRIME + ($admissionDate == null ? 43 : $admissionDate.hashCode());
    final java.lang.Object $billingGroups = this.getBillingGroups();
    result = result * PRIME + ($billingGroups == null ? 43 : $billingGroups.hashCode());
    final java.lang.Object $endOfLifeAddOnDaysUnits = this.getEndOfLifeAddOnDaysUnits();
    result = result * PRIME + ($endOfLifeAddOnDaysUnits == null ? 43 : $endOfLifeAddOnDaysUnits.hashCode());
    final java.lang.Object $patientCbsa = this.getPatientCbsa();
    result = result * PRIME + ($patientCbsa == null ? 43 : $patientCbsa.hashCode());
    final java.lang.Object $providerCbsa = this.getProviderCbsa();
    result = result * PRIME + ($providerCbsa == null ? 43 : $providerCbsa.hashCode());
    final java.lang.Object $reportingQualityData = this.getReportingQualityData();
    result = result * PRIME + ($reportingQualityData == null ? 43 : $reportingQualityData.hashCode());
    final java.lang.Object $serviceFromDate = this.getServiceFromDate();
    result = result * PRIME + ($serviceFromDate == null ? 43 : $serviceFromDate.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "HospiceClaimData(admissionDate=" + this.getAdmissionDate() + ", billingGroups=" + this.getBillingGroups() + ", endOfLifeAddOnDaysUnits=" + this.getEndOfLifeAddOnDaysUnits() + ", patientCbsa=" + this.getPatientCbsa() + ", priorBenefitDayUnits=" + this.getPriorBenefitDayUnits() + ", providerCbsa=" + this.getProviderCbsa() + ", reportingQualityData=" + this.getReportingQualityData() + ", serviceFromDate=" + this.getServiceFromDate() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public HospiceClaimData() {
  }
}
