// Generated by delombok at Tue Feb 11 06:59:30 UTC 2025
package gov.cms.fiss.pricers.hospice.core.codes;

import gov.cms.fiss.pricers.common.api.ReturnCodeData;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public enum ReturnCode {
  /**
   * The home rate is returned.
   */
  HOME_RATE_RETURNED_00("00", "HOME RATE RETURNED", "Home rate returned"), /**
   * Units in excess of the pricer limit were provided.
   */
  INVALID_UNITS_10("10", "INVALID UNITS", "Units in excess of the pricer limit were provided"), /**
   * The supplied Cbsa is invalid.
   */
  INVALID_CBSA_30("30", "INVALID CBSA", "The supplied CBSA is invalid"), /**
   * The low RHC rate is applied to all routine home care.
   */
  LOW_RATE_APPLIED_73("73", "LOW RATE APPLIED", "The low RHC rate is applied to all routine home care"), /**
   * The low RHC rate is applied with an EOL SIA.
   */
  LOW_RATE_WITH_EOL_SIA_74("74", "LOW RATE WITH EOL SIA", "The low RHC rate is applied with an EOL SIA"), /**
   * The high RHC rate is applied to some or all routine home care.
   */
  HIGH_RATE_APPLIED_75("75", "HIGH RATE APPLIED", "The high RHC rate is applied to some or all routine home care"), /**
   * The high RHC rate is applied with an EOL SIA.
   */
  HIGH_RATE_WITH_EOL_SIA_77("77", "HIGH RATE WITH EOL SIA", "The high RHC rate is applied with an EOL SIA");
  private final String code;
  private final String desc;
  private final String exp;

  ReturnCode(String code, String desc, String exp) {
    this.code = code;
    this.desc = desc;
    this.exp = exp;
  }

  public static ReturnCode fromCode(String code) {
    final Optional<ReturnCode> matchedCode = Arrays.stream(ReturnCode.values()).filter(rc -> rc.getCode().equals(code)).findFirst();
    return matchedCode.orElse(null);
  }

  public boolean isErrorCode() {
    return INVALID_UNITS_10.equals(this) || INVALID_CBSA_30.equals(this);
  }

  public ReturnCodeData toReturnCodeData() {
    final ReturnCodeData returnCodeData = new ReturnCodeData();
    final String paddedCode = StringUtils.leftPad(this.code, 2, "0");
    returnCodeData.setCode(paddedCode);
    returnCodeData.setDescription(this.desc);
    returnCodeData.setExplanation(this.exp);
    return returnCodeData;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCode() {
    return this.code;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDesc() {
    return this.desc;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getExp() {
    return this.exp;
  }
}
