// Generated by delombok at Tue Feb 11 06:58:51 UTC 2025
package gov.cms.fiss.pricers.hospice.api.v2;

import gov.cms.fiss.pricers.common.api.PaymentData;
import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Schema(description = "The Hospice prospective payment data.", extensions = @Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL_GROUPn", value = "<structure>"), @ExtensionProperty(name = "BILL-RETURNED-DATA", value = "<structure>"), @ExtensionProperty(name = "BILL-RHC-DAYS-PAID", value = "<structure>")}))
public class HospicePaymentData extends PaymentData {
  @ArraySchema(arraySchema = @Schema(description = "The bill payment amounts."), extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-GROUPn <partial repeated structure>", value = "BILL-PAY-AMT1  PIC 9(06)V99\n" + "BILL-PAY-AMT2  PIC 9(06)V99\n" + "BILL-PAY-AMT3  PIC 9(06)V99\n" + "BILL-PAY-AMT4  PIC 9(06)V99")})}, uniqueItems = true)
  @Size(max = 4, min = 4)
  @Valid
  private List<@NotNull BillPaymentData> billPayments;
  @ArraySchema(arraySchema = @Schema(description = "The end-of-life add-on day payments. Only processed entries from the claim\'s " + "end-of-life add-on days will produce an entry in this collection."), extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-SIA-ADD-ON-PYMTS <partial>", value = "BILL-EOL-ADD-ON-DAY1-PAY  PIC 9(06)V99\n" + "BILL-EOL-ADD-ON-DAY2-PAY  PIC 9(06)V99\n" + "BILL-EOL-ADD-ON-DAY3-PAY  PIC 9(06)V99\n" + "BILL-EOL-ADD-ON-DAY4-PAY  PIC 9(06)V99\n" + "BILL-EOL-ADD-ON-DAY5-PAY  PIC 9(06)V99\n" + "BILL-EOL-ADD-ON-DAY6-PAY  PIC 9(06)V99\n" + "BILL-EOL-ADD-ON-DAY7-PAY  PIC 9(06)V99")})}, uniqueItems = true)
  @Size(max = 7, min = 1)
  @Valid
  private List<@NotNull EndOfLifeAddOnDaysPaymentData> endOfLifeAddOnDaysPayments;
  @NotNull
  @Max(99)
  @Min(0)
  @Schema(description = "The high number of routine home-care days.", example = "9", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-HIGH-RHC-DAYS", value = "PIC 99")})})
  private int highRoutineHomeCareDays;
  @NotNull
  @Max(99)
  @Min(0)
  @Schema(description = "The low number of routine home-care days.", example = "9", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-LOW-RHC-DAYS", value = "PIC 99")})})
  private int lowRoutineHomeCareDays;
  @NotNull
  @BigDecimalScale(scale = 4)
  @DecimalMin("0")
  @DecimalMax("99.9999")
  @Digits(integer = 2, fraction = 4)
  @Schema(description = "The patient wage index used for claim processing.", example = "1.2403", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-BENE-WAGE-INDEX", value = "PIC 9(02)V9(04)")})})
  @FixedValue
  private BigDecimal patientWageIndex;
  @NotNull
  @BigDecimalScale(scale = 4)
  @DecimalMin("0")
  @DecimalMax("99.9999")
  @Digits(integer = 2, fraction = 4)
  @Schema(description = "The provider wage index used for claim processing.", example = "1.2365", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-PROV-WAGE-INDEX", value = "PIC 9(02)V9(04)")})})
  private BigDecimal providerWageIndex;

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<@NotNull BillPaymentData> getBillPayments() {
    return this.billPayments;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<@NotNull EndOfLifeAddOnDaysPaymentData> getEndOfLifeAddOnDaysPayments() {
    return this.endOfLifeAddOnDaysPayments;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getHighRoutineHomeCareDays() {
    return this.highRoutineHomeCareDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getLowRoutineHomeCareDays() {
    return this.lowRoutineHomeCareDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPatientWageIndex() {
    return this.patientWageIndex;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getProviderWageIndex() {
    return this.providerWageIndex;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBillPayments(final List<@NotNull BillPaymentData> billPayments) {
    this.billPayments = billPayments;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setEndOfLifeAddOnDaysPayments(final List<@NotNull EndOfLifeAddOnDaysPaymentData> endOfLifeAddOnDaysPayments) {
    this.endOfLifeAddOnDaysPayments = endOfLifeAddOnDaysPayments;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHighRoutineHomeCareDays(final int highRoutineHomeCareDays) {
    this.highRoutineHomeCareDays = highRoutineHomeCareDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLowRoutineHomeCareDays(final int lowRoutineHomeCareDays) {
    this.lowRoutineHomeCareDays = lowRoutineHomeCareDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPatientWageIndex(final BigDecimal patientWageIndex) {
    this.patientWageIndex = patientWageIndex;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setProviderWageIndex(final BigDecimal providerWageIndex) {
    this.providerWageIndex = providerWageIndex;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof HospicePaymentData)) return false;
    final HospicePaymentData other = (HospicePaymentData) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    if (!super.equals(o)) return false;
    if (this.getHighRoutineHomeCareDays() != other.getHighRoutineHomeCareDays()) return false;
    if (this.getLowRoutineHomeCareDays() != other.getLowRoutineHomeCareDays()) return false;
    final java.lang.Object this$billPayments = this.getBillPayments();
    final java.lang.Object other$billPayments = other.getBillPayments();
    if (this$billPayments == null ? other$billPayments != null : !this$billPayments.equals(other$billPayments)) return false;
    final java.lang.Object this$endOfLifeAddOnDaysPayments = this.getEndOfLifeAddOnDaysPayments();
    final java.lang.Object other$endOfLifeAddOnDaysPayments = other.getEndOfLifeAddOnDaysPayments();
    if (this$endOfLifeAddOnDaysPayments == null ? other$endOfLifeAddOnDaysPayments != null : !this$endOfLifeAddOnDaysPayments.equals(other$endOfLifeAddOnDaysPayments)) return false;
    final java.lang.Object this$patientWageIndex = this.getPatientWageIndex();
    final java.lang.Object other$patientWageIndex = other.getPatientWageIndex();
    if (this$patientWageIndex == null ? other$patientWageIndex != null : !this$patientWageIndex.equals(other$patientWageIndex)) return false;
    final java.lang.Object this$providerWageIndex = this.getProviderWageIndex();
    final java.lang.Object other$providerWageIndex = other.getProviderWageIndex();
    if (this$providerWageIndex == null ? other$providerWageIndex != null : !this$providerWageIndex.equals(other$providerWageIndex)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof HospicePaymentData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = super.hashCode();
    result = result * PRIME + this.getHighRoutineHomeCareDays();
    result = result * PRIME + this.getLowRoutineHomeCareDays();
    final java.lang.Object $billPayments = this.getBillPayments();
    result = result * PRIME + ($billPayments == null ? 43 : $billPayments.hashCode());
    final java.lang.Object $endOfLifeAddOnDaysPayments = this.getEndOfLifeAddOnDaysPayments();
    result = result * PRIME + ($endOfLifeAddOnDaysPayments == null ? 43 : $endOfLifeAddOnDaysPayments.hashCode());
    final java.lang.Object $patientWageIndex = this.getPatientWageIndex();
    result = result * PRIME + ($patientWageIndex == null ? 43 : $patientWageIndex.hashCode());
    final java.lang.Object $providerWageIndex = this.getProviderWageIndex();
    result = result * PRIME + ($providerWageIndex == null ? 43 : $providerWageIndex.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "HospicePaymentData(billPayments=" + this.getBillPayments() + ", endOfLifeAddOnDaysPayments=" + this.getEndOfLifeAddOnDaysPayments() + ", highRoutineHomeCareDays=" + this.getHighRoutineHomeCareDays() + ", lowRoutineHomeCareDays=" + this.getLowRoutineHomeCareDays() + ", patientWageIndex=" + this.getPatientWageIndex() + ", providerWageIndex=" + this.getProviderWageIndex() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public HospicePaymentData() {
  }
}
