/*
 * Decompiled with CFR 0.152.
 */
package com.constants.batch;

import com.constants.batch.ClaimLevel_IN;
import com.constants.batch.DomainUtils_IN;
import com.constants.code.Opps_EN;
import com.constants.code.Sex_EN;
import com.modal.Diagnosis;
import com.modal.ValueCodes;
import com.modal.claim.Claim;

public enum BatchClaimInput_EN implements ClaimLevel_IN
{
    CLAIM_ID_C(1, 17, 1, "C"){

        @Override
        public void set(Claim claim, String line) {
            claim.getGrouperInput().setClaimID(DomainUtils_IN.getValue(line, this.getBufferStart(), this.getEnd()));
        }

        @Override
        public String print(Claim claim, String line) {
            return DomainUtils_IN.domainStringCombine(line, claim.getGrouperInput().getClaimID(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    AGE(18, 3, 1, "C"){

        @Override
        public void set(Claim claim, String line) {
            claim.getGrouperInput().setAge(DomainUtils_IN.getValue(line, this.getBufferStart(), this.getEnd()));
        }

        @Override
        public String print(Claim claim, String line) {
            return DomainUtils_IN.domainStringCombine(line, claim.getGrouperInput().getAge(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    SEX(21, 1, 1, "C"){

        @Override
        public void set(Claim claim, String line) {
            switch (DomainUtils_IN.getValue(line, this.getBufferStart(), this.getEnd())) {
                case "0": {
                    claim.getGrouperInput().setSex(Sex_EN.UNKNOWN.toString());
                    break;
                }
                case "1": {
                    claim.getGrouperInput().setSex(Sex_EN.MALE.toString());
                    break;
                }
                case "2": {
                    claim.getGrouperInput().setSex(Sex_EN.FEMALE.toString());
                    break;
                }
                default: {
                    claim.getGrouperInput().setSex(line.substring(this.getBufferStart(), this.getEnd()));
                }
            }
        }

        @Override
        public String print(Claim claim, String line) {
            String v = claim.getGrouperInput().getSex();
            if (claim.getGrouperInput().getSex() != null) {
                switch (claim.getGrouperInput().getSex()) {
                    case "UNKNOWN": {
                        v = "0";
                        break;
                    }
                    case "MALE": {
                        v = "1";
                        break;
                    }
                    case "FEMALE": {
                        v = "2";
                    }
                }
            }
            return DomainUtils_IN.domainStringCombine(line, v, this.getBufferStart(), this.getEnd());
        }
    }
    ,
    FROM_DATE(22, 8, 1, "C"){

        @Override
        public void set(Claim claim, String line) {
            claim.getGrouperInput().setFromDate(DomainUtils_IN.getValue(line, this.getBufferStart(), this.getEnd()));
        }

        @Override
        public String print(Claim claim, String line) {
            return DomainUtils_IN.domainStringCombine(line, claim.getGrouperInput().getFromDate(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    THROUGH_DATE(30, 8, 1, "C"){

        @Override
        public void set(Claim claim, String line) {
            claim.getGrouperInput().setThroughDate(DomainUtils_IN.getValue(line, this.getBufferStart(), this.getEnd()));
        }

        @Override
        public String print(Claim claim, String line) {
            return DomainUtils_IN.domainStringCombine(line, claim.getGrouperInput().getThroughDate(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    BILL_TYPE(60, 3, 1, "C"){

        @Override
        public void set(Claim claim, String line) {
            claim.getGrouperInput().setBillType(DomainUtils_IN.getValue(line, this.getBufferStart(), this.getEnd()));
        }

        @Override
        public String print(Claim claim, String line) {
            return DomainUtils_IN.domainStringCombine(line, claim.getGrouperInput().getBillType(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    NPI(63, 13, 1, "C"){

        @Override
        public void set(Claim claim, String line) {
            claim.getGrouperInput().setMedicalRecordNumber(DomainUtils_IN.getValue(line, this.getBufferStart(), this.getEnd()));
        }

        @Override
        public String print(Claim claim, String line) {
            return DomainUtils_IN.domainStringCombine(line, claim.getGrouperInput().getMedicalRecordNumber(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    OSCAR(76, 6, 1, "C"){

        @Override
        public void set(Claim claim, String line) {
            claim.getGrouperInput().setOSCARNumber(DomainUtils_IN.getValue(line, this.getBufferStart(), this.getEnd()));
        }

        @Override
        public String print(Claim claim, String line) {
            return DomainUtils_IN.domainStringCombine(line, claim.getGrouperInput().getOSCARNumber(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    PATIENT_STATUS(82, 2, 1, "C"){

        @Override
        public void set(Claim claim, String line) {
            claim.getGrouperInput().setPatientStatus(DomainUtils_IN.getValue(line, this.getBufferStart(), this.getEnd()));
        }

        @Override
        public String print(Claim claim, String line) {
            return DomainUtils_IN.domainStringCombine(line, claim.getGrouperInput().getPatientStatus(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    OPPS(84, 1, 1, "C"){

        @Override
        public void set(Claim claim, String line) {
            switch (DomainUtils_IN.getValue(line, this.getBufferStart(), this.getEnd()).trim()) {
                case "1": {
                    claim.getGrouperInput().setOpps(Opps_EN.OPPS.toString());
                    break;
                }
                case "2": {
                    claim.getGrouperInput().setOpps(Opps_EN.NONOPPS.toString());
                    break;
                }
                case "": {
                    claim.getGrouperInput().setOpps(" ");
                    break;
                }
                default: {
                    claim.getGrouperInput().setOpps(line.substring(this.getBufferStart(), this.getEnd()));
                }
            }
        }

        @Override
        public String print(Claim claim, String line) {
            String v = claim.getGrouperInput().getOpps();
            switch (claim.getGrouperInput().getOpps()) {
                case "OPPS": {
                    v = "1";
                    break;
                }
                case "NONOPPS": {
                    v = "2";
                }
            }
            return DomainUtils_IN.domainStringCombine(line, v, this.getBufferStart(), this.getEnd());
        }
    }
    ,
    OCCURRENCE_CODES(85, 60, 2, "C"){

        @Override
        public void set(Claim claim, String line) {
            claim.getGrouperInput().getOccurrenceCodes().clear();
            for (int i2 = this.getBufferStart(); i2 < this.getEnd(); i2 += this.getElementSize()) {
                claim.getGrouperInput().getOccurrenceCodes().add(line.substring(i2, i2 + this.getElementSize()));
            }
        }

        @Override
        public String print(Claim claim, String line) {
            StringBuilder tmpSB = new StringBuilder();
            for (String s : claim.getGrouperInput().getOccurrenceCodes()) {
                tmpSB.append(s);
            }
            return DomainUtils_IN.domainStringCombine(line, tmpSB.toString(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    CONDITION_CODES(145, 60, 2, "C"){

        @Override
        public void set(Claim claim, String line) {
            claim.getGrouperInput().getConditionCodes().clear();
            for (int i2 = this.getBufferStart(); i2 < this.getEnd(); i2 += this.getElementSize()) {
                claim.getGrouperInput().getConditionCodes().add(line.substring(i2, i2 + this.getElementSize()));
            }
        }

        @Override
        public String print(Claim claim, String line) {
            StringBuilder tmpSB = new StringBuilder();
            for (String s : claim.getGrouperInput().getConditionCodes()) {
                tmpSB.append(s);
            }
            return DomainUtils_IN.domainStringCombine(line, tmpSB.toString(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    USER_DATA_C(205, 95, 1, "C"){

        @Override
        public void set(Claim claim, String line) {
            claim.getGrouperInput().setcUserData(DomainUtils_IN.getValue(line, this.getBufferStart(), this.getEnd()));
        }

        @Override
        public String print(Claim claim, String line) {
            return DomainUtils_IN.domainStringCombine(line, claim.getGrouperInput().getcUserData(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    BT_83x(-1, -1, -1, "C"){

        @Override
        public void set(Claim claim, String line) {
            if (claim.getGrouperInput().getOpps() != null) {
                try {
                    if (Opps_EN.valueOf((String)claim.getGrouperInput().getOpps()).componentValue == 1) {
                        claim.getGrouperInput().setBillType83Flag("0");
                    } else {
                        claim.getGrouperInput().setBillType83Flag("2");
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }

        @Override
        public String print(Claim claim, String line) {
            return line;
        }
    }
    ,
    RVDX(18, 24, 8, "D"){

        @Override
        public void set(Claim claim, String line) {
            claim.getGrouperInput().getRvdxList().clear();
            for (int i2 = this.getBufferStart(); i2 < this.getEnd(); i2 += this.getElementSize()) {
                claim.getGrouperInput().getRvdxList().add((Object)new Diagnosis(line.substring(i2, i2 + this.getElementSize()), ""));
            }
        }

        @Override
        public String print(Claim claim, String line) {
            StringBuilder tmpSB = new StringBuilder();
            for (Diagnosis s : claim.getGrouperInput().getRvdxList()) {
                tmpSB.append(s.getCode());
            }
            return DomainUtils_IN.domainStringCombine(line, tmpSB.toString(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    PDX(42, 8, 8, "D"){

        @Override
        public void set(Claim claim, String line) {
            claim.getGrouperInput().getPdxList().clear();
            for (int i2 = this.getBufferStart(); i2 < this.getEnd(); i2 += this.getElementSize()) {
                claim.getGrouperInput().getPdxList().add((Object)new Diagnosis(line.substring(i2, i2 + this.getElementSize()), ""));
            }
        }

        @Override
        public String print(Claim claim, String line) {
            StringBuilder tmpSB = new StringBuilder();
            for (Diagnosis s : claim.getGrouperInput().getPdxList()) {
                tmpSB.append(s.getCode());
            }
            return DomainUtils_IN.domainStringCombine(line, tmpSB.toString(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    SDX(50, 192, 8, "D"){

        @Override
        public void set(Claim claim, String line) {
            claim.getGrouperInput().getSdxList().clear();
            for (int i2 = this.getBufferStart(); i2 < this.getEnd(); i2 += this.getElementSize()) {
                claim.getGrouperInput().getSdxList().add((Object)new Diagnosis(line.substring(i2, i2 + this.getElementSize()), ""));
            }
        }

        @Override
        public String print(Claim claim, String line) {
            StringBuilder tmpSB = new StringBuilder();
            for (Diagnosis s : claim.getGrouperInput().getSdxList()) {
                tmpSB.append(s.getCode());
            }
            return DomainUtils_IN.domainStringCombine(line, tmpSB.toString(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    USER_DATA_D(242, 57, 1, "D"){

        @Override
        public void set(Claim claim, String line) {
            claim.getGrouperInput().setdUserData(DomainUtils_IN.getValue(line, this.getBufferStart(), this.getEnd()));
        }

        @Override
        public String print(Claim claim, String line) {
            return DomainUtils_IN.domainStringCombine(line, claim.getGrouperInput().getdUserData(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    VALUE_CODES_E(18, 264, 11, "E"){

        @Override
        public void set(Claim claim, String line) {
            claim.getGrouperInput().getValueCodes().clear();
            for (int i2 = this.getBufferStart(); i2 < this.getEnd(); i2 += this.getElementSize()) {
                claim.getGrouperInput().getValueCodes().add(new ValueCodes(line.substring(i2, i2 + 2), line.substring(i2 + 2, i2 + 11)));
            }
        }

        @Override
        public String print(Claim claim, String line) {
            StringBuilder tmpSB = new StringBuilder();
            int count = 1;
            for (ValueCodes s : claim.getGrouperInput().getValueCodes()) {
                tmpSB.append(s.toDomainString());
                if (count++ != this.getLength() / this.getElementSize()) continue;
                break;
            }
            return DomainUtils_IN.domainStringCombine(line, tmpSB.toString(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    USER_DATA_E(282, 18, 1, "E"){

        @Override
        public void set(Claim claim, String line) {
            claim.getGrouperInput().seteUserData(DomainUtils_IN.getValue(line, this.getBufferStart(), this.getEnd()));
        }

        @Override
        public String print(Claim claim, String line) {
            return DomainUtils_IN.domainStringCombine(line, claim.getGrouperInput().geteUserData(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    VALUE_CODES_F(18, 132, 11, "F"){

        @Override
        public void set(Claim claim, String line) {
            for (int i2 = this.getBufferStart(); i2 < this.getEnd(); i2 += this.getElementSize()) {
                claim.getGrouperInput().getValueCodes().add(new ValueCodes(line.substring(i2, i2 + 2), line.substring(i2 + 2, i2 + 11)));
            }
        }

        @Override
        public String print(Claim claim, String line) {
            StringBuilder tmpSB = new StringBuilder();
            int _F_START_ = 24;
            for (ValueCodes s : claim.getGrouperInput().getValueCodes()) {
                if (claim.getGrouperInput().getValueCodes().indexOf(s) < 24) continue;
                tmpSB.append(s.toDomainString());
            }
            return DomainUtils_IN.domainStringCombine(line, tmpSB.toString(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    USER_DATA_F(150, 150, 1, "F"){

        @Override
        public void set(Claim claim, String line) {
            claim.getGrouperInput().setfUserData(DomainUtils_IN.getValue(line, this.getBufferStart(), this.getEnd()));
        }

        @Override
        public String print(Claim claim, String line) {
            return DomainUtils_IN.domainStringCombine(line, claim.getGrouperInput().getfUserData(), this.getBufferStart(), this.getEnd());
        }
    };

    private final int bufferStart;
    private final int length;
    private final int elementSize;
    private final String line;

    private BatchClaimInput_EN(int bufferStart, int length, int elementSize, String line) {
        this.bufferStart = bufferStart;
        this.length = length;
        this.elementSize = elementSize;
        this.line = line;
    }

    public int getBufferStart() {
        return this.bufferStart;
    }

    public int getEnd() {
        return this.bufferStart + this.length;
    }

    public int getElementSize() {
        return this.elementSize;
    }

    public int getLength() {
        return this.length;
    }

    public String getLine() {
        return this.line;
    }
}

