/*
 * Decompiled with CFR 0.152.
 */
package com.constants.batch;

import com.constants.batch.ClaimOutput_IN;
import com.constants.batch.DomainUtils_IN;
import com.constants.code.Opps_EN;
import com.modal.Edit;
import com.modal.ValueCodes;
import com.modal.claim.Claim;
import java.util.stream.Collectors;

public enum ClaimOutput_EN implements ClaimOutput_IN
{
    CLAIM_PROCESSED_FLAG(18, 1, 1, "M"){

        @Override
        public String print(Claim claim, String line) {
            return DomainUtils_IN.domainStringCombine(line, claim.getGrouperOutput().getClaimProcessedFlag().getValue(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    OVERALL_CLAIM_DISPOSITION(19, 1, 1, "M"){

        @Override
        public String print(Claim claim, String line) {
            return DomainUtils_IN.domainStringCombine(line, claim.getGrouperOutput().getOverallClaimDisposition().getValue(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    CLAIM_REJECTION_DISPOSITION(20, 1, 1, "M"){

        @Override
        public String print(Claim claim, String line) {
            return DomainUtils_IN.domainStringCombine(line, claim.getGrouperOutput().getClaimRejectionDisposition().getValue(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    CLAIM_DENIAL_DISPOSITION(21, 1, 1, "M"){

        @Override
        public String print(Claim claim, String line) {
            return DomainUtils_IN.domainStringCombine(line, claim.getGrouperOutput().getClaimDenialDisposition().getValue(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    RTP_DISPOSITION(22, 1, 1, "M"){

        @Override
        public String print(Claim claim, String line) {
            return DomainUtils_IN.domainStringCombine(line, claim.getGrouperOutput().getClaimRTPDisposition().getValue(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    SUSPENSION_DISPOSITION(23, 1, 1, "M"){

        @Override
        public String print(Claim claim, String line) {
            return DomainUtils_IN.domainStringCombine(line, claim.getGrouperOutput().getClaimSuspensionDisposition().getValue(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    LINE_REJECTION_DISPOSITION(24, 1, 1, "M"){

        @Override
        public String print(Claim claim, String line) {
            return DomainUtils_IN.domainStringCombine(line, claim.getGrouperOutput().getLineItemRejectionDisposition().getValue(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    LINE_DENIAL_DISPOSITION(25, 1, 1, "M"){

        @Override
        public String print(Claim claim, String line) {
            return DomainUtils_IN.domainStringCombine(line, claim.getGrouperOutput().getLineItemDenialDisposition().getValue(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    CLAIM_REJECTION_EDITS(26, 12, 3, "M"){

        @Override
        public String print(Claim claim, String line) {
            return DomainUtils_IN.domainStringCombine(line, claim.getGrouperOutput().getClaimRejectionEdits().stream().map(Edit::getEdit).collect(Collectors.joining("")), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    CLAIM_DENIAL_EDITS(38, 24, 3, "M"){

        @Override
        public String print(Claim claim, String line) {
            return DomainUtils_IN.domainStringCombine(line, claim.getGrouperOutput().getClaimDenialEdits().stream().map(Edit::getEdit).collect(Collectors.joining("")), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    CLAIM_RTP_EDITS(62, 90, 3, "M"){

        @Override
        public String print(Claim claim, String line) {
            return DomainUtils_IN.domainStringCombine(line, claim.getGrouperOutput().getClaimRtpEdits().stream().map(Edit::getEdit).collect(Collectors.joining("")), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    VALUE_CODES(152, 110, 3, "M"){

        @Override
        public String print(Claim claim, String line) {
            return DomainUtils_IN.domainStringCombine(line, claim.getGrouperOutput().getValueCodes().stream().map(ValueCodes::toDomainString).collect(Collectors.joining("")), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    CLAIM_SUSPENSION_EDITS(18, 48, 3, "N"){

        @Override
        public String print(Claim claim, String line) {
            return DomainUtils_IN.domainStringCombine(line, claim.getGrouperOutput().getClaimMedicalSuspendEdits().stream().map(Edit::getEdit).collect(Collectors.joining("")), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    LINE_REJECTION_EDITS(66, 36, 3, "N"){

        @Override
        public String print(Claim claim, String line) {
            return DomainUtils_IN.domainStringCombine(line, claim.getGrouperOutput().getClaimLineItemRejectionEdits().stream().map(Edit::getEdit).collect(Collectors.joining("")), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    LINE_DENIAL_EDITS(102, 18, 3, "N"){

        @Override
        public String print(Claim claim, String line) {
            return DomainUtils_IN.domainStringCombine(line, claim.getGrouperOutput().getClaimLineItemDenialEdits().stream().map(Edit::getEdit).collect(Collectors.joining("")), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    APC_ASC(120, 1, 1, "N"){

        @Override
        public String print(Claim claim, String line) {
            return DomainUtils_IN.domainStringCombine(line, claim.getGrouperOutput().getBufferCompleted(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    NPI(121, 13, 1, "N"){

        @Override
        public String print(Claim claim, String line) {
            return DomainUtils_IN.domainStringCombine(line, claim.getGrouperInput().getMedicalRecordNumber(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    OSCAR(134, 6, 1, "N"){

        @Override
        public String print(Claim claim, String line) {
            return DomainUtils_IN.domainStringCombine(line, claim.getGrouperInput().getOSCARNumber(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    LINE_ITEMS(140, 3, 1, "N"){

        @Override
        public String print(Claim claim, String line) {
            return DomainUtils_IN.domainStringCombine(line, claim.getGrouperOutput().getNumberOfLineItems(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    OCE_VERSION(143, 8, 1, "N"){

        @Override
        public String print(Claim claim, String line) {
            return DomainUtils_IN.domainStringCombine(line, claim.getGrouperOutput().getOceVersionUsed(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    PATIENT_STATUS_CODE(151, 2, 1, "N"){

        @Override
        public String print(Claim claim, String line) {
            return DomainUtils_IN.domainStringCombine(line, claim.getGrouperInput().getPatientStatus(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    OPPS(153, 1, 1, "N"){

        @Override
        public String print(Claim claim, String line) {
            try {
                return DomainUtils_IN.domainStringCombine(line, String.valueOf(Opps_EN.valueOf((String)claim.getGrouperInput().getOpps()).componentValue), this.getBufferStart(), this.getEnd());
            }
            catch (IllegalArgumentException e) {
                return DomainUtils_IN.domainStringCombine(line, claim.getGrouperInput().getOpps(), this.getBufferStart(), this.getEnd());
            }
        }
    }
    ,
    BT_83x(154, 1, 1, "N"){

        @Override
        public String print(Claim claim, String line) {
            return DomainUtils_IN.domainStringCombine(line, claim.getGrouperOutput().getBillTypeX83Flag(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    CONDITION_CODES(155, 20, 2, "N"){

        @Override
        public String print(Claim claim, String line) {
            return DomainUtils_IN.domainStringCombine(line, claim.getGrouperOutput().getPayerConditionCodes().stream().map(Object::toString).collect(Collectors.joining("")), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    RETURN_CODE(175, 2, 1, "N"){

        @Override
        public String print(Claim claim, String line) {
            return DomainUtils_IN.domainStringCombine(line, claim.getGrouperOutput().getReturnCode().getValue(), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    M_USER_DATA(262, 38, 1, "M"){

        @Override
        public String print(Claim claim, String line) {
            return DomainUtils_IN.domainStringCombine(line, new String(new char[this.getLength()]).replace('\u0000', ' '), this.getBufferStart(), this.getEnd());
        }
    }
    ,
    N_USER_DATA(177, 123, 1, "N"){

        @Override
        public String print(Claim claim, String line) {
            return DomainUtils_IN.domainStringCombine(line, new String(new char[this.getLength()]).replace('\u0000', ' '), this.getBufferStart(), this.getEnd());
        }
    };

    private final int bufferStart;
    private final int length;
    private final int elementSize;
    private final String line;

    private ClaimOutput_EN(int bufferStart, int length, int elementSize, String line) {
        this.bufferStart = bufferStart;
        this.length = length;
        this.elementSize = elementSize;
        this.line = line;
    }

    public int getBufferStart() {
        return this.bufferStart;
    }

    public int getEnd() {
        return this.bufferStart + this.length;
    }

    public int getLength() {
        return this.length;
    }

    public String getLine() {
        return this.line;
    }
}

