/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain;

import com.mmmhis.domain.DomainByteArrayFileMap;
import com.mmmhis.domain.DomainEnvironment;
import com.mmmhis.domain.DomainInteger;
import com.mmmhis.domain.DomainString;
import com.mmmhis.domain.DomainVariable;

public final class DomainBit
extends DomainVariable {
    private static final int DMN_BIT_LENGTH = 32;
    public int[] b;
    private int num_bits;
    private int num_segments;

    public static int bitSwitch(DomainBit bit) {
        int index = 0;
        int off = 0;
        int mask = Integer.MIN_VALUE;
        for (int i2 = 0; i2 < bit.num_bits; ++i2) {
            if (mask == 0) {
                mask = Integer.MIN_VALUE;
                ++off;
            }
            if ((bit.b[off] & mask) != 0) {
                return index;
            }
            ++index;
            mask >>>= 1;
        }
        return -1;
    }

    public DomainBit() {
        this.num_bits = 0;
        this.num_segments = 0;
        this.b = new int[1];
    }

    public DomainBit(int nb) {
        this.num_bits = nb;
        this.num_segments = this.num_bits / 32;
        if (this.num_bits % 32 != 0) {
            ++this.num_segments;
        }
        this.b = new int[this.num_segments != 0 ? this.num_segments : 1];
    }

    public DomainBit(int nb, int[] in) {
        this.num_segments = in.length;
        this.num_bits = nb;
        this.b = new int[this.num_segments != 0 ? this.num_segments : 1];
        System.arraycopy(in, 0, this.b, 0, this.num_segments);
    }

    public DomainBit(DomainBit db) {
        this.num_bits = db.num_bits;
        this.num_segments = db.num_segments;
        this.b = new int[this.num_segments != 0 ? this.num_segments : 1];
        System.arraycopy(db.b, 0, this.b, 0, this.num_segments);
    }

    public DomainBit(int nb, DomainBit[] a, int i2) {
        this.DVArray = a;
        this.DVIndex = i2;
        this.num_bits = nb;
        this.num_segments = this.num_bits / 32;
        if (this.num_bits % 32 != 0) {
            ++this.num_segments;
        }
        this.b = new int[this.num_segments != 0 ? this.num_segments : 1];
    }

    public DomainBit(String s) {
        this(new DomainString(s));
    }

    public DomainBit(DomainString s) {
        this.setValue(s);
    }

    public int getNumBits() {
        return this.num_bits;
    }

    public DomainVariable copy() {
        return new DomainBit(this);
    }

    public int compareTo(DomainBit anotherBit) {
        for (int i2 = 0; i2 < this.num_segments; ++i2) {
            if (anotherBit.b[i2] < this.b[i2]) {
                return -1;
            }
            if (anotherBit.b[i2] <= this.b[i2]) continue;
            return 1;
        }
        return 0;
    }

    public int compareTo(Object o) {
        return this.compareTo((DomainBit)o);
    }

    public String toString() {
        DomainString s = new DomainString(this.num_bits);
        int off = 0;
        int mask = Integer.MIN_VALUE;
        for (int i2 = 0; i2 < this.num_bits; ++i2) {
            if (mask == 0) {
                mask = Integer.MIN_VALUE;
                ++off;
            }
            s.append((this.b[off] & mask) != 0 ? (char)'1' : '0');
            mask >>>= 1;
        }
        return s.toString();
    }

    public DomainBit setValue(int[] in) {
        if (in != null && in.length > 0) {
            for (int i2 = 0; i2 < this.num_segments; ++i2) {
                this.b[i2] = i2 < in.length ? in[i2] : 0;
            }
        }
        return this;
    }

    public DomainBit setValue(DomainBit in) {
        return this.setValue(in.b);
    }

    public void getValue(byte[] buffer, int index) {
        int bitwords = 0;
        int bytes = this.num_bits / 8;
        if (this.num_bits % 8 != 0) {
            ++bytes;
        }
        while (bitwords < this.num_segments) {
            long bt = this.b[bitwords++];
            for (int i2 = 3; i2 >= 0 && bytes > 0; --i2, --bytes) {
                long aByte = bt >> i2 * 8 & 0xFFL;
                buffer[index++] = (byte)aByte;
            }
        }
    }

    public DomainVariable setValue(byte[] buffer, int index) {
        int bitwords = 0;
        int bytes = this.num_bits / 8;
        if (this.num_bits % 8 != 0) {
            ++bytes;
        }
        while (bitwords < this.num_segments) {
            long bt = 0L;
            for (int i2 = 3; i2 >= 0 && bytes > 0; --i2, --bytes) {
                long aByte;
                if ((aByte = (long)(buffer[index++] & 0xFF)) < 0L) {
                    aByte = -aByte;
                }
                if ((bt |= aByte << i2 * 8) >= 0L) continue;
                bt = -bt;
            }
            this.b[bitwords++] = (int)bt;
        }
        return this;
    }

    public DomainVariable setValue(DomainByteArrayFileMap buffer, int index) {
        int bitwords = 0;
        int bytes = this.num_bits / 8;
        if (this.num_bits % 8 != 0) {
            ++bytes;
        }
        while (bitwords < this.num_segments) {
            long bt = 0L;
            for (int i2 = 3; i2 >= 0 && bytes > 0; --i2, --bytes) {
                long aByte;
                if ((aByte = (long)(buffer.getByte(index++) & 0xFF)) < 0L) {
                    aByte = -aByte;
                }
                if ((bt |= aByte << i2 * 8) >= 0L) continue;
                bt = -bt;
            }
            this.b[bitwords++] = (int)bt;
        }
        return this;
    }

    private DomainVariable setValue(char[] buffer, int index, int len) {
        int width = this.num_bits;
        for (int i2 = 0; i2 < this.num_segments; ++i2) {
            long mask = 0x80000000L;
            for (int j = 0; j < 32 && width > 0; ++j, --width) {
                if (index < len && buffer[index] == '1') {
                    int n = i2;
                    this.b[n] = (int)((long)this.b[n] | mask);
                } else {
                    int n = i2;
                    this.b[n] = (int)((long)this.b[n] & (mask ^ 0xFFFFFFFFFFFFFFFFL));
                }
                mask >>>= 1;
                if (index >= len) continue;
                ++index;
            }
        }
        return this;
    }

    public DomainVariable setValue(DomainEnvironment _env, String s) {
        _env.LastError.reset();
        if (s == null || s.length() <= 1) {
            _env.LastError.setValue(4);
            this.reset();
            return this;
        }
        char[] chars = s.toCharArray();
        if (chars.length > this.num_bits) {
            _env.LastError.setValue(6);
        }
        for (int i2 = 0; i2 < chars.length; ++i2) {
            if (chars[i2] == '0' || chars[i2] == '1') continue;
            _env.LastError.setValue(1);
            this.reset();
            return this;
        }
        return this.setValue(s.toCharArray(), 0, s.length());
    }

    public DomainVariable setValue(DomainEnvironment _env, DomainString s) {
        _env.LastError.reset();
        if (s == null || s.count <= 1) {
            _env.LastError.setValue(4);
            this.reset();
            return this;
        }
        char[] chars = s.toCharArray();
        if (chars.length > this.num_bits) {
            _env.LastError.setValue(6);
        }
        for (int i2 = 0; i2 < chars.length; ++i2) {
            if (chars[i2] == '0' || chars[i2] == '1') continue;
            _env.LastError.setValue(1);
            this.reset();
            return this;
        }
        return this.setValue(s.value, 0, s.count);
    }

    public DomainVariable setValue(DomainVariable v) {
        if (v instanceof DomainBit) {
            return this.setValue(((DomainBit)v).b);
        }
        if (v instanceof DomainString) {
            return this.setValue(((DomainString)v).value, 0, ((DomainString)v).count);
        }
        return null;
    }

    public DomainBit setValueOR(DomainBit bit) {
        for (int i2 = 0; i2 < this.num_segments; ++i2) {
            int n = i2;
            this.b[n] = this.b[n] | bit.b[i2];
        }
        return this;
    }

    public DomainBit setValueAND(DomainBit bit) {
        for (int i2 = 0; i2 < this.num_segments; ++i2) {
            int n = i2;
            this.b[n] = this.b[n] & bit.b[i2];
        }
        return this;
    }

    public DomainBit setValueEOR(DomainBit bit) {
        for (int i2 = 0; i2 < this.num_segments; ++i2) {
            int n = i2;
            this.b[n] = this.b[n] ^ bit.b[i2];
        }
        return this;
    }

    public DomainBit bitAND(DomainBit bit) {
        DomainBit result = new DomainBit(this.num_bits);
        for (int i2 = 0; i2 < this.num_segments; ++i2) {
            result.b[i2] = this.b[i2] & bit.b[i2];
        }
        return result;
    }

    public DomainBit bitNOT() {
        DomainBit result = new DomainBit(this.num_bits);
        for (int i2 = 0; i2 < this.num_segments; ++i2) {
            long notMask = this.getNotMask(i2);
            result.b[i2] = (int)((long)(~this.b[i2]) & notMask);
        }
        return result;
    }

    private long getNotMask(int index) {
        long mask = 0L;
        long word = 0x80000000L;
        for (int i2 = index * 32; i2 < this.num_bits; ++i2) {
            mask |= word;
            word >>>= 1;
        }
        return mask;
    }

    public DomainBit bitOR(DomainBit bit) {
        DomainBit result = new DomainBit(this.num_bits);
        for (int i2 = 0; i2 < this.num_segments; ++i2) {
            result.b[i2] = this.b[i2] | bit.b[i2];
        }
        return result;
    }

    public DomainBit bitEOR(DomainBit bit) {
        DomainBit result = new DomainBit(this.num_bits);
        for (int i2 = 0; i2 < this.num_segments; ++i2) {
            result.b[i2] = this.b[i2] ^ bit.b[i2];
        }
        return result;
    }

    public DomainBit bitValue(int index) {
        DomainBit rslt = new DomainBit(1, new int[]{index});
        return rslt;
    }

    public boolean equals(DomainBit in) {
        for (int i2 = 0; i2 < this.num_segments; ++i2) {
            if (this.b[i2] == in.b[i2]) continue;
            return false;
        }
        return true;
    }

    public void reset() {
        for (int i2 = 0; i2 < this.num_segments; ++i2) {
            this.b[i2] = 0;
        }
    }

    public boolean isTrue() {
        for (int i2 = 0; i2 < this.num_segments; ++i2) {
            if (this.b[i2] == 0) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.num_bits;
    }

    public int setValueEx(DomainBit bit, int index) {
        int offset = 0;
        int width = this.num_bits;
        for (int i2 = 0; i2 < this.num_segments; ++i2) {
            long mask = 0x80000000L;
            for (int j = 0; j < 32 && width > 0; ++j, --width) {
                if (offset >= index && ((long)bit.b[i2] & mask) != 0L) {
                    this.reset();
                    int n = i2;
                    this.b[n] = (int)((long)this.b[n] | mask);
                    return offset;
                }
                ++offset;
                mask >>>= 1;
            }
        }
        return this.num_bits;
    }

    public int getValue(int index) {
        int segment = index / 32;
        int mask = 1 << 31 - index % 32;
        return (this.b[segment] & mask) != 0 ? 1 : 0;
    }

    public int setValue(int segment, int mask, int v) {
        if (v != 0) {
            int n = segment;
            this.b[n] = this.b[n] | mask;
            return 1;
        }
        int n = segment;
        this.b[n] = this.b[n] & ~mask;
        return 0;
    }

    public int setValue(DomainInteger index, int v) {
        return this.setValue(index.getValue(), v);
    }

    public int setValue(int index, int v) {
        int segment = index / 32;
        int mask = 1 << 31 - index % 32;
        return this.setValue(segment, mask, v);
    }

    public int setValueBmBAND(int offset, int mask, int v) {
        return this.setValue(offset, mask, ((this.b[offset] & mask) != 0 ? 1 : 0) & v);
    }

    public int setValueBmBAND(int index, int v) {
        int segment = index / 32;
        int mask = 1 << 31 - index % 32;
        return this.setValueBmBAND(segment, mask, v);
    }

    public int setValueBmBOR(int offset, int mask, int v) {
        return this.setValue(offset, mask, ((this.b[offset] & mask) != 0 ? 1 : 0) | v);
    }

    public int setValueBmBOR(int index, int v) {
        int segment = index / 32;
        int mask = 1 << 31 - index % 32;
        return this.setValueBmBOR(segment, mask, v);
    }

    public int setValueBmEOR(int offset, int mask, int v) {
        return this.setValue(offset, mask, ((this.b[offset] & mask) != 0 ? 1 : 0) ^ v);
    }

    public int setValueBmEOR(int index, int v) {
        int segment = index / 32;
        int mask = 1 << 31 - index % 32;
        return this.setValueBmEOR(segment, mask, v);
    }

    public int setValueBmEOR(DomainInteger index, int v) {
        int segment = index.getValue() / 32;
        int mask = 1 << 31 - index.getValue() % 32;
        return this.setValueBmEOR(segment, mask, v);
    }

    public DomainVariable getNewInstance(DomainVariable[] a, int i2) {
        return new DomainBit(this.num_bits, (DomainBit[])a, i2);
    }
}

