/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain;

import com.mmmhis.domain.DomainException;
import com.mmmhis.domain.DomainString;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;

public class DomainByteArrayFileMap {
    private static final int NOT_INITIALIZED = -2;
    private static final int NOT_MAPPED = -1;
    private static final int ALL_CACHED = 0;
    private Hashtable pages = new Hashtable();
    private int pageSize;
    private int cachePages;
    private LinkedList lruList;
    private File fd;
    private RandomAccessFile raf;
    private int latestPageNo;
    private byte[] latestPage;
    private int length;

    public DomainByteArrayFileMap(int pageSize) {
        this.pageSize = pageSize;
        this.latestPageNo = -2;
        this.length = -2;
    }

    public DomainByteArrayFileMap(int pageSize, int cachPages, File fd) throws DomainException {
        this(pageSize);
        this.cachePages = cachPages;
        this.lruList = new LinkedList();
        this.fd = fd;
        if (fd != null) {
            try {
                this.raf = new RandomAccessFile(fd, "r");
            }
            catch (FileNotFoundException ex) {
                throw new DomainException(ex);
            }
        }
    }

    public DomainByteArrayFileMap(DomainByteArrayFileMap bafMap) throws DomainException {
        this(bafMap.pageSize);
        this.cachePages = bafMap.cachePages;
        this.lruList = new LinkedList();
        ListIterator i2 = bafMap.lruList.listIterator();
        while (i2.hasNext()) {
            this.lruList.addLast(i2.next());
        }
        Enumeration e = bafMap.pages.keys();
        while (e.hasMoreElements()) {
            Integer key = (Integer)e.nextElement();
            byte[] value = (byte[])bafMap.pages.get(key);
            byte[] page = new byte[value.length];
            System.arraycopy(value, 0, page, 0, value.length);
            this.pages.put(key, page);
        }
        try {
            this.raf = new RandomAccessFile(bafMap.fd, "r");
        }
        catch (FileNotFoundException ex) {
            throw new DomainException(ex);
        }
    }

    public DomainByteArrayFileMap(byte[] buffer) {
        this(buffer.length);
        this.pages.put(new Integer(-1), buffer);
    }

    public byte[] cacheAll() {
        int fileSize = this.length();
        byte[] newBuf = null;
        if (this.pageSize != fileSize) {
            newBuf = new byte[fileSize];
            for (int offset = 0; offset < fileSize; offset += this.pageSize) {
                byte[] page = null;
                int len = Math.min(this.pageSize, fileSize - offset);
                page = (byte[])this.pages.get(new Integer(offset / this.pageSize));
                if (page != null) {
                    System.arraycopy(page, 0, newBuf, offset, len);
                    continue;
                }
                try {
                    this.raf.seek(offset);
                    this.raf.read(newBuf, offset, len);
                    continue;
                }
                catch (IOException ex) {
                    throw new DomainException(ex);
                }
            }
            this.pages = new Hashtable(1);
            this.pages.put(new Integer(0), newBuf);
            this.pageSize = fileSize;
        } else {
            newBuf = this.raf == null ? (byte[])this.pages.get(new Integer(-1)) : (byte[])this.pages.get(new Integer(0));
        }
        this.latestPageNo = -1;
        this.latestPage = newBuf;
        return newBuf;
    }

    public byte[] getPage(int index) {
        int pageNo = -1;
        if (this.raf != null) {
            pageNo = index / this.pageSize;
        }
        if (pageNo != this.latestPageNo) {
            Integer pageNumber = new Integer(pageNo);
            this.latestPage = (byte[])this.pages.get(pageNumber);
            if (this.latestPage == null) {
                this.latestPage = new byte[this.pageSize];
                if (this.raf != null) {
                    try {
                        this.raf.seek(pageNo * this.pageSize);
                        this.raf.read(this.latestPage);
                    }
                    catch (IOException ex) {
                        throw new DomainException(ex);
                    }
                    if (this.lruList.size() == this.cachePages) {
                        this.pages.remove(this.lruList.getFirst());
                        this.lruList.removeFirst();
                    }
                    this.lruList.addLast(pageNumber);
                }
                this.pages.put(pageNumber, this.latestPage);
            }
            this.latestPageNo = pageNo;
        }
        return this.latestPage;
    }

    public void putByte(int index, byte value) {
        byte[] page = this.getPage(index);
        page[index % this.pageSize] = value;
    }

    public void putBytes(int index, byte[] bytes) {
        int length = bytes.length;
        int beginDestPageNo = index / this.pageSize;
        int endDestPageNo = (index + length) / this.pageSize;
        int currSrcPos = 0;
        int currDestPos = index % this.pageSize;
        int currLen = Math.min(length, this.pageSize - currDestPos);
        int bytesCopied = 0;
        for (int pageNo = beginDestPageNo; pageNo <= endDestPageNo; ++pageNo) {
            byte[] currDestPage = this.getPage(index + bytesCopied);
            System.arraycopy(bytes, currSrcPos, currDestPage, currDestPos, currLen);
            currSrcPos += currLen;
            currDestPos = 0;
            currLen = Math.min(this.pageSize, length - (bytesCopied += currLen));
        }
    }

    public byte getByte(int index) throws DomainException {
        byte[] page = this.getPage(index);
        return page[index % this.pageSize];
    }

    public byte[] getBytes(int begin, int count) {
        byte[] bytes = new byte[count];
        int beginSrcPageNo = begin / this.pageSize;
        int endSrcPageNo = (begin + count) / this.pageSize;
        int currSrcPos = begin % this.pageSize;
        int currDestPos = 0;
        int currLen = Math.min(count, this.pageSize - currSrcPos);
        int bytesCopied = 0;
        for (int pageNo = beginSrcPageNo; pageNo <= endSrcPageNo; ++pageNo) {
            byte[] currSrcPage = this.getPage(begin + bytesCopied);
            System.arraycopy(currSrcPage, currSrcPos, bytes, currDestPos, currLen);
            currSrcPos = 0;
            currDestPos += currLen;
            currLen = Math.min(this.pageSize, count - (bytesCopied += currLen));
        }
        return bytes;
    }

    public DomainString getDomainString(int begin) {
        int beginPageNo = begin / this.pageSize;
        int endPageNo = this.length() / this.pageSize;
        int beginIdx = begin;
        int len = 0;
        boolean endFound = false;
        for (int pageNo = beginPageNo; !endFound && pageNo <= endPageNo; ++pageNo) {
            byte[] currPage = this.getPage(begin + len);
            int pageLen = currPage.length;
            for (int idx = beginIdx % pageLen; idx < pageLen; ++idx) {
                if (currPage[idx] == 0) {
                    endFound = true;
                    break;
                }
                ++len;
            }
            beginIdx = begin + len;
        }
        return new DomainString(this, begin, len);
    }

    public int length() throws DomainException {
        if (this.length == -2) {
            if (this.raf != null) {
                try {
                    this.length = (int)this.raf.length();
                }
                catch (IOException ex) {
                    throw new DomainException(ex);
                }
            } else {
                this.length = this.pageSize;
            }
        }
        return this.length;
    }

    public void close() throws DomainException {
        if (this.raf != null) {
            try {
                this.raf.close();
                this.raf = null;
            }
            catch (IOException ex) {
                throw new DomainException(ex);
            }
        }
        this.pages = null;
    }

    public static void arraycopy(DomainByteArrayFileMap src, int srcPos, DomainByteArrayFileMap dest, int destPos, int length) {
        byte[] tmpDest = new byte[length];
        DomainByteArrayFileMap.arraycopy(src, srcPos, tmpDest, 0, length);
        DomainByteArrayFileMap.arraycopy(tmpDest, 0, dest, destPos, length);
    }

    public static void arraycopy(byte[] src, int srcPos, DomainByteArrayFileMap dest, int destPos, int length) {
        int beginDestPageNo = destPos / dest.pageSize;
        int endDestPageNo = (destPos + length) / dest.pageSize;
        int currSrcPos = srcPos;
        int currDestPos = destPos % dest.pageSize;
        int currLen = Math.min(length, dest.pageSize - currDestPos);
        int bytesCopied = 0;
        for (int pageNo = beginDestPageNo; pageNo <= endDestPageNo; ++pageNo) {
            byte[] currDestPage = dest.getPage(destPos + bytesCopied);
            System.arraycopy(src, currSrcPos, currDestPage, currDestPos, currLen);
            currSrcPos += currLen;
            currDestPos = 0;
            currLen = Math.min(dest.pageSize, length - (bytesCopied += currLen));
        }
    }

    public static void arraycopy(DomainByteArrayFileMap src, int srcPos, byte[] dest, int destPos, int length) {
        int beginSrcPageNo = srcPos / src.pageSize;
        int endSrcPageNo = (srcPos + length) / src.pageSize;
        int currSrcPos = srcPos % src.pageSize;
        int currDestPos = destPos;
        int currLen = Math.min(length, src.pageSize - currSrcPos);
        int bytesCopied = 0;
        for (int pageNo = beginSrcPageNo; pageNo <= endSrcPageNo; ++pageNo) {
            byte[] currSrcPage = src.getPage(srcPos + bytesCopied);
            System.arraycopy(currSrcPage, currSrcPos, dest, currDestPos, currLen);
            currSrcPos = 0;
            currDestPos += currLen;
            currLen = Math.min(src.pageSize, length - (bytesCopied += currLen));
        }
    }

    public static void fill(DomainByteArrayFileMap a, int fromIndex, int toIndex, byte value) {
        int fromPageNo = fromIndex / a.pageSize;
        int toPageNo = (toIndex - 1) / a.pageSize;
        int currPos = fromIndex % a.pageSize;
        int bytesFilled = 0;
        for (int pageNo = fromPageNo; pageNo <= toPageNo; ++pageNo) {
            byte[] currPage = a.getPage(fromIndex + bytesFilled);
            int toPos = pageNo < toPageNo ? a.pageSize : (toIndex - 1) % a.pageSize + 1;
            Arrays.fill(currPage, currPos, toPos, value);
            bytesFilled += toPos - currPos;
            currPos = 0;
        }
    }
}

