/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain;

import com.mmmhis.domain.DomainCode;
import com.mmmhis.domain.DomainComponent;
import com.mmmhis.domain.DomainCursor;
import com.mmmhis.domain.DomainEcUtil;
import com.mmmhis.domain.DomainException;
import com.mmmhis.domain.DomainIeFile;
import com.mmmhis.domain.DomainIndirectCall;
import com.mmmhis.domain.DomainInteger;
import com.mmmhis.domain.DomainList;
import com.mmmhis.domain.DomainReferenceToList;
import com.mmmhis.domain.DomainString;
import com.mmmhis.domain.DomainVariable;
import com.mmmhis.domain.DomainVersionLock;
import com.mmmhis.domain.db.DBControl;
import com.mmmhis.domain.db.DBLHandle;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class DomainEnvironment {
    public static final int ERROR_NONE = 0;
    public static final int ERROR_ASCCONV = 1;
    public static final int ERROR_TIMECONV = 2;
    public static final int ERROR_DATECONV = 3;
    public static final int ERROR_EMPTYSTR = 4;
    public static final int ERROR_NOFRAME = 5;
    public static final int ERROR_TOOBIG = 6;
    public static final int ERROR_WIDTH = 7;
    public static final int ERROR_PSTRUCT = 8;
    public static final int ERROR_NODATA = 9;
    public static final int ERROR_MISMATCH = 10;
    public static final int ERROR_UNK_INDEX = 11;
    private static final int FRAME_GATEWAY = 0;
    private static final int FRAME_ATTRIBUTE = 1;
    public static final int STATE_BACKUP = 1;
    public static final int STATE_NOTIFY = 2;
    public static final int STATE_IGNORE = 4;
    public static final int STATE_MESSAGE = 8;
    protected static final int STATE_ENBACKUP = 16;
    protected static final int STATE_AVSAVE = 32;
    protected static final int STATE_GLOBAL = 64;
    protected static final int STATE_CLASS = 128;
    protected static final int KE_STATE_EVENTS = 256;
    private static final String KE_RC_PATH = "Kernel";
    private static final String KE_RC_SHORTDATEDISPLAY = "ShortDateDisplay";
    private static final String KE_RC_LONGDATEDISPLAY = "LongDateDisplay";
    private static final String KE_RC_SHORTTIMEDISPLAY = "ShortTimeDisplay";
    private static final String KE_RC_LONGTIMEDISPLAY = "LongTimeDisplay";
    private static final String KE_RC_SHORTCURRENCYDISPLAY = "ShortCurrencyDisplay";
    private static final String KE_RC_LONGCURRENCYDISPLAY = "LongCurrencyDisplay";
    private static final String IE_RC_PATH = "Interface";
    private static final String IE_RC_DATEOUT = "DateOut";
    private static final String IE_RC_DATEIN = "DateIn";
    private static final String IE_RC_TIMEOUT = "TimeOut";
    private static final String IE_RC_TIMEIN = "TimeIn";
    private static final String IE_RC_CURRENCYOUT = "CurrencyOut";
    protected static final int FLAG_PUTINIT = 1;
    protected static final int FLAG_GETINIT = 2;
    protected static final int FLAG_LOADINIT = 4;
    private static final int KE_MAXSYS = 12;
    private DomainList rootList;
    private DomainList currentList;
    private int state;
    private int notifyAttrib;
    private int notifyValue;
    private DomainCursor input;
    private DomainCursor output;
    private DomainCursor load;
    protected DomainCode CCP;
    protected DomainString AttributePrefix;
    protected DomainInteger LastError;
    private String globalVarsSig;
    private List globalVars;
    private List components;
    private int _classIDCounter;
    private String[] args;
    private DBControl dbControl;
    private byte[] systems = new byte[12];
    public static final String dateFormatShort = "%d %b %Y";
    private String longDateFormat = "%d %B %Y";
    private String shortDateFormat = "%d %b %Y";
    private String longTimeFormat = "%d %B %Y %H:%M";
    private String shortTimeFormat = "%d %b %Y %H:%M";
    private String dateInFormat = "%m%d%Y";
    private String dateOutFormat = "%m%d%Y";
    private String timeInFormat = "%m%d%Y%oH%oM";
    private String timeOutFormat = "%m%d%Y%H%M";
    private String shortCurrencyFormat = "%n";
    private String longCurrencyFormat = "%i";
    private String currencyOutFormat = "%!+^n";
    private Map staticDSs = new TreeMap();
    static final String DELIMS = "{},\t\r\n";

    public DomainEnvironment(String[] args) throws DomainException {
        this.args = args;
        this.components = new LinkedList();
        this.currentList = this.rootList = new DomainList(this);
        this.CCP = new DomainCode();
        this.AttributePrefix = new DomainString();
        this.LastError = new DomainInteger();
        this.dbControl = new DBControl(this, false, true);
    }

    public void registerComponent(DomainComponent comp, String[] resourceList, boolean isMain) throws DomainException {
        this.registerComponent(comp, resourceList, isMain, null);
    }

    public void registerComponent(DomainComponent comp, String[] resourceList, boolean isMain, String resourceFile) throws DomainException {
        this.components.add(comp);
        String str = "";
        comp.setClassID(this._classIDCounter++);
        comp.setResourceList(resourceList);
        if (!DomainVersionLock.hasBeenChecked()) {
            throw new DomainException("domainRuntime.jar compatibility check failed");
        }
        if (this.globalVars == null) {
            this.globalVarsSig = comp.getSignature();
        } else if (this.globalVarsSig.length() < comp.getSignature().length() || !this.globalVarsSig.startsWith(comp.getSignature().substring(0, comp.getSignature().length() - 2))) {
            throw new DomainException(785, new Object[]{comp.getClass().getName()});
        }
        if (this.dbControl.openResources(!isMain, this.args, resourceFile)) {
            String[] sVar = new String[1];
            this.dbControl.getVarResource(KE_RC_PATH, KE_RC_LONGDATEDISPLAY, sVar, this.longDateFormat);
            this.longDateFormat = sVar[0];
            this.dbControl.getVarResource(KE_RC_PATH, KE_RC_SHORTDATEDISPLAY, sVar, this.shortDateFormat);
            this.shortDateFormat = sVar[0];
            this.dbControl.getVarResource(KE_RC_PATH, KE_RC_LONGTIMEDISPLAY, sVar, this.longTimeFormat);
            this.longTimeFormat = sVar[0];
            this.dbControl.getVarResource(KE_RC_PATH, KE_RC_SHORTTIMEDISPLAY, sVar, this.shortTimeFormat);
            this.shortTimeFormat = sVar[0];
            this.dbControl.getVarResource(KE_RC_PATH, KE_RC_SHORTCURRENCYDISPLAY, sVar, "%n");
            this.shortCurrencyFormat = sVar[0];
            this.dbControl.getVarResource(KE_RC_PATH, KE_RC_LONGCURRENCYDISPLAY, sVar, "%n");
            this.longCurrencyFormat = sVar[0];
            this.dbControl.getVarResource(IE_RC_PATH, IE_RC_DATEIN, sVar, this.dateInFormat);
            this.dateInFormat = sVar[0];
            this.dbControl.getVarResource(IE_RC_PATH, IE_RC_DATEOUT, sVar, this.dateOutFormat);
            this.dateOutFormat = sVar[0];
            this.dbControl.getVarResource(IE_RC_PATH, IE_RC_TIMEIN, sVar, this.timeInFormat);
            this.timeInFormat = sVar[0];
            this.dbControl.getVarResource(IE_RC_PATH, IE_RC_TIMEOUT, sVar, this.timeOutFormat);
            this.timeOutFormat = sVar[0];
            this.dbControl.getVarResource(IE_RC_PATH, IE_RC_CURRENCYOUT, sVar, this.currencyOutFormat);
            this.currencyOutFormat = sVar[0];
        }
        if (resourceList != null) {
            int i2 = 0;
            while (i2 + 1 < resourceList.length && resourceList[i2] != null && resourceList[i2 + 1] != null) {
                this.dbControl.putResource(resourceList[i2], resourceList[i2 + 1]);
                i2 += 2;
            }
        }
        if (this.load != null) {
            this.dbControl.sharedClose();
            this.dbControl.sharedOpen();
        }
    }

    public void getGlobalVariables(Object[] vars) {
        vars[0] = this.CCP;
        vars[1] = this.AttributePrefix;
        vars[2] = this.LastError;
        if (this.globalVars == null) {
            this.globalVars = new ArrayList();
            for (int i2 = 3; i2 < vars.length; ++i2) {
                this.globalVars.add(vars[i2]);
            }
        } else {
            int i3 = 3;
            int j = 0;
            while (i3 < vars.length && i3 < this.globalVars.size()) {
                vars[i3] = this.globalVars.get(j);
                ++i3;
                ++j;
            }
        }
    }

    public DomainIndirectCall getComponentMethod(String name, Class[] types, boolean ignore) throws DomainException {
        Method method = null;
        Object obj = null;
        Iterator iter = this.components.iterator();
        while (method == null && iter.hasNext()) {
            try {
                obj = iter.next();
                method = obj.getClass().getMethod(name, types);
                return new DomainIndirectCall(method, obj);
            }
            catch (NoSuchMethodException ex) {
            }
        }
        if (!ignore) {
            throw new DomainException("Gateway not found: " + name);
        }
        return new DomainIndirectCall(ignore);
    }

    public Object executeGatewayFrame(String name, Object[] args, boolean ignore, Object rType) throws DomainException {
        return this.executeFrame(0, name, args, null, ignore, false, rType);
    }

    public Object executeExecuteFrame(String name, Object[] args, DomainString leftover, Object rType) throws DomainException {
        return this.executeFrame(0, name, args, leftover, true, true, rType);
    }

    public Object executeAttributeFrame(String name, Object[] args, DomainString leftover, boolean ignore, boolean partial, Object rType) throws DomainException {
        return this.executeFrame(1, name, args, leftover, ignore, partial, rType);
    }

    public Object executeFrame(int frameType, String name, Object[] args, DomainString leftover, boolean ignore, boolean partial, Object rType) throws DomainException {
        Method method = null;
        Object obj = null;
        int count = 0;
        int results = 0;
        int[] ptr = new int[1];
        boolean[] branch = new boolean[1];
        name = name.replace('_', '.');
        byte[] nameBytes = name.getBytes();
        Class[] types = null;
        this.LastError.reset();
        name = name.replace('.', '_');
        if (args != null) {
            types = new Class[args.length];
            for (int i2 = 0; i2 < args.length; ++i2) {
                types[i2] = args[i2].getClass();
            }
        }
        Iterator iter = this.components.iterator();
        while (method == null && iter.hasNext()) {
            try {
                byte[] framesIndex;
                obj = iter.next();
                switch (frameType) {
                    default: {
                        framesIndex = ((DomainComponent)obj).getGatewayFrameIndex();
                        break;
                    }
                    case 1: {
                        framesIndex = ((DomainComponent)obj).getAttributeFrameIndex();
                        types[2] = Class.forName("java.lang.Object");
                    }
                }
                if (framesIndex != null) {
                    ptr[0] = 0;
                    results = DomainEcUtil.ecIndex(nameBytes, framesIndex, 0, ptr, leftover, branch);
                    switch (results) {
                        case 0: {
                            method = obj.getClass().getMethod(name, types);
                            break;
                        }
                        case 2: {
                            if (!partial) break;
                            method = obj.getClass().getMethod(name.substring(0, name.length() - leftover.length()), types);
                            break;
                        }
                    }
                    if (method != null) {
                        if (count != 0) {
                            ((LinkedList)this.components).remove(obj);
                            ((LinkedList)this.components).addFirst(obj);
                        }
                        this.LastError.reset();
                        return method.invoke(obj, args);
                    }
                    this.LastError.setValue(5);
                }
            }
            catch (Exception ex) {
                if (ex.getCause() instanceof DomainException) {
                    throw (DomainException)ex.getCause();
                }
                throw new DomainException(ex.getCause());
            }
            ++count;
        }
        if (!ignore) {
            throw new DomainException("Gateway not found: " + name);
        }
        return rType;
    }

    public DomainString getDomainString(String value) {
        if (this.staticDSs.containsKey(value)) {
            return (DomainString)this.staticDSs.get(value);
        }
        DomainString str = new DomainString(value);
        this.staticDSs.put(value, str);
        return str;
    }

    public void setNotify(int attrib, int value) {
        this.notifyAttrib = attrib;
        this.notifyValue = value;
    }

    public DomainCursor getOutputCursor() throws DomainException {
        if (this.output == null) {
            this.output = new DomainCursor(this.dbControl);
            this.output.setIEFile(new DomainIeFile(this.dbControl, 1));
            this.output.getIeFile().open(IE_RC_PATH, true);
        }
        return this.output;
    }

    public DomainCursor getInputCursor() throws DomainException {
        if (this.input == null) {
            this.input = new DomainCursor(this.dbControl);
            this.input.setIEFile(new DomainIeFile(this.dbControl, 0));
            this.input.getIeFile().open(IE_RC_PATH, true);
        }
        return this.input;
    }

    public DomainCursor getLoadCursor() throws DomainException {
        if (this.load == null) {
            if (!this.dbControl.isOpen) {
                this.dbControl.open();
            }
            this.load = new DomainCursor(this.dbControl);
            this.load.setDBLHandle(new DBLHandle(this.dbControl));
            this.load.getDBLHandle().openLoad(null, false);
        }
        return this.load;
    }

    public DBControl getDBControl() {
        return this.dbControl;
    }

    public int getNotifyAttribute() {
        return this.notifyAttrib;
    }

    public int getNotifyValue() {
        return this.notifyValue;
    }

    public void setState(int value) {
        this.state |= value;
    }

    public void clearState(int value) {
        this.state &= ~value;
    }

    public boolean isState(int value) {
        return (this.state & value) == value;
    }

    public DomainList getCurrentList() {
        return this.currentList;
    }

    public DomainReferenceToList refToCurrentList() {
        return new DomainReferenceToList(this.currentList);
    }

    public DomainReferenceToList setCurrentList(DomainList list) {
        DomainReferenceToList refToOldList = new DomainReferenceToList(this.currentList);
        this.currentList = list;
        return refToOldList;
    }

    public String getShortCurrencyFormat() {
        return this.shortCurrencyFormat;
    }

    public void setShortCurrencyFormat(String format) {
        this.shortCurrencyFormat = format;
    }

    public String getLongCurrencyFormat() {
        return this.longCurrencyFormat;
    }

    public void setLongCurrencyFormat(String format) {
        this.longCurrencyFormat = format;
    }

    public String getShortDateFormat() {
        return this.shortDateFormat;
    }

    public void setShortDateFormat(String format) {
        this.shortDateFormat = format;
    }

    public String getLongDateFormat() {
        return this.longDateFormat;
    }

    public void setLongDateFormat(String format) {
        this.longDateFormat = format;
    }

    public String getShortTimeFormat() {
        return this.shortTimeFormat;
    }

    public void setShortTimeFormat(String format) {
        this.shortTimeFormat = format;
    }

    public String getLongTimeFormat() {
        return this.longTimeFormat;
    }

    public void setLongTimeFormat(String format) {
        this.longTimeFormat = format;
    }

    public String getDateInFormat() {
        return this.dateInFormat;
    }

    public String getDateOutFormat() {
        return this.dateOutFormat;
    }

    public String getTimeInFormat() {
        return this.timeInFormat;
    }

    public String getTimeOutFormat() {
        return this.timeOutFormat;
    }

    public String getCurrencyOutFormat() {
        return this.currencyOutFormat;
    }

    public void setSystems(boolean on, int[] list) {
        for (int i2 = 0; i2 < list.length; ++i2) {
            int val = list[i2];
            if (on) {
                int n = val / 8;
                this.systems[n] = (byte)(this.systems[n] | 128 >> val % 8);
                continue;
            }
            int n = val / 8;
            this.systems[n] = (byte)(this.systems[n] & ~(128 >> val % 8));
        }
    }

    public boolean checkSystems(int[] list) {
        for (int i2 = 0; i2 < list.length; ++i2) {
            int val = list[i2];
            if ((this.systems[val / 8] & 128 >> val % 8) == 0) continue;
            return true;
        }
        return false;
    }

    public void setValueFromString(String str, Object[] objs) {
        this.setValueFromString(str.toCharArray(), str.length(), objs);
    }

    public void setValueFromString(DomainString str, Object[] objs) {
        this.setValueFromString(str.value, str.count, objs);
    }

    private void setValueFromString(char[] buffer, int length, Object[] objs) {
        int begin = 0;
        int end = 0;
        int i2 = 0;
        int depth = 0;
        int count = 0;
        boolean looking_for_comma = false;
        for (i2 = 0; i2 < length && buffer[i2] != '\u0000'; ++i2) {
        }
        char[] temp = new char[i2];
        System.arraycopy(buffer, 0, temp, 0, temp.length);
        buffer = temp;
        this.LastError.reset();
        while (begin < length && count < objs.length) {
            switch (buffer[begin]) {
                case '{': {
                    if (looking_for_comma) {
                        this.LastError.setValue(8);
                        return;
                    }
                    if (depth == 0) {
                        ++depth;
                        break;
                    }
                    ++depth;
                    block13: for (end = begin + 1; end < length; ++end) {
                        switch (buffer[end]) {
                            case '{': {
                                ++depth;
                                continue block13;
                            }
                            case '}': {
                                --depth;
                                continue block13;
                            }
                        }
                        if (depth != 1) continue;
                        DomainString newStr = new DomainString(buffer, begin, end - begin);
                        if (objs[count].getClass().isArray()) {
                            this.setValueFromString(newStr.value, newStr.count, (Object[])objs[count]);
                        } else {
                            ((DomainVariable)objs[count]).setValue(this, newStr);
                        }
                        begin = end - 1;
                        break;
                    }
                    looking_for_comma = true;
                    if (this.LastError.getValue() == 0 || this.LastError.getValue() == 4) break;
                    this.LastError.setValue(8);
                    break;
                }
                case '}': {
                    --depth;
                    ++count;
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                case ',': {
                    looking_for_comma = false;
                    ++count;
                    break;
                }
                case '\"': {
                    if (looking_for_comma) {
                        this.LastError.setValue(8);
                        return;
                    }
                    for (end = ++begin; end < length && buffer[end] != '\"'; ++end) {
                    }
                    ((DomainVariable)objs[count]).setValue(this, new DomainString(buffer, begin, end - begin));
                    begin = end;
                    break;
                }
                default: {
                    if (looking_for_comma) {
                        this.LastError.setValue(8);
                        return;
                    }
                    for (end = begin; end < length && DELIMS.indexOf(buffer[end]) == -1; ++end) {
                    }
                    ((DomainVariable)objs[count]).setValue(this, new DomainString(buffer, begin, end - begin));
                    begin = end - 1;
                }
            }
            if (this.LastError.getValue() != 0 && this.LastError.getValue() != 4) {
                return;
            }
            ++begin;
        }
        if (begin < length && depth != 0) {
            this.LastError.setValue(8);
        } else if (begin < length && depth == 0) {
            this.LastError.setValue(6);
        }
        if (count < objs.length) {
            while (count < objs.length) {
                if (!objs[count].getClass().isArray()) {
                    ((DomainVariable)objs[count]).reset();
                } else {
                    for (i2 = 0; i2 < Array.getLength(objs[count]); ++i2) {
                        ((DomainVariable)Array.get(objs[count], i2)).reset();
                    }
                }
                ++count;
            }
        }
    }
}

