/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain;

import com.mmmhis.domain.DomainCodeQuery;
import com.mmmhis.domain.DomainComponent;
import com.mmmhis.domain.DomainEnvironment;
import com.mmmhis.domain.DomainInteger;
import com.mmmhis.domain.DomainInvalidCodeException;
import com.mmmhis.domain.DomainList;
import com.mmmhis.domain.DomainNullCodeException;
import com.mmmhis.domain.DomainReferenceToList;
import com.mmmhis.domain.DomainString;
import com.mmmhis.domain.DomainVariable;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public final class DomainListEntry
extends DomainVariable
implements Comparable {
    private static final int EXP_ATTR_VIRTUAL = 1;
    private static final int EXP_ATTR_CLASS = 2;
    private static final int KE_ATTR_NAME = 4;
    private static final int KE_ATTR_CNAME = 8;
    public static final int KeSTATUS_NORMAL = 0;
    public static final int KeSTATUS_CODENOTFOUND = 130;
    private HashMap attributes;
    private boolean deleted;
    private DomainList list;
    private DomainString name;
    private DomainListEntry previous;
    private DomainListEntry next;

    public DomainListEntry(String name) {
        this.attributes = null;
        this.deleted = false;
        this.list = null;
        this.previous = null;
        this.next = null;
        this.name = new DomainString(name);
    }

    public DomainListEntry(DomainString name) {
        this.attributes = null;
        this.deleted = false;
        this.list = null;
        this.previous = null;
        this.next = null;
        this.name = new DomainString(name);
    }

    DomainListEntry(DomainString name, int numberOfAttributes) {
        this.attributes = numberOfAttributes != 0 ? new HashMap(numberOfAttributes) : null;
        this.deleted = false;
        this.list = null;
        this.previous = null;
        this.next = null;
        this.name = new DomainString(name);
    }

    public DomainListEntry getNext() {
        return this.next;
    }

    public void setNext(DomainListEntry e) {
        this.next = e;
    }

    public DomainListEntry getPrevious() {
        return this.previous;
    }

    public void setPrevious(DomainListEntry e) {
        this.previous = e;
    }

    public DomainList getList() {
        return this.list;
    }

    public void setList(DomainList l) {
        this.list = l;
    }

    public DomainListEntry remove() throws DomainInvalidCodeException {
        if (this.deleted) {
            throw new DomainInvalidCodeException();
        }
        if (this.previous != null) {
            this.previous.next = this.next;
        }
        if (this.next != null) {
            this.next.previous = this.previous;
        }
        this.list.setCCP(this.next);
        this.list.decCount();
        if (this.list.getFirst() == this) {
            this.list.setFirst(this.next);
        }
        if (this.list.getLast() == this) {
            this.list.setLast(this.previous);
        }
        return this.next;
    }

    public void delete() throws DomainInvalidCodeException {
        if (this.deleted) {
            throw new DomainInvalidCodeException();
        }
        this.remove();
        this.deleted = true;
    }

    public DomainString getName() throws DomainInvalidCodeException {
        if (this.deleted) {
            throw new DomainInvalidCodeException();
        }
        return this.name;
    }

    public DomainString getNameSure() {
        return this.name;
    }

    public DomainString getCname() throws DomainInvalidCodeException {
        if (this.deleted) {
            throw new DomainInvalidCodeException();
        }
        int i2 = this.name.indexOf(".");
        if (i2 != 0) {
            int count = this.name.length() - ++i2;
            return this.name.substring(i2, count);
        }
        return this.name;
    }

    public DomainReferenceToList getRefToList() throws DomainInvalidCodeException {
        if (this.deleted) {
            throw new DomainInvalidCodeException();
        }
        return new DomainReferenceToList(this.list);
    }

    public DomainListEntry plus(int num, boolean reverse) throws DomainInvalidCodeException {
        if (this.deleted) {
            throw new DomainInvalidCodeException();
        }
        if (num < 0) {
            reverse = !reverse;
            num = -num;
        }
        DomainListEntry start = this;
        while (start != null && num != 0) {
            --num;
            start = reverse ? start.previous : start.next;
        }
        return start;
    }

    public DomainListEntry occur(int num) throws DomainInvalidCodeException {
        boolean reverse;
        if (this.deleted) {
            throw new DomainInvalidCodeException();
        }
        DomainListEntry start = this;
        if (num == 0) {
            return null;
        }
        if (num < 0) {
            reverse = true;
            num = -num;
        } else {
            reverse = false;
        }
        while (start != null) {
            if (this.name.compareTo(start.name) == 0) {
                --num;
            }
            if (num < 1) break;
            start = reverse ? start.previous : start.next;
        }
        return start;
    }

    public Object getAttribute(DomainComponent classID, int key, boolean simple) throws DomainInvalidCodeException {
        return this.getAttribute(classID, key, DomainListEntry.instrumentAttrKey(classID._classID, key), simple);
    }

    public Object getAttribute(DomainComponent classID, int key, Integer ikey, boolean simple) throws DomainInvalidCodeException {
        Object obj;
        if (this.deleted) {
            throw new DomainInvalidCodeException();
        }
        if (this.attributes == null) {
            this.attributes = new HashMap(4);
        }
        if ((obj = this.attributes.get(ikey)) == null) {
            if (simple) {
                return null;
            }
            obj = classID.newAttributeInstance(key);
            if ((key & 1) != 0) {
                Object[] args = new Object[3];
                DomainString leftover = new DomainString();
                args[0] = new DomainInteger(key);
                args[1] = leftover;
                args[2] = obj;
                this.list.getEnv().executeAttributeFrame(this.name.toString(), args, leftover, true, true, null);
            }
            this.attributes.put(ikey, obj);
        }
        switch (key) {
            case 4: {
                ((DomainString)obj).setValue(this.getName());
                break;
            }
            case 8: {
                ((DomainString)obj).setValue(this.getCname());
            }
        }
        return obj;
    }

    public void removeAttribute(DomainComponent classID, int key) throws DomainInvalidCodeException {
        if (this.deleted) {
            throw new DomainInvalidCodeException();
        }
        Integer ikey = DomainListEntry.instrumentAttrKey(classID._classID, key);
        if (this.attributes != null) {
            this.attributes.remove(ikey);
        }
    }

    public void reset() {
    }

    public void resetAttributes() throws DomainInvalidCodeException {
        if (this.deleted) {
            throw new DomainInvalidCodeException();
        }
        if (this.attributes != null) {
            this.attributes.clear();
        }
    }

    public void resetClassAttributes(DomainComponent classID) {
        Integer ikey = DomainListEntry.instrumentAttrKey(classID._classID, 2);
        if (this.attributes != null) {
            Iterator i2 = this.attributes.keySet().iterator();
            while (i2.hasNext()) {
                Integer val = (Integer)i2.next();
                if ((val & ikey) != ikey) continue;
                i2.remove();
            }
        }
    }

    public DomainVariable setValue(DomainVariable v) {
        return this;
    }

    public DomainVariable setValue(DomainEnvironment _env, String s) {
        return this;
    }

    public DomainVariable setValue(DomainEnvironment _env, DomainString s) {
        return this;
    }

    private static Object copyAttribute(Object src) {
        if (src.getClass().isArray()) {
            Object a = Array.get(src, 0);
            Object dest = Array.newInstance(a.getClass(), Array.getLength(src));
            for (int i2 = 0; i2 < Array.getLength(src); ++i2) {
                Object s = Array.get(src, i2);
                Array.set(dest, i2, DomainListEntry.copyAttribute(s));
            }
            return dest;
        }
        return ((DomainVariable)src).copy();
    }

    void addAttribute(DomainComponent classID, int key, Object src) throws DomainInvalidCodeException {
        Object obj;
        if (this.deleted) {
            throw new DomainInvalidCodeException();
        }
        Integer ikey = DomainListEntry.instrumentAttrKey(classID._classID, key);
        if (this.attributes == null) {
            this.attributes = new HashMap(4);
        }
        if ((obj = this.attributes.get(ikey)) != null) {
            this.attributes.remove(obj);
        }
        this.attributes.put(ikey, DomainListEntry.copyAttribute(src));
    }

    void markAsDeleted() throws DomainInvalidCodeException {
        if (this.deleted) {
            throw new DomainInvalidCodeException();
        }
        this.deleted = true;
    }

    public boolean isTrue() {
        return !this.deleted;
    }

    public boolean isIn(DomainList l) {
        return l.contains(this);
    }

    public boolean isIn(DomainCodeQuery q) {
        DomainListEntry e;
        while ((e = q.next()) != null) {
            if (this != e) continue;
            return true;
        }
        return false;
    }

    public int compareTo(Object o) {
        if (o == null) {
            throw new DomainNullCodeException();
        }
        return this.name.compareTo(((DomainListEntry)o).getName());
    }

    public DomainVariable copy() {
        DomainListEntry newCode;
        if (this.attributes != null) {
            newCode = new DomainListEntry(this.name, this.attributes.size());
            Set attributeSet = this.attributes.keySet();
            for (Integer ikey : attributeSet) {
                Object attributeVariable = this.attributes.get(ikey);
                try {
                    newCode.attributes.put(ikey, DomainListEntry.copyAttribute(attributeVariable));
                }
                catch (DomainInvalidCodeException e) {}
            }
        } else {
            newCode = new DomainListEntry(this.name);
        }
        return newCode;
    }

    private DomainListEntry copy(int[] attributes, DomainComponent classID) {
        DomainListEntry newCode;
        if (attributes != null) {
            newCode = new DomainListEntry(this.name, attributes.length);
            for (int i2 = 0; i2 < attributes.length; ++i2) {
                Object tempAttribute = this.getAttribute(classID, attributes[i2], true);
                if (tempAttribute == null) continue;
                newCode.addAttribute(classID, attributes[i2], tempAttribute);
            }
        } else {
            newCode = new DomainListEntry(this.name);
        }
        return newCode;
    }

    public int copy(DomainListEntry to, int[] attributes, DomainComponent classID) {
        if (to == null) {
            return 130;
        }
        DomainListEntry newCode = this.copy(attributes, classID);
        newCode.insert(to);
        return 0;
    }

    public int copy(DomainList to, int[] attributes, DomainComponent classID) {
        if (to == null) {
            return 130;
        }
        DomainListEntry newCode = this.copy(attributes, classID);
        to.append(newCode);
        return 0;
    }

    public boolean equals(Object c) {
        return this == c;
    }

    public boolean execute(DomainString leftover, String prefix, Object[] args) {
        String code = this.name.getValue();
        int smax = code.indexOf(46);
        if (smax > 0) {
            String frame = prefix + code.substring(smax);
            return this.list.getEnv().executeExecuteFrame(frame, args, leftover, null) != null;
        }
        return false;
    }

    public DomainListEntry modify40(String command, boolean dup) {
        DomainString s = this.name.modify(command);
        if (dup) {
            DomainListEntry e = new DomainListEntry(s);
            if (this.next != null) {
                e.insert(this.next);
            } else {
                this.list.append(e);
            }
        } else {
            this.name = s;
        }
        return this;
    }

    public void modify(String command, boolean dup) {
        this.modify40(command, dup);
    }

    void move(DomainList destinationList) throws DomainInvalidCodeException {
        this.remove();
        destinationList.append(this);
    }

    void move(DomainListEntry e) {
        if (e != this) {
            this.remove();
            this.insert(e);
        }
    }

    public DomainListEntry insert(String name) {
        DomainListEntry e = new DomainListEntry(name);
        return e.insert(this);
    }

    public DomainListEntry insert(DomainListEntry where) {
        this.next = where;
        this.previous = where.previous;
        where.previous = this;
        if (this.previous != null) {
            this.previous.next = this;
        }
        this.list = where.getList();
        if (this.list.getFirst() == where) {
            this.list.setFirst(this);
        }
        this.list.incCount();
        return this;
    }

    public String toString() {
        try {
            return this.getCname().toString();
        }
        catch (DomainInvalidCodeException e) {
            throw new NullPointerException();
        }
    }

    public int toInt() throws DomainInvalidCodeException {
        int count = 0;
        DomainListEntry start = this.list.getFirst();
        while (start != null) {
            ++count;
            if (start == this) {
                return count;
            }
            start = start.next;
        }
        return 0;
    }

    protected static Integer instrumentAttrKey(int classid, int key) {
        return new Integer((key & 2) != 0 ? (classid << 18) + key : key);
    }

    public DomainVariable getNewInstance(DomainVariable[] a, int i2) {
        return null;
    }
}

