/*
 * Decompiled with CFR 0.152.
 */
package com.mmmhis.domain.db;

import com.mmmhis.domain.DomainEcNumber;
import com.mmmhis.domain.DomainEcUtil;
import com.mmmhis.domain.DomainEnvironment;
import com.mmmhis.domain.DomainException;
import com.mmmhis.domain.DomainString;
import com.mmmhis.domain.OSEnvironment;
import com.mmmhis.domain.db.DBCmdLine;
import com.mmmhis.domain.db.DBFile;
import com.mmmhis.domain.db.DBHandle;
import com.mmmhis.domain.ec.EcQuark;
import com.mmmhis.domain.td.TDFile;
import com.mmmhis.domain.td.TDHandle;
import com.mmmhis.domain.td.TDSection;
import com.mmmhis.domain.td.TDTag;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public final class DBControl {
    public static final String BIN_PATH = "bin/" + OSEnvironment.getHostname() + "/";
    public static final String SITE_PATH = "site/";
    public static final String USER_PATH = "site/";
    public static final String KB_PATH = "kb/";
    public static final String LOCAL_DIRECTORY = "./";
    public static final String SYSTEM_FILE = "dvm.rcs";
    public static final String SITE_FILE = "dvm_site.rcs";
    public static final String USER_FILE = "dvm_user.rcs";
    public static final String CMDLINE_RULE_FILE = "dvm.rul";
    public static final String LE_EXE = OSEnvironment.isWindows() ? "le.exe" : "le";
    public static final String SCT_EXE = OSEnvironment.isWindows() ? "sct.exe" : "sct";
    public static final String DbENVROOT = "_3MHIS";
    public static final String DbRC_PATH = "Database";
    public static final String DbRC_CACHEPAGES = "Database/CachePages";
    public static final int DbDF_CACHEPAGES = 20;
    public static final String DbRC_AUXCACHEPAGES = "Database/AuxCachePages";
    public static final int DbDF_AUXCACHEPAGES = 12;
    public static final String DbRC_FILE = "Database/file";
    public static final String DbRC_APPLICATION = "Database/Application";
    public static final String DbDF_APPLICATION = "shell";
    public static final String DbRC_AUXRCS = "Database/RCS";
    public static final String DbRC_AUXRCSPATH = "Database/RCSPath";
    public static final String DbRC_DATABASE = "Database/Path";
    public static final String DbRC_EXEPATH = "Database/ExePath";
    public static final String DbRC_NO_RCS = "Database/NoRCS";
    public static final String DbRC_SITE_PATH = "Database/SitePath";
    public static final String DbRC_USER_PATH = "Database/UserPath";
    public static final String DbRC_MEMLOAD = "Database/MemLoad";
    public static final String DbRC_MEMMAP = "Database/MemMap";
    public static final String DbRC_TBL_CACHEPAGES = "Database/TblCachePages";
    public static final int DbDF_TBL_CACHEPAGES = 10;
    public static final String DbRC_RESOURCE_EDIT = "Database/ResourceEdit";
    public static final String DbRC_PATHNAME = "Path";
    public static final String DbRC_TYPE = "Type";
    public static final String DbRC_TABLE = "tbl";
    public static final String DbRC_LINKED = "ctl";
    public static final String DbRC_RESOURCE = "rcs";
    public static final String DbRC_RUNTIME = "rtm";
    public static final String DbRC_BACKUP = "backup";
    public static final String DbRC_SHARE = "share";
    public static final String DbRC_ORIGPATH = "origpath";
    public static final String DbRC_TBLSIZE = "tblsize";
    public static final String DbRC_READONLY = "readonly";
    public static final String DbRC_ORAUSER = "Database/OraUser";
    public static final String DbRC_SESSIONID = "Database/OraSessionID";
    public static final String DbRC_CACHESIZE = "Database/OraCacheSize";
    public static final String DB_RESOURCE_ROOT = "/RESOURCE";
    public static final int EcCI_MATCH = 0;
    public static final int EcCI_SHORT = 1;
    public static final int EcCI_LONG = 2;
    public static final int EcCI_NONE = 3;
    public boolean isOpen = false;
    int resCreates;
    DBFile[] list;
    TDFile resFile;
    TDHandle resHandle;
    String rootPath;
    int explCache;
    int auxCache;
    int count;
    boolean ignoreKb;
    int lru;
    boolean failOnError;
    int errorCode;
    int memLoad;
    int memMapped;
    int tblCachePages;
    DomainEnvironment env;
    EcQuark ecQuark;

    public DBControl(DomainEnvironment env, boolean ignoreKb, boolean failOnError) {
        this.env = env;
        this.ignoreKb = ignoreKb;
        this.failOnError = failOnError;
    }

    public DomainEnvironment getEnv() {
        return this.env;
    }

    public EcQuark getEcQuark() {
        return this.ecQuark;
    }

    public void setEcQuark(EcQuark ecQuark) {
        this.ecQuark = ecQuark;
    }

    public DBFile getFile(int index) {
        return this.list[index];
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public int getMemLoad() {
        return this.memLoad;
    }

    public int getMemMapped() {
        return this.memMapped;
    }

    public int getTblCachePages() {
        return this.tblCachePages;
    }

    public TDHandle getTDHandle() {
        return this.resHandle;
    }

    public TDFile getTDFile() {
        return this.resFile;
    }

    public boolean openResources(boolean empty, String[] args, String resourceFile) throws DomainException {
        ++this.resCreates;
        if (this.resCreates != 1) {
            return false;
        }
        this.resFile = TDFile.open(true);
        this.resHandle = new TDHandle();
        this.resHandle.attachFile(this.resFile);
        if (this.resFile == null) {
            throw new DomainException(1289);
        }
        if (!empty) {
            String[] sitePath = new String[1];
            String[] userPath = new String[1];
            this.getSitePath(sitePath, userPath, args);
            this.cmdLineResources(args);
            this.getResource(DbRC_SITE_PATH, sitePath, sitePath[0]);
            this.getResource(DbRC_USER_PATH, userPath, userPath[0]);
            String[] arg = new String[1];
            this.getResource(DbRC_APPLICATION, arg, DbDF_APPLICATION);
            String appStr = arg[0].toUpperCase();
            if (!this.getResource(DbRC_NO_RCS, null, null)) {
                this.openResourceFile(USER_FILE, userPath[0], appStr);
            }
            if (!this.getResource(DbRC_NO_RCS, null, null)) {
                this.openResourceFile(SITE_FILE, sitePath[0], appStr);
            }
            if (!this.getResource(DbRC_NO_RCS, null, null)) {
                this.openResourceFile(SYSTEM_FILE, KB_PATH, appStr);
            }
        }
        if (resourceFile != null) {
            try {
                this.openResourceFile(resourceFile, "");
            }
            catch (DomainException e) {
                // empty catch block
            }
        }
        return true;
    }

    void getSitePath(String[] sitePath, String[] userPath, String[] args) {
        this.setRootPath();
        this.openResourceFile(SYSTEM_FILE, KB_PATH, DbDF_APPLICATION);
        this.getResource(DbRC_SITE_PATH, sitePath, "site/");
        if (!sitePath[0].endsWith(File.separator)) {
            sitePath[0] = sitePath[0] + File.separator;
        }
        this.getResource(DbRC_USER_PATH, userPath, "site/");
        if (!userPath[0].endsWith(File.separator)) {
            userPath[0] = userPath[0] + File.separator;
        }
        this.resHandle.deleteHandle();
        this.resHandle = null;
        this.resFile = TDFile.open(true);
        this.resHandle = new TDHandle();
        this.resHandle.attachFile(this.resFile);
    }

    public void cmdLineResources(String[] args) throws DomainException {
        if (args.length <= 1) {
            this.setRootPath();
            return;
        }
        boolean[] matched = new boolean[args.length];
        for (int i2 = 0; i2 < DBCmdLine.DefaultRules.length; ++i2) {
            this.cmdLineCheckResource(args, DBCmdLine.DefaultRules[i2], matched);
        }
        this.setRootPath();
        String path = this.getProgramPath(KB_PATH, CMDLINE_RULE_FILE, false);
        if (path != null) {
            File file = null;
            try {
                String line;
                file = new File(path);
                BufferedReader reader = new BufferedReader(new FileReader(file));
                while ((line = reader.readLine()) != null) {
                    int begin;
                    if (line.length() == 0) continue;
                    int end = begin = 0;
                    int len = line.length();
                    while (begin < len && Character.isWhitespace(line.charAt(begin))) {
                        ++begin;
                    }
                    if (len == begin || len > begin && line.charAt(begin) == '%') continue;
                    for (end = begin; end < len && !Character.isWhitespace(line.charAt(end)); ++end) {
                    }
                    DBCmdLine cmdLine = new DBCmdLine(null, null, null, 0);
                    cmdLine.setSwitchName(line.substring(begin, end));
                    for (begin = end; begin < len && Character.isWhitespace(line.charAt(begin)); ++begin) {
                    }
                    for (end = begin; end < len && !Character.isWhitespace(line.charAt(end)); ++end) {
                    }
                    cmdLine.setTagPathName(line.substring(begin, end));
                    if (end >= len) continue;
                    for (begin = end; begin < len && Character.isWhitespace(line.charAt(begin)); ++begin) {
                    }
                    if (begin >= len) continue;
                    for (end = begin; end < len && !Character.isWhitespace(line.charAt(end)); ++end) {
                    }
                    cmdLine.setType(line.substring(begin, end));
                    if (end < len) {
                        for (begin = end; begin < len && Character.isWhitespace(line.charAt(begin)); ++begin) {
                        }
                        if (begin < len) {
                            for (end = begin; end < len && !Character.isWhitespace(line.charAt(end)); ++end) {
                            }
                            cmdLine.setTagValue(line.substring(begin, end));
                        }
                    }
                    this.cmdLineCheckResource(args, cmdLine, matched);
                }
            }
            catch (FileNotFoundException ex) {
                throw new DomainException(1281, new Object[]{path});
            }
            catch (IOException ex) {
                throw new DomainException(1282, new Object[]{path, new Long(file.length())});
            }
        }
        for (int i3 = 0; i3 < args.length; ++i3) {
            if (matched[i3]) continue;
            System.out.println("Runtime Warning: " + new DomainException(1292, new Object[]{args[i3]}).getMessage());
        }
        String[] tag = new String[1];
        if (this.getResource(DbRC_AUXRCS, tag, null)) {
            this.openResourceFile(tag[0], "site/", null);
        }
    }

    public void cmdLineCheckResource(String[] args, DBCmdLine cmdLine, boolean[] matched) throws DomainException {
        block7: for (int i2 = 0; i2 < args.length; ++i2) {
            switch (cmdLine.type) {
                case 2: {
                    if (!args[i2].equalsIgnoreCase(cmdLine.switchName)) continue block7;
                    matched[i2] = true;
                    matched[++i2] = true;
                    if (i2 >= args.length) {
                        throw new DomainException(0, new Object[]{cmdLine.switchName});
                    }
                    this.putResource(cmdLine.tagPathName, args[i2]);
                    continue block7;
                }
                case 0: {
                    if (!args[i2].equalsIgnoreCase(cmdLine.switchName)) continue block7;
                    matched[i2] = true;
                    this.putResource(cmdLine.tagPathName, cmdLine.tagValue);
                    continue block7;
                }
                case 4: {
                    int len = cmdLine.switchName.length();
                    if (args[i2].length() != len || !args[i2].substring(0, len).equalsIgnoreCase(cmdLine.switchName)) continue block7;
                    matched[i2] = true;
                    this.putResource(cmdLine.tagPathName, cmdLine.tagValue);
                    continue block7;
                }
                case 1: {
                    int len = cmdLine.switchName.length();
                    if (args[i2].length() != len || !args[i2].substring(0, len).equalsIgnoreCase(cmdLine.switchName)) continue block7;
                    matched[i2] = true;
                    this.putResource(cmdLine.tagPathName, args[i2].substring(len - 1));
                    continue block7;
                }
                case 3: {
                    if (!args[i2].equalsIgnoreCase(cmdLine.switchName)) continue block7;
                    matched[i2] = true;
                    while (i2 < args.length) {
                        matched[i2++] = true;
                        this.putResource(cmdLine.tagPathName, args[i2]);
                    }
                    continue block7;
                }
            }
        }
    }

    void openResourceFile(String fileName, String partialPath, String application) throws DomainException {
        String path = this.getProgramPath(partialPath, fileName, false);
        if (path != null) {
            this.openResourceFile(path, application);
        }
    }

    void openResourceFile(String path, String application) throws DomainException {
        if (this.openResourceSimple(path, application, this.resHandle) != 0) {
            throw new DomainException(1281, new Object[]{path});
        }
    }

    int openResourceSimple(String path, String application, TDHandle handle) throws DomainException {
        File file = new File(path);
        if (!file.exists()) {
            return 7;
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            handle.seekToRoot();
            if (handle.parse(reader, "<EOR>", '=', application) != 102) {
                throw new DomainException(1288, new Object[]{path});
            }
        }
        catch (FileNotFoundException ex) {
            throw new DomainException(1282, new Object[]{path, new Long(file.length())});
        }
        return 0;
    }

    boolean getResource(String tagPathName, String[] tagValue, String defValue) {
        this.resHandle.seekToRoot();
        TDTag[] returnTag = new TDTag[1];
        int status = this.resHandle.findTag(tagPathName, returnTag);
        if (tagValue != null) {
            tagValue[0] = status == 0 ? returnTag[0].getValue() : defValue;
        }
        return status == 0;
    }

    int getIntResource(String tagPathName, int[] tagValue, int defValue) {
        String[] local = new String[1];
        boolean results = this.getResource(tagPathName, local, "");
        tagValue[0] = results ? Integer.parseInt(local[0]) : defValue;
        return results ? 1 : 0;
    }

    public boolean getVarResource(String sectionPathName, String tagName, String[] tagValue, String defValue) {
        TDTag tag;
        if (sectionPathName != null && !this.resHandle.getSection().getName().equals(sectionPathName)) {
            this.resHandle.seekToRoot();
            this.resHandle.setPositionToPath(sectionPathName, false, null);
        }
        TDSection section = this.resHandle.getSection();
        tagValue[0] = defValue;
        if (section != null && tagName != null && (tag = section.findTag(tagName.toUpperCase())) != null) {
            tagValue[0] = tag.getValue();
            return true;
        }
        return false;
    }

    public boolean getIntVarResource(String sectionPathName, String tagName, int[] tagValue, int defValue) {
        TDTag tag;
        if (sectionPathName != null && !this.resHandle.getSection().getName().equals(sectionPathName)) {
            this.resHandle.seekToRoot();
            this.resHandle.setPositionToPath(sectionPathName, false, null);
        }
        TDSection section = this.resHandle.getSection();
        tagValue[0] = defValue;
        if (section != null && tagName != null && (tag = section.findTag(tagName.toUpperCase())) != null) {
            tagValue[0] = Integer.parseInt(tag.getValue());
            return true;
        }
        return false;
    }

    public void putResource(String tagPathName, String tagValue) {
        this.resHandle.seekToRoot();
        TDTag[] returnTag = new TDTag[1];
        int status = this.resHandle.newTag(tagPathName, tagValue, returnTag);
    }

    void setRootPath() {
        String exePath;
        String localPath = null;
        String[] envPath = new String[1];
        if (!this.getResource(DbRC_AUXRCSPATH, envPath, null)) {
            envPath[0] = OSEnvironment.getProperty(DbENVROOT);
        }
        localPath = envPath[0] != null ? (envPath[0].lastIndexOf(File.separator) != envPath[0].length() - 1 ? envPath[0] + File.separator : envPath[0]) : ((exePath = new File("").getAbsolutePath()) != null ? exePath + File.separator : "");
        this.rootPath = localPath;
    }

    String getProgramPath(String partialPath, String fileName, boolean usePath) {
        String pathName = this.rootPath + partialPath + fileName;
        if (new File(pathName).exists()) {
            return pathName;
        }
        pathName = fileName;
        if (new File(pathName).exists()) {
            return pathName;
        }
        if (usePath) {
            String[] exePath = new String[1];
            if (this.getResource(DbRC_EXEPATH, exePath, null) && new File(pathName = exePath[0] + fileName).exists()) {
                return pathName;
            }
            return this.fileNameSearchEnv(fileName, "PATH", null);
        }
        pathName = partialPath;
        if (new File(pathName = pathName + fileName).exists()) {
            return pathName;
        }
        return null;
    }

    String fileNameSearchEnv(String fileName, String path, String defaultPath) {
        boolean justFileName;
        String returnPath = null;
        boolean bl = justFileName = fileName.indexOf(File.separator) == -1;
        if (new File(fileName).exists()) {
            returnPath = fileName;
        } else if (justFileName && path != null) {
            String pathName;
            String envVar = OSEnvironment.getProperty(path);
            StringTokenizer st = new StringTokenizer(envVar, OSEnvironment.getEnvPathDelim());
            boolean found = false;
            while (st.hasMoreTokens()) {
                pathName = st.nextToken() + File.separator + fileName;
                if (!new File(pathName).exists()) continue;
                found = true;
                returnPath = pathName;
                break;
            }
            if (!found && defaultPath != null && new File(pathName = defaultPath + File.separator + fileName).exists()) {
                returnPath = pathName;
            }
        }
        return returnPath;
    }

    public void open() throws DomainException {
        int[] iVar = new int[1];
        this.isOpen = true;
        this.memLoad = 2;
        this.memMapped = 1;
        this.getIntResource(DbRC_MEMLOAD, iVar, this.memLoad);
        switch (iVar[0]) {
            case 0: 
            case 1: 
            case 2: {
                this.memLoad = iVar[0];
                break;
            }
        }
        this.getIntResource(DbRC_MEMMAP, iVar, this.memMapped);
        switch (iVar[0]) {
            case 0: 
            case 1: 
            case 2: {
                this.memMapped = iVar[0];
                break;
            }
        }
        this.getIntResource(DbRC_TBL_CACHEPAGES, iVar, 10);
        this.tblCachePages = iVar[0];
        this.getIntResource(DbRC_CACHEPAGES, iVar, 20);
        this.explCache = iVar[0];
        this.getIntResource(DbRC_AUXCACHEPAGES, iVar, 12);
        this.auxCache = iVar[0];
        this.sharedOpen();
    }

    public void close() {
        this.sharedClose();
        if (this.resCreates == 0) {
            return;
        }
        --this.resCreates;
        if (this.resCreates > 0) {
            return;
        }
        if (this.resHandle != null) {
            this.resHandle.deleteHandle();
            this.resHandle = null;
        }
        if (this.resFile != null) {
            this.resFile.close();
            this.resFile = null;
        }
        if (this.rootPath != null) {
            this.rootPath = null;
        }
    }

    public int DbFileMapfp(int index) {
        return this.getFile(index).getMapfp();
    }

    public void sharedOpen() throws DomainException {
        if (this.resHandle.setPositionToPath("/Database", false, null) == 0) {
            TDSection root = this.resHandle.getSection();
            this.count = root.fileCount(this);
            this.resHandle.seekToRoot();
            this.list = new DBFile[this.count + 1];
            if (this.count > 0) {
                this.lru = 1;
                for (int next = 1; next < this.count + 1; ++next) {
                    this.list[next] = new DBFile();
                    if (next >= this.count) continue;
                    this.list[next].lru = next + 1;
                }
            }
            int[] nextArr = new int[]{1};
            root.fileListBuild(this, nextArr);
            root.open(this, this.failOnError);
        }
    }

    public void sharedClose() throws DomainException {
        if (this.list != null) {
            for (int i2 = 1; i2 <= this.count; ++i2) {
                DBFile dbFile = this.list[i2];
                dbFile.close(true);
            }
        }
        this.list = null;
        this.count = 0;
        this.resHandle.getSection().setUserData(0);
    }

    public String resolvePathName(String path, boolean edit, String[] arg) {
        String result;
        if (path != null && path.length() > 1 && path.charAt(0) == '$') {
            String[] sVar = new String[1];
            if (edit) {
                this.getResource(DbRC_RESOURCE_EDIT, sVar, this.rootPath);
            } else {
                sVar[0] = this.rootPath;
            }
            result = sVar[0] + path.substring(1);
        } else {
            result = path;
        }
        int ptrIndex = result.indexOf(44);
        if (ptrIndex != -1) {
            if (arg != null) {
                arg[0] = result.substring(ptrIndex + 1);
                arg[0] = arg[0].trim();
            }
            result = result.substring(0, result.indexOf(44));
        } else if (arg != null) {
            arg[0] = null;
        }
        return result;
    }

    public int getGateway(String name, DBHandle frame, DomainString leftover, int magic) throws DomainException {
        int results = this.findGateway(name, frame, leftover, magic);
        if (results == 0 || results == 2) {
            this.getFrame(frame);
            return results;
        }
        return results;
    }

    int findGateway(String name, DBHandle frame, DomainString leftover, int magic) throws DomainException {
        int i2 = this.lru;
        DBFile previous = null;
        int results = 3;
        while (i2 != 0) {
            DBFile dbFile = this.list[i2];
            if (dbFile.open && magic == dbFile.magic) {
                frame.fd = i2;
                frame.ptr = dbFile.index;
                results = dbFile.prefix.indexOf(name, (int)name.charAt(0)) == -1 ? this.searchIndex(frame, name, leftover) : 3;
                if (results == 0 || results == 2 && leftover != null) {
                    if (previous != null) {
                        previous.lru = dbFile.lru;
                        dbFile.lru = this.lru;
                        this.lru = i2;
                    }
                    return results;
                }
                if (dbFile.magic == 5 && this.notesSearchLinear(i2, name, frame)) {
                    return 0;
                }
            }
            i2 = dbFile.lru;
            previous = dbFile;
        }
        return results;
    }

    public boolean getFrame(DBHandle fd) throws DomainException {
        int cache;
        boolean results = false;
        DBFile dbFile = this.list[fd.fd];
        int n = cache = dbFile.magic == 1 ? this.explCache : this.auxCache;
        if (dbFile.mappedFile != null) {
            if (!dbFile.open) {
                throw new DomainException(1294, new Object[]{dbFile.name, new Long(dbFile.mappedFile.length())});
            }
            fd.mappedBuf = dbFile.mappedFile;
            fd.bufIndex = fd.ptr - dbFile.offset;
            DomainEcNumber.EcSkipNumber(fd);
            return true;
        }
        if (dbFile.unmappedFile != null) {
            if (!dbFile.open) {
                throw new DomainException(1294, new Object[]{dbFile.name, new Long(dbFile.unmappedFile.length)});
            }
            fd.unmappedBuf = dbFile.unmappedFile;
            fd.bufIndex = fd.ptr - dbFile.offset;
            DomainEcNumber.EcSkipNumber(fd);
            return true;
        }
        return results;
    }

    int searchIndex(DBHandle fd, String name, DomainString leftover) throws DomainException {
        boolean[] branch = new boolean[1];
        int results = 0;
        do {
            this.getFrame(fd);
            int[] ptr = new int[]{fd.ptr};
            results = fd.mappedBuf != null ? DomainEcUtil.ecIndex(name.getBytes(), fd.mappedBuf, fd.bufIndex, ptr, leftover, branch) : DomainEcUtil.ecIndex(name.getBytes(), fd.unmappedBuf, fd.bufIndex, ptr, leftover, branch);
            fd.ptr = ptr[0];
        } while (results != 3 && results != 1 && branch[0]);
        return results;
    }

    boolean notesSearchLinear(int fd, String name, DBHandle handle) throws DomainException {
        int[] count = new int[1];
        DBFile dbFile = this.list[fd];
        handle.fd = fd;
        handle.ptr = dbFile.linear;
        this.getFrame(handle);
        if (handle.mappedBuf != null) {
            while (handle.mappedBuf.getByte(handle.bufIndex) != 0) {
                int begin;
                int end = begin = handle.bufIndex;
                while (handle.mappedBuf.getByte(end) != 0) {
                    ++end;
                }
                String lname = new String(handle.mappedBuf.getBytes(begin, end - begin));
                if (name.equals(lname)) {
                    DomainEcNumber.EcGetNumber(handle.mappedBuf, handle.bufIndex, count);
                    handle.bufIndex += count[0];
                    return true;
                }
                DomainEcNumber.EcSkipNumber(handle.mappedBuf, handle.bufIndex, count);
                handle.bufIndex += count[0];
            }
        } else {
            while (handle.unmappedBuf[handle.bufIndex] != 0) {
                int begin;
                int end = begin = handle.bufIndex;
                while (handle.unmappedBuf[end] != 0) {
                    ++end;
                }
                String lname = new String(handle.unmappedBuf, begin, end - begin);
                if (name.equals(lname)) {
                    DomainEcNumber.EcGetNumber(handle.unmappedBuf, handle.bufIndex, count);
                    handle.bufIndex += count[0];
                    return true;
                }
                DomainEcNumber.EcSkipNumber(handle.unmappedBuf, handle.bufIndex, count);
                handle.bufIndex += count[0];
            }
        }
        return false;
    }
}

